/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.sql;

import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.rules.AbstractRule;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.core.model.MetadataHelper;
import com.ibm.cognos.aurora.core.model.RelationalDataItems;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLColumn;
import com.ibm.cognos.aurora.qls.query.planner.rules.sql.SQLQueryRule;
import com.ibm.cognos.aurora.qls.query.queryspec.AxisNodeMap;
import com.ibm.cognos.aurora.qls.query.queryspec.AxisSpecification;
import com.ibm.cognos.aurora.qls.query.queryspec.SelectionActionAttribute;

public class ConvertAttributeToSQLColumn
extends SQLQueryRule {
    public ConvertAttributeToSQLColumn() {
        this.mName = "Convert an attribute node to SQLColumn node.";
        this.mPassNumbers = new int[]{1};
        this.mTypes = new int[]{7};
        this.mMode = AbstractRule.Mode.TOP_DOWN;
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!ConvertAttributeToSQLColumn.hasRelationalDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with a relational data source.", trace);
            return false;
        }
        this.traceNodeCondition(true, "SelectionActionAttribute needs to be converted to SQLColumn.", trace);
        return true;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SelectionActionAttribute selectAttribute = (SelectionActionAttribute)node;
        INode attribute = selectAttribute.getAttribute();
        IDataItem dataItem = MetadataHelper.getDefaultDataItem((INode)attribute);
        AxisNodeMap map = new AxisNodeMap(attribute);
        AxisSpecification axisSpec = (AxisSpecification)node.getAncestorOfType(2);
        axisSpec.getNodeList().add(map);
        SQLColumn column = (SQLColumn)nodeFactory.createNode(3004);
        column.setTableName(RelationalDataItems.getTableName((IDataItem)dataItem));
        column.setName(RelationalDataItems.getColumnName((IDataItem)dataItem));
        column.setDataItem(dataItem);
        column.setAxisNodeMap(map);
        node.exchange((IXQEQueryNode)column, true);
    }
}

