/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.sql;

import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.query.queryspec.expression.ESetFunction;
import com.ibm.cognos.aurora.api.query.queryspec.expression.ICategoryMetricNode;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.rules.AbstractRule;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.core.model.MetadataHelper;
import com.ibm.cognos.aurora.core.model.RelationalDataItems;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLColumn;
import com.ibm.cognos.aurora.qls.query.planner.rules.sql.SQLQueryRule;
import com.ibm.cognos.aurora.qls.query.queryspec.SetFunction;

public class ConvertCategoryMetricToSQLColumn
extends SQLQueryRule {
    public ConvertCategoryMetricToSQLColumn() {
        this.mName = "Convert a category/metric node to an SQLColumn node.";
        this.mPassNumbers = new int[]{1};
        this.mTypes = new int[]{8};
        this.mMode = AbstractRule.Mode.TOP_DOWN;
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        if (!ConvertCategoryMetricToSQLColumn.hasRelationalDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with a relational data source.", trace);
            return false;
        }
        IXQEQueryNode parent = node.getParent();
        boolean bl = status = node.getParent().getType() != 16 && (parent.getType() != 14 || ((SetFunction)parent).getFunctionType() != ESetFunction.LASTPERIODS);
        if (status) {
            this.traceNodeCondition(true, "ICategoryMetricNode needs to be converted to an SQL column.", trace);
        } else {
            this.traceNodeCondition(false, "ICategoryMetricNode does not need to be converted to an SQL column.", trace);
        }
        return status;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        ICategoryMetricNode cmNode = (ICategoryMetricNode)node;
        INode iNode = cmNode.getNode();
        IDataItem dataItem = MetadataHelper.getDefaultDataItem((INode)iNode);
        SQLColumn column = (SQLColumn)nodeFactory.createNode(3004);
        column.setTableName(RelationalDataItems.getTableName((IDataItem)dataItem));
        column.setName(RelationalDataItems.getColumnName((IDataItem)dataItem));
        column.setDataItem(dataItem);
        node.exchange((IXQEQueryNode)column, true);
    }
}

