/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.sql;

import com.ibm.cognos.aurora.api.model.ENodeType;
import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.IEdge;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.query.queryspec.IAggregationSpecification;
import com.ibm.cognos.aurora.api.query.queryspec.expression.EAggregationFunction;
import com.ibm.cognos.aurora.api.smd.kb.IConcept;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.rules.AbstractRule;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.core.model.MetadataHelper;
import com.ibm.cognos.aurora.core.model.NavigationHelper;
import com.ibm.cognos.aurora.core.model.RelationalDataItems;
import com.ibm.cognos.aurora.qls.query.data.model.CountMetric;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLAggregate;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLColumn;
import com.ibm.cognos.aurora.qls.query.planner.rules.sql.SQLQueryRule;
import com.ibm.cognos.aurora.qls.query.queryspec.AxisNodeMap;
import com.ibm.cognos.aurora.qls.query.queryspec.AxisSpecification;
import com.ibm.cognos.aurora.qls.query.queryspec.QuerySpecification;
import com.ibm.cognos.aurora.qls.query.queryspec.SelectionActionMetrics;
import com.ibm.cognos.aurora.qls.query.queryspec.SelectionSpecification;
import java.util.List;

public class ConvertMetricToSQLAggregate
extends SQLQueryRule {
    private final MetricPlaceHolder metricNode = new MetricPlaceHolder();

    public ConvertMetricToSQLAggregate() {
        this.mName = "Convert metric nodes to SQLAggregate or SQLColumn nodes.";
        this.mPassNumbers = new int[]{1};
        this.mTypes = new int[]{5};
        this.mMode = AbstractRule.Mode.TOP_DOWN;
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!ConvertMetricToSQLAggregate.hasRelationalDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with a relational data source.", trace);
            return false;
        }
        this.traceNodeCondition(true, "SelectionActionMetric needs to be converted to SQLAggregate.", trace);
        return true;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        AxisSpecification axisSpec = (AxisSpecification)node.getAncestorOfType(2);
        axisSpec.getNodeList().add(new AxisNodeMap(this.metricNode));
        SelectionActionMetrics selectMetric = (SelectionActionMetrics)node;
        INode[] metrics = selectMetric.getMetrics();
        QuerySpecification querySpec = (QuerySpecification)node.getAncestorOfType(0);
        List<INode> metricNodes = querySpec.getMetrics();
        SelectionSpecification selection = (SelectionSpecification)node.getAncestorOfType(4);
        IAggregationSpecification aggSpec = selection.getAggregationSpecification();
        IXQEQueryNode parent = node.getParent();
        for (INode metric : metrics) {
            IDataItem dataItem = MetadataHelper.getDefaultDataItem((INode)metric);
            boolean isMetric = this.isMetric(metric);
            if (isMetric) {
                metricNodes.add(metric);
            } else {
                CountMetric countMetric = new CountMetric(metric, dataItem);
                metricNodes.add(countMetric);
            }
            SQLColumn column = (SQLColumn)nodeFactory.createNode(3004);
            column.setTableName(RelationalDataItems.getTableName((IDataItem)dataItem));
            column.setName(RelationalDataItems.getColumnName((IDataItem)dataItem));
            column.setDataItem(dataItem);
            EAggregationFunction rollup = null;
            if (aggSpec != null) {
                rollup = aggSpec.getRollupFunction(metric);
            }
            if (rollup == null) {
                rollup = isMetric ? EAggregationFunction.Total : EAggregationFunction.Count;
            }
            if (rollup != EAggregationFunction.None) {
                SQLAggregate aggrNode = (SQLAggregate)nodeFactory.createNode(3000);
                aggrNode.addChild(column);
                switch (rollup) {
                    case Average: {
                        aggrNode.setSubType(SQLAggregate.SubType.AVG);
                        break;
                    }
                    case Count: {
                        aggrNode.setSubType(SQLAggregate.SubType.COUNT);
                        aggrNode.setDistinct(true);
                        break;
                    }
                    case CountDistinct: {
                        aggrNode.setSubType(SQLAggregate.SubType.COUNT_DISTINCT);
                        aggrNode.setDistinct(true);
                        break;
                    }
                    case Min: {
                        aggrNode.setSubType(SQLAggregate.SubType.MIN);
                        break;
                    }
                    case Max: {
                        aggrNode.setSubType(SQLAggregate.SubType.MAX);
                        break;
                    }
                    case Total: {
                        aggrNode.setSubType(SQLAggregate.SubType.SUM);
                        break;
                    }
                }
                parent.addChild((IXQEQueryNode)aggrNode);
                continue;
            }
            parent.addChild((IXQEQueryNode)column);
        }
        node.detach();
    }

    protected boolean isMetric(INode node) {
        if (node != null) {
            if (node.isCategory()) {
                node = NavigationHelper.getDefaultAttributeNode((INode)node);
            }
            return node.isMetric() || node.getConcept().supportsClassification(IConcept.EConceptClass.metric);
        }
        return false;
    }

    class MetricPlaceHolder
    implements INode {
        MetricPlaceHolder() {
        }

        public String getLabel() {
            return null;
        }

        public Object getProperty(String name) {
            return null;
        }

        public void setProperty(String name, Object value) {
        }

        public IAssociativeModel getModel() {
            return null;
        }

        public boolean connectsWith(INode other) {
            return false;
        }

        public IConcept getConcept() {
            return null;
        }

        public void setConfidenceLevel(float confidenceLevel) {
        }

        public float getConfidenceLevel() {
            return -1.0f;
        }

        public IDataItem getDataItem() {
            return null;
        }

        public void setDataItem(IDataItem di) {
        }

        public Iterable<IEdge> getEdges(String ... labels) {
            return null;
        }

        public String getId() {
            return null;
        }

        public Iterable<IEdge> getInEdges(String ... labels) {
            return null;
        }

        public Iterable<IEdge> getOutEdges(String ... labels) {
            return null;
        }

        public ENodeType getType() {
            return ENodeType.METRIC;
        }

        public boolean isCategory() {
            return false;
        }

        public boolean isMetric() {
            return true;
        }

        public boolean isAttribute() {
            return false;
        }

        public boolean isValue() {
            return false;
        }

        public Iterable<INode> getMetricNodesInScope() {
            return null;
        }

        public boolean isInScopeWith(INode other) {
            return false;
        }

        public void setConcept(IConcept concept) {
        }

        public String toString() {
            return "MetricPlaceHolder";
        }
    }
}

