/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.sql;

import com.ibm.cognos.aurora.api.query.queryspec.expression.IOperator;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.ISQLQueryNode;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLComparison;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLLogical;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLValueExpression;
import com.ibm.cognos.aurora.qls.query.planner.rules.sql.SQLQueryRule;

public class ConvertOperatorToSQLOperator
extends SQLQueryRule {
    public ConvertOperatorToSQLOperator() {
        this.mName = "Convert an operator node to an equivalent SQL node.";
        this.mPassNumbers = new int[]{1};
        this.mTypes = new int[]{12};
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!ConvertOperatorToSQLOperator.hasRelationalDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with a relational data source.", trace);
            return false;
        }
        this.traceNodeCondition(true, "Operator needs to be converted to SQLOperator.", trace);
        return true;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        ISQLQueryNode qNode = null;
        IOperator oprNode = (IOperator)node;
        switch (oprNode.getOperatorType()) {
            case NEGATE: 
            case PLUS: 
            case MINUS: 
            case MULTIPLY: 
            case DIVIDE: 
            case CONCAT: {
                SQLValueExpression vExpr = (SQLValueExpression)nodeFactory.createNode(3030);
                vExpr.setSubType(oprNode.getOperatorType());
                qNode = vExpr;
                break;
            }
            case EQUALS: 
            case NOT_EQUALS: 
            case LESS_THAN: 
            case GREATER_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN_OR_EQUAL: {
                SQLComparison comparison = (SQLComparison)nodeFactory.createNode(3005);
                comparison.setSubType(oprNode.getOperatorType());
                qNode = comparison;
                break;
            }
            case IN: {
                qNode = (ISQLQueryNode)nodeFactory.createNode(3014);
                break;
            }
            case OR: 
            case AND: {
                SQLLogical logical = (SQLLogical)nodeFactory.createNode(3019);
                logical.setSubType(oprNode.getOperatorType());
                qNode = logical;
                break;
            }
            case BETWEEN: {
                qNode = (ISQLQueryNode)nodeFactory.createNode(3002);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        node.exchange((IXQEQueryNode)qNode, true);
    }
}

