/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.sql;

import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.query.queryspec.expression.ICategoryMetricNode;
import com.ibm.cognos.aurora.api.smd.kb.IConcept;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.core.model.DateHierarchyHelper;
import com.ibm.cognos.aurora.core.model.NavigationHelper;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLSelect;
import com.ibm.cognos.aurora.qls.query.planner.rules.sql.SQLQueryRule;
import com.ibm.cognos.aurora.qls.query.queryspec.CategoryMetricNode;
import com.ibm.cognos.aurora.qls.query.queryspec.SortKey;
import java.util.List;

public class PreprocessSort
extends SQLQueryRule {
    public PreprocessSort() {
        this.mName = "Preprocess sort node.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{15};
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!PreprocessSort.hasRelationalDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with a relational data source.", trace);
            return false;
        }
        boolean status = false;
        if (node.getAncestorOfType(3026) != null) {
            IXQEQueryNode[] keyList;
            for (IXQEQueryNode key : keyList = node.getChildren()) {
                DateHierarchyHelper dateHelper;
                ICategoryMetricNode category = (ICategoryMetricNode)key.getChild(0);
                IConcept concept = category.getNode().getConcept();
                if (!concept.isTemporal() || !concept.getName().equals("cMonth") && !concept.getName().equals("cQuarter") || (dateHelper = DateHierarchyHelper.forTemporalCategory((INode)category.getNode())) == null) continue;
                status = true;
                break;
            }
        }
        if (status) {
            this.traceNodeCondition(true, "Preprocessing required for sort operation.", trace);
        } else {
            this.traceNodeCondition(false, "Preprocessing not required for sort operation.", trace);
        }
        return status;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] keyList;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLSelect select = (SQLSelect)node.getAncestorOfType(3026);
        for (IXQEQueryNode key : keyList = node.getChildren()) {
            SortKey sKey;
            CategoryMetricNode cmNode;
            DateHierarchyHelper dateHelper;
            ICategoryMetricNode category = (ICategoryMetricNode)key.getChild(0);
            IConcept concept = category.getNode().getConcept();
            if (!concept.isTemporal() || (dateHelper = DateHierarchyHelper.forTemporalCategory((INode)category.getNode())) == null) continue;
            List attributeList = NavigationHelper.getAttributeNodes((INode)category.getNode());
            INode yearAttr = dateHelper.getYearIdentifier();
            INode quarterAttr = null;
            if (concept.getName().equals("cMonth")) {
                quarterAttr = (INode)attributeList.get(1);
            } else if (concept.getName().equals("cQuarter")) {
                quarterAttr = (INode)attributeList.get(0);
            }
            key.getChild(0).extract();
            key.extract();
            if (yearAttr != null) {
                cmNode = (CategoryMetricNode)nodeFactory.createNode(8);
                cmNode.setNode(yearAttr);
                sKey = (SortKey)nodeFactory.createNode(16);
                sKey.setAscending(true);
                sKey.addChild((IXQEQueryNode)cmNode);
                node.addChild((IXQEQueryNode)sKey);
                select.addExtraNode(yearAttr);
            }
            cmNode = (CategoryMetricNode)nodeFactory.createNode(8);
            cmNode.setNode(quarterAttr);
            sKey = (SortKey)nodeFactory.createNode(16);
            sKey.setAscending(true);
            sKey.addChild((IXQEQueryNode)cmNode);
            node.addChild((IXQEQueryNode)sKey);
            select.addExtraNode(quarterAttr);
            break;
        }
    }
}

