/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.sql;

import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.smd.kb.IConcept;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.rules.AbstractRule;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.core.model.DateHierarchyHelper;
import com.ibm.cognos.aurora.core.model.NavigationHelper;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLSelect;
import com.ibm.cognos.aurora.qls.query.queryspec.CategoryMetricNode;
import com.ibm.cognos.aurora.qls.query.queryspec.SortByAttribute;
import com.ibm.cognos.aurora.qls.query.queryspec.SortKey;

public class PreprocessSortByAttributeTemporal
extends AbstractRule {
    public PreprocessSortByAttributeTemporal() {
        this.mName = "Preprocess SortByAttribute node.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{23};
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        DateHierarchyHelper dateHelper;
        SortByAttribute sba;
        INode sortAttribute;
        INode category;
        IConcept concept;
        XQETrace trace = environment.getTrace();
        boolean status = false;
        if (node.getAncestorOfType(3026) != null && (concept = (category = (sortAttribute = (sba = (SortByAttribute)node).getAttribute()).isAttribute() ? NavigationHelper.getCategoryFromAttribute((INode)sortAttribute) : sortAttribute).getConcept()).isTemporal() && (concept.getName().equals("cMonth") || concept.getName().equals("cQuarter")) && (dateHelper = DateHierarchyHelper.forTemporalCategory((INode)category)) != null) {
            status = true;
        }
        if (status) {
            this.traceNodeCondition(true, "Preprocessing required for sort operation.", trace);
        } else {
            this.traceNodeCondition(true, "Preprocessing not required for sort operation.", trace);
        }
        return status;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLSelect select = (SQLSelect)node.getAncestorOfType(3026);
        SortByAttribute sba = (SortByAttribute)node;
        INode sortAttribute = sba.getAttribute();
        INode category = sortAttribute.isAttribute() ? NavigationHelper.getCategoryFromAttribute((INode)sortAttribute) : sortAttribute;
        IConcept concept = category.getConcept();
        DateHierarchyHelper dateHelper = DateHierarchyHelper.forTemporalCategory((INode)category);
        if (dateHelper == null) {
            throw new IllegalStateException();
        }
        INode yearAttr = dateHelper.getYearIdentifier();
        INode quarterAttr = null;
        if (concept.getName().equals("cMonth")) {
            quarterAttr = dateHelper.getMonthIdentifier();
        } else if (concept.getName().equals("cQuarter")) {
            quarterAttr = dateHelper.getQuarterIdentifier();
        }
        IXQEQueryNode sortNode = nodeFactory.createNode(15);
        node.exchange(sortNode);
        CategoryMetricNode cmNode = (CategoryMetricNode)nodeFactory.createNode(8);
        cmNode.setNode(yearAttr);
        SortKey sKey = (SortKey)nodeFactory.createNode(16);
        sKey.setAscending(true);
        sKey.addChild((IXQEQueryNode)cmNode);
        sortNode.addChild((IXQEQueryNode)sKey);
        cmNode = (CategoryMetricNode)nodeFactory.createNode(8);
        cmNode.setNode(quarterAttr);
        sKey = (SortKey)nodeFactory.createNode(16);
        sKey.setAscending(true);
        sKey.addChild((IXQEQueryNode)cmNode);
        sortNode.addChild((IXQEQueryNode)sKey);
        select.addExtraNode(yearAttr);
        select.addExtraNode(quarterAttr);
    }
}

