/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.sql;

import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.rules.AbstractRule;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.core.model.MetadataHelper;
import com.ibm.cognos.aurora.core.model.RelationalDataItems;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLColumn;
import com.ibm.cognos.aurora.qls.query.planner.ast.sql.SQLSelect;
import com.ibm.cognos.aurora.qls.query.planner.rules.sql.SQLQueryRule;
import com.ibm.cognos.aurora.qls.query.queryspec.SelectionSpecification;
import java.util.ArrayList;

public class ProjectBusinessHierarchy
extends SQLQueryRule {
    public ProjectBusinessHierarchy() {
        this.mName = "Create SQLColumn nodes for the categories and attributes in a business hierarchy.";
        this.mPassNumbers = new int[]{1};
        this.mTypes = new int[]{4};
        this.mMode = AbstractRule.Mode.INDEXED;
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!ProjectBusinessHierarchy.hasRelationalDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with a relational data source.", trace);
            return false;
        }
        SelectionSpecification selection = (SelectionSpecification)node;
        INode[] hierarchy = (INode[])selection.getPropertyValue("businesHierarchy");
        if (hierarchy == null) {
            this.traceNodeCondition(false, "No hierarchy was specified or the hierarchy has already been projected.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The hierarchy needs to be projected as SQLColumns.", trace);
        return true;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode querySpec = node.getAncestorOfType(0);
        SQLSelect sqlSelect = (SQLSelect)nodeFactory.createNode(3026, node);
        sqlSelect.setExtraNodes(new ArrayList<INode>());
        querySpec.addChild((IXQEQueryNode)sqlSelect);
        SelectionSpecification selection = (SelectionSpecification)node;
        INode[] hierarchy = (INode[])selection.getPropertyValue("businesHierarchy");
        ArrayList<String> tables = new ArrayList<String>();
        for (int i = hierarchy.length - 1; i >= 0; --i) {
            IDataItem dataItem = MetadataHelper.getDefaultDataItem((INode)hierarchy[i]);
            SQLColumn column = (SQLColumn)nodeFactory.createNode(3004);
            column.setTableName(RelationalDataItems.getTableName((IDataItem)dataItem));
            column.setName(RelationalDataItems.getColumnName((IDataItem)dataItem));
            column.setDataItem(dataItem);
            sqlSelect.addChild(column, 0);
            String tableName = RelationalDataItems.getTableName((IDataItem)dataItem);
            if (tables.contains(tableName)) continue;
            tables.add(tableName);
        }
        sqlSelect.setTables(tables);
        node.removeProperty("businesHierarchy");
    }
}

