/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.planner.rules.sql;

import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.qls.query.planner.rules.sql.SQLQueryRule;
import com.ibm.cognos.aurora.qls.query.queryspec.AxisSpecification;
import com.ibm.cognos.aurora.qls.query.queryspec.QuerySpecification;

public class RemoveNodes
extends SQLQueryRule {
    public RemoveNodes() {
        this.mName = "Remove extraneous nodes.";
        this.mPassNumbers = new int[]{5};
        this.mTypes = new int[]{2, 4, 10, 15};
    }

    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!RemoveNodes.hasRelationalDataSource(node)) {
            this.traceNodeCondition(false, "Node is not associated with a relational data source.", trace);
            return false;
        }
        this.traceNodeCondition(true, "Extraneous nodes need to be removed.", trace);
        return true;
    }

    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        if (node.getType() == 2) {
            AxisSpecification axisSpec = (AxisSpecification)node;
            QuerySpecification querySpec = (QuerySpecification)node.getAncestorOfType(0);
            querySpec.setAxisNodes(axisSpec.getAxisSpecID(), axisSpec.getNodeList());
            node.getChild(0).extract();
            node.extract();
        } else {
            node.extract();
        }
    }
}

