/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.provider;

import com.ibm.cognos.aurora.api.model.datatype.DataTypes;
import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.query.provider.IMetadataRecord;
import com.ibm.cognos.aurora.qls.query.provider.FieldIndex;
import java.util.ArrayList;

public abstract class MetadataRecord
implements IMetadataRecord {
    private final ArrayList<IValue> mFieldValues;
    private final FieldIndex mIndex;

    public MetadataRecord() {
        this(new FieldIndex());
    }

    public MetadataRecord(FieldIndex index) {
        this.mIndex = index;
        this.mFieldValues = new ArrayList();
    }

    public int getFieldCount() {
        return this.mIndex.getFieldCount();
    }

    public boolean containsField(String name) {
        return this.mIndex.containsField(name);
    }

    public String[] getFieldNames() {
        return this.mIndex.getFieldNames();
    }

    public int indexOfField(String name) {
        return this.mIndex.indexOf(name);
    }

    public void createFieldIfAbsent(String name) {
        this.mIndex.getOrCreateIndex(name);
    }

    public IDataType getFieldType(String name) {
        int index = this.indexOfField(name);
        if (-1 == index) {
            return DataTypes.getUnknownType();
        }
        return this.getFieldType(index);
    }

    public IDataType getFieldType(int index) {
        if (index >= this.mFieldValues.size()) {
            return DataTypes.getUnknownType();
        }
        IValue value = this.mFieldValues.get(index);
        if (null == value) {
            return DataTypes.getUnknownType();
        }
        return value.getType();
    }

    public IValue getFieldValue(String name) {
        int index = this.indexOfField(name);
        if (-1 == index) {
            return null;
        }
        return this.getFieldValue(index);
    }

    public IValue getFieldValue(int index) {
        if (index >= this.mFieldValues.size()) {
            return null;
        }
        return this.mFieldValues.get(index);
    }

    public void setFieldValue(String name, IValue value) {
        int index = this.mIndex.getOrCreateIndex(name);
        this.setFieldValue(index, value);
    }

    public void setFieldValue(int index, IValue value) {
        while (this.mFieldValues.size() <= index) {
            this.mFieldValues.add(null);
        }
        this.mFieldValues.set(index, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getType()).append('[');
        for (String key : this.getFieldNames()) {
            IValue val = this.getFieldValue(key);
            sb.append("\n").append(key).append('=').append(val);
        }
        sb.append(']');
        return sb.toString();
    }
}

