/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.provider;

import com.ibm.cognos.aurora.api.query.IQueryLogicalStorage;
import com.ibm.cognos.aurora.api.query.provider.IDataProvider;
import com.ibm.cognos.aurora.api.query.provider.IProviderManager;
import com.ibm.cognos.aurora.api.query.provider.NoSuchProviderException;
import com.ibm.cognos.aurora.api.query.provider.ProviderAlreadyRegisteredException;
import com.ibm.cognos.aurora.api.query.provider.ProviderInitializationException;
import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LoggerManager;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class ProviderManager
implements IProviderManager {
    private final IQueryLogicalStorage mQLS;
    private final ConcurrentHashMap<String, ProviderDefinition> mProviderDefs = new ConcurrentHashMap();
    private final AtomicBoolean mDisposed = new AtomicBoolean(false);
    private static final ILogger logger = LoggerManager.getLogger((String)"ATHENA.core.qls");

    public ProviderManager(IQueryLogicalStorage qls) {
        this.mQLS = qls;
    }

    public void registerDataProvider(String providerName, String providerClazzname, Properties props) {
        ProviderDefinition providerDef;
        if (logger.isInfoEnabled()) {
            logger.info(String.format("Registering data provider name='%s', class=%s", providerName, providerClazzname), this.getClass().getName() + "::registerDataProvider()");
        }
        if (null != this.mProviderDefs.putIfAbsent(providerName, providerDef = new ProviderDefinition(providerName, providerClazzname, props))) {
            logger.error("Data provider was already registered: " + providerName, this.getClass().getName() + "::registerDataProvider()");
            throw new ProviderAlreadyRegisteredException(providerName);
        }
    }

    public void deregisterDataProvider(String providerName) {
        ProviderDefinition providerDef = this.mProviderDefs.remove(providerName);
        if (null == providerDef) {
            throw new NoSuchProviderException(providerName);
        }
        providerDef.dispose();
    }

    public IDataProvider getDataProvider(String providerName) {
        ProviderDefinition providerDef = this.mProviderDefs.get(providerName);
        if (null == providerDef) {
            throw new NoSuchProviderException(providerName);
        }
        return providerDef.getOrCreateProvider();
    }

    public void dispose() {
        if (this.mDisposed.compareAndSet(false, true)) {
            for (ProviderDefinition def : this.mProviderDefs.values()) {
                try {
                    def.dispose();
                }
                catch (Throwable ex) {
                    logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::dispose()", ex);
                }
            }
            this.mProviderDefs.clear();
        }
    }

    private final class ProviderDefinition {
        final String mProviderName;
        final String mProviderClazzName;
        final Properties mProps;
        volatile IDataProvider mInstance = null;

        ProviderDefinition(String providerName, String providerClazzName, Properties props) {
            this.mProviderName = providerName;
            this.mProviderClazzName = providerClazzName;
            this.mProps = props;
        }

        synchronized IDataProvider getOrCreateProvider() {
            if (null != this.mInstance) {
                return this.mInstance;
            }
            if (logger.isInfoEnabled()) {
                logger.info(String.format("Initialize data provider name='%s', class=%s", this.mProviderName, this.mProviderClazzName), this.getClass().getName() + "::getOrCreateProvider()");
            }
            try {
                Class<?> clazz = Class.forName(this.mProviderClazzName);
                IDataProvider newInstance = (IDataProvider)clazz.newInstance();
                newInstance.initialize(ProviderManager.this.mQLS, this.mProps);
                this.mInstance = newInstance;
                return newInstance;
            }
            catch (Exception ex) {
                this.mInstance = null;
                logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::getOrCreateProvider()", (Throwable)ex);
                throw new ProviderInitializationException(this.mProviderName, (Throwable)ex);
            }
        }

        synchronized void dispose() {
            if (null != this.mInstance) {
                this.mInstance.dispose();
            }
        }
    }
}

