/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.provider.connection;

import com.ibm.cognos.aurora.api.exception.CoreMessageKeys;
import com.ibm.cognos.aurora.api.model.IConnectionSpec;
import com.ibm.cognos.aurora.api.query.provider.IDataProvider;
import com.ibm.cognos.aurora.api.query.provider.connection.IExpirationPolicy;
import com.ibm.cognos.aurora.api.query.provider.connection.IProviderConnection;
import com.ibm.cognos.aurora.api.query.provider.connection.IProviderConnectionPool;
import com.ibm.cognos.aurora.core.util.LocaleUtil;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.query.provider.connection.ProviderConnectionPool;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractProviderConnection
implements IProviderConnection {
    private static final int VALIDATION_BLOCKING_PERIOD = 15000;
    private final IDataProvider mProvider;
    private final IConnectionSpec mConnSpec;
    private IExpirationPolicy mExpirationPolicy = null;
    private ProviderConnectionPool mPool = null;
    private final AtomicBoolean mInUse = new AtomicBoolean(true);
    private final AtomicBoolean mClosed = new AtomicBoolean(false);
    private volatile boolean mInvalid = false;
    private final long mCreatedTimestamp;
    private volatile long mLastBorrowedTimestamp = this.mCreatedTimestamp = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
    private volatile long mLastReturnedTimestamp = this.mCreatedTimestamp;
    private volatile long mLastValidatedTimestamp = 0L;

    public AbstractProviderConnection(IDataProvider provider, IConnectionSpec connSpec) {
        this.mProvider = provider;
        this.mConnSpec = connSpec.duplicate();
    }

    public final IDataProvider getProvider() {
        return this.mProvider;
    }

    public final IConnectionSpec getConnectionSpec() {
        return this.mConnSpec;
    }

    public final IExpirationPolicy getExpirationPolicy() {
        return this.mExpirationPolicy;
    }

    public final void setExpirationPolicy(IExpirationPolicy policy) {
        this.mExpirationPolicy = policy;
    }

    public final boolean isInUse() {
        return this.mInUse.get();
    }

    public final boolean isClosed() {
        return this.mClosed.get();
    }

    public final long aliveTime() {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime()) - this.mCreatedTimestamp;
    }

    public final long idleTime() {
        if (this.isInUse()) {
            return 0L;
        }
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime()) - this.mLastReturnedTimestamp;
    }

    public final long inUseTime() {
        if (this.isInUse()) {
            return TimeUnit.NANOSECONDS.toMillis(System.nanoTime()) - this.mLastBorrowedTimestamp;
        }
        return 0L;
    }

    public final void close() {
        if (!this.isInUse()) {
            throw new QLSRuntimeException(CoreMessageKeys.GEN_FoundInternalErrorParam, "Illegal State: Connection must be borrowed to be closed.");
        }
        if (this.mClosed.compareAndSet(false, true)) {
            this.closeImpl();
        }
    }

    public final boolean validate() {
        if (!this.isInUse()) {
            throw new QLSRuntimeException(CoreMessageKeys.GEN_FoundInternalErrorParam, "Illegal State: Connection must be borrowed to be validated.");
        }
        if (this.mInvalid || this.isClosed()) {
            return false;
        }
        if (TimeUnit.NANOSECONDS.toMillis(System.nanoTime()) - this.mLastValidatedTimestamp > 15000L) {
            this.mLastValidatedTimestamp = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
            this.mInvalid = !this.validateImpl();
        }
        return !this.mInvalid;
    }

    public final void invalidate() {
        if (!this.isInUse()) {
            throw new QLSRuntimeException(CoreMessageKeys.GEN_FoundInternalErrorParam, "Illegal State: Connection must be borrowed to be invalidated.");
        }
        this.mInvalid = true;
    }

    final boolean casInUse(boolean expected, boolean update) {
        return this.mInUse.compareAndSet(expected, update);
    }

    public final IProviderConnectionPool getConnectionPool() {
        return this.mPool;
    }

    final void setConnectionPool(ProviderConnectionPool pool) {
        this.mPool = pool;
    }

    public final void returnToPool() {
        if (null == this.mPool) {
            throw new QLSRuntimeException(CoreMessageKeys.GEN_FoundInternalErrorParam, "Illegal State: Connection was not associated with a pool.");
        }
        if (!this.isInUse()) {
            throw new QLSRuntimeException(CoreMessageKeys.GEN_FoundInternalErrorParam, "Illegal State: Connection must be borrowed to be returned to a pool.");
        }
        this.mPool.returnToPool(this);
    }

    protected abstract boolean validateImpl();

    protected abstract void closeImpl();

    public static boolean matchString(IConnectionSpec connSpec, IConnectionSpec requestedSpec, String parameterName) {
        Object value1 = connSpec.getParameterValue(parameterName);
        Object value2 = requestedSpec.getParameterValue(parameterName);
        if (null == value1) {
            return null == value2;
        }
        if (null == value2) {
            return false;
        }
        return value1.equals(value2);
    }

    public static boolean matchStringIgnoreCase(IConnectionSpec connSpec1, IConnectionSpec connSpec2, String parameterName) {
        String value1 = connSpec1.getParameterStringValue(parameterName);
        String value2 = connSpec2.getParameterStringValue(parameterName);
        if (null == value1) {
            return null == value2;
        }
        if (null == value2) {
            return false;
        }
        return value1.equalsIgnoreCase(value2);
    }

    public static boolean matchInteger(IConnectionSpec connSpec1, IConnectionSpec connSpec2, String parameterName) {
        Integer value1 = connSpec1.getParameterIntegerValue(parameterName);
        Integer value2 = connSpec2.getParameterIntegerValue(parameterName);
        if (null == value1) {
            return null == value2;
        }
        if (null == value2) {
            return false;
        }
        return value1.equals(value2);
    }

    public static boolean matchLocale(IConnectionSpec connSpec1, IConnectionSpec connSpec2, String parameterName) {
        String strLocale1 = connSpec1.getParameterStringValue(parameterName);
        String strLocale2 = connSpec2.getParameterStringValue(parameterName);
        if (null == strLocale1) {
            return null == strLocale2;
        }
        if (null == strLocale2) {
            return true;
        }
        Locale locale1 = LocaleUtil.localeFromString((String)strLocale1);
        Locale locale2 = LocaleUtil.localeFromString((String)strLocale2);
        if (!locale1.getLanguage().equals(locale2.getLanguage())) {
            return false;
        }
        if (locale1.getCountry().length() == 0) {
            return locale2.getCountry().length() == 0;
        }
        if (locale2.getCountry().length() == 0) {
            return true;
        }
        return locale1.getCountry().equals(locale2.getCountry());
    }
}

