/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.provider.connection;

import com.ibm.cognos.aurora.api.model.IConnectionSpec;
import com.ibm.cognos.aurora.api.query.provider.connection.IExpirationPolicy;
import com.ibm.cognos.aurora.api.query.provider.connection.IProviderConnection;
import com.ibm.cognos.aurora.api.query.provider.connection.IProviderConnectionFactory;
import com.ibm.cognos.aurora.api.query.provider.connection.IProviderConnectionPool;
import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LogDataHelper;
import com.ibm.cognos.aurora.core.logging.LoggerManager;
import com.ibm.cognos.aurora.core.logging.Operation;
import com.ibm.cognos.aurora.core.logging.event.AuditLogBaseEvent;
import com.ibm.cognos.aurora.qls.query.provider.connection.AbstractProviderConnection;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class ProviderConnectionPool
implements IProviderConnectionPool {
    private final String mPoolName;
    private final IProviderConnectionFactory mConnFactory;
    private final IExpirationPolicy mDefaultExpirationPolicy;
    private final AtomicBoolean mShutdown = new AtomicBoolean(false);
    private final ConcurrentLinkedQueue<AbstractProviderConnection> mConnectionQueue = new ConcurrentLinkedQueue();
    private final AtomicLong mCreationCount = new AtomicLong(0L);
    private final AtomicLong mReuseCount = new AtomicLong(0L);
    private static final ILogger logger = LoggerManager.getLogger((String)"ATHENA.core.qls.connection.pool");

    public ProviderConnectionPool(String poolName, IProviderConnectionFactory connFactory, IExpirationPolicy defaultExpirationPolicy) {
        this.mPoolName = poolName;
        this.mConnFactory = connFactory;
        this.mDefaultExpirationPolicy = defaultExpirationPolicy;
    }

    public String getPoolName() {
        return this.mPoolName;
    }

    public IExpirationPolicy getDefaultExpirationPolicy() {
        return this.mDefaultExpirationPolicy;
    }

    public boolean isShutdown() {
        return this.mShutdown.get();
    }

    public IProviderConnection borrow(IConnectionSpec connSpec) {
        AbstractProviderConnection conn;
        this.assertNotShutdown();
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Started connection borrow [POOL=%s, CONNECTION_SPEC=%s]", this.mPoolName, connSpec.toString()), this.getClass().getName() + "::borrow()");
        }
        if (null == (conn = this.selectFromPool(connSpec))) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Creating new connection [POOL=%s, CONNECTION_SPEC=%s]", this.mPoolName, connSpec.toString()), this.getClass().getName() + "::borrow()");
            }
            conn = (AbstractProviderConnection)this.mConnFactory.create(connSpec);
            conn.setConnectionPool(this);
            if (!conn.isInUse()) {
                throw new IllegalStateException("Expected connection to be in use");
            }
            this.mConnectionQueue.add(conn);
            this.mCreationCount.incrementAndGet();
            if (logger.isAuditDebugEventEnabled()) {
                logger.auditDebugEvent(new AuditLogBaseEvent("", "", "", Operation.CONNECT, LogDataHelper.createFreeTextLogData((String)conn.getConnectionSpec().toString())));
            }
        } else {
            this.mReuseCount.incrementAndGet();
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Finished connection borrow [POOL=%s, CONNECTION_ID=%h]", this.mPoolName, System.identityHashCode(conn)), this.getClass().getName() + "::borrow()");
        }
        this.logPoolStats();
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        if (this.isShutdown()) {
            return;
        }
        LinkedList<AbstractProviderConnection> invalidConnections = new LinkedList<AbstractProviderConnection>();
        LinkedList<AbstractProviderConnection> expiredConnections = new LinkedList<AbstractProviderConnection>();
        for (AbstractProviderConnection conn : this.mConnectionQueue) {
            IExpirationPolicy policy = conn.getExpirationPolicy();
            if (null == policy) {
                policy = this.getDefaultExpirationPolicy();
            }
            if (null != policy && policy.isExpired((IProviderConnection)conn)) {
                if (conn.casInUse(false, true)) {
                    if (logger.isInfoEnabled()) {
                        logger.info(String.format("Connection has expired and is queued for removal [POOL=%s, CONNECTION_ID=%h]", this.mPoolName, System.identityHashCode(conn)), this.getClass().getName() + "::cleanup()");
                    }
                    expiredConnections.add(conn);
                    continue;
                }
                if (logger.isInfoEnabled()) {
                    logger.info(String.format("Connection has expired but is still in use [POOL=%s, CONNECTION_ID=%h]", this.mPoolName, System.identityHashCode(conn)), this.getClass().getName() + "::cleanup()");
                }
            }
            boolean wasValidated = false;
            boolean isValid = true;
            if (conn.casInUse(false, true)) {
                try {
                    wasValidated = true;
                    isValid = conn.validate();
                }
                catch (Exception ex) {
                    logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::cleanup()", (Throwable)ex);
                    isValid = false;
                }
                finally {
                    conn.casInUse(true, false);
                }
            }
            if (!wasValidated || isValid) continue;
            if (conn.casInUse(false, true)) {
                if (logger.isInfoEnabled()) {
                    logger.info(String.format("Connection is invalid and queued for removal [POOL=%s, CONNECTION_ID=%h]]", this.mPoolName, System.identityHashCode(conn)), this.getClass().getName() + "::cleanup()");
                }
                invalidConnections.add(conn);
                continue;
            }
            if (!logger.isInfoEnabled()) continue;
            logger.info(String.format("Connection is invalid but is still in use [POOL=%s, CONNECTION_ID=%h]]", this.mPoolName, System.identityHashCode(conn)), this.getClass().getName() + "::cleanup()");
        }
        for (AbstractProviderConnection conn : invalidConnections) {
            if (logger.isWarnEnabled()) {
                logger.warn(String.format("Removing invalid connection [POOL=%s, CONNECTION_ID=%h]]", this.mPoolName, System.identityHashCode(conn)), this.getClass().getName() + "::cleanup()");
            }
            this.mConnectionQueue.remove(conn);
            if (conn.isClosed()) continue;
            try {
                conn.close();
            }
            catch (Exception ex) {
                logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::cleanup()", (Throwable)ex);
            }
        }
        for (AbstractProviderConnection conn : expiredConnections) {
            if (logger.isInfoEnabled()) {
                logger.info(String.format("Removing expired connection [POOL=%s, CONNECTION_ID=%h]]", this.mPoolName, System.identityHashCode(conn)), this.getClass().getName() + "::cleanup()");
            }
            this.mConnectionQueue.remove(conn);
            if (conn.isClosed()) continue;
            try {
                conn.close();
            }
            catch (Exception ex) {
                logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::cleanup()", (Throwable)ex);
            }
        }
    }

    private AbstractProviderConnection selectFromPool(IConnectionSpec connSpec) {
        LinkedList<AbstractProviderConnection> cleanupQueue = new LinkedList<AbstractProviderConnection>();
        AbstractProviderConnection selected = null;
        boolean debugEnabled = logger.isDebugEnabled();
        for (AbstractProviderConnection conn : this.mConnectionQueue) {
            if (debugEnabled) {
                logger.debug(String.format("Selecting candidate connection [POOL=%s, CONNECTION_ID=%h, CONNECTION_SPEC=%s]", this.mPoolName, System.identityHashCode(conn), conn.getConnectionSpec().toString()), this.getClass().getName() + "::selectFromPool()");
            }
            if (conn.isInUse()) {
                if (!debugEnabled) continue;
                logger.debug(String.format("Selection failed (in use) [POOL=%s, CONNECTION_ID=%h]", this.mPoolName, System.identityHashCode(conn)), this.getClass().getName() + "::selectFromPool()");
                continue;
            }
            if (!conn.matches(connSpec)) {
                if (!debugEnabled) continue;
                logger.debug(String.format("Selection failed (mismatch) [POOL=%s, CONNECTION_ID=%h]", this.mPoolName, System.identityHashCode(conn)), this.getClass().getName() + "::selectFromPool()");
                continue;
            }
            if (conn.casInUse(false, true)) {
                if (conn.validate()) {
                    selected = conn;
                    if (!debugEnabled) break;
                    logger.debug(String.format("Selection succeeded [POOL=%s, CONNECTION_ID=%h]", this.mPoolName, System.identityHashCode(conn)), this.getClass().getName() + "::selectFromPool()");
                    break;
                }
                if (logger.isInfoEnabled()) {
                    logger.info(String.format("Connection is invalid and queued for removal [POOL=%s, CONNECTION_ID=%h]]", this.mPoolName, System.identityHashCode(conn)), this.getClass().getName() + "::selectFromPool()");
                }
                cleanupQueue.add(conn);
                continue;
            }
            if (!debugEnabled) continue;
            logger.debug(String.format("Selection failed (in use) [POOL=%s, CONNECTION_ID=%h]", this.mPoolName, System.identityHashCode(conn)), this.getClass().getName() + "::selectFromPool()");
        }
        for (AbstractProviderConnection conn : cleanupQueue) {
            if (logger.isWarnEnabled()) {
                logger.warn(String.format("Removing invalid connection [POOL=%s, CONNECTION_ID=%h]]", this.mPoolName, System.identityHashCode(conn)), this.getClass().getName() + "::selectFromPool()");
            }
            this.mConnectionQueue.remove(conn);
            if (conn.isClosed()) continue;
            try {
                conn.close();
            }
            catch (Exception ex) {
                logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::selectFromPool()", (Throwable)ex);
            }
        }
        return selected;
    }

    void returnToPool(AbstractProviderConnection conn) {
        this.assertNotShutdown();
        if (this != conn.getConnectionPool()) {
            throw new IllegalArgumentException("Connection does not belong to this pool.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Returning connection [POOL=%s, CONNECTION_ID=%h]", this.mPoolName, System.identityHashCode(conn)), this.getClass().getName() + "::returnToPool()");
        }
        if (conn.validate()) {
            if (!conn.casInUse(true, false)) {
                throw new IllegalArgumentException("Connection was not borrowed.");
            }
        } else {
            if (logger.isWarnEnabled()) {
                logger.warn(String.format("Removing invalid connection [POOL=%s, CONNECTION_ID=%h]]", this.mPoolName, System.identityHashCode(conn)), this.getClass().getName() + "::returnToPool()");
            }
            this.mConnectionQueue.remove(conn);
            if (!conn.isClosed()) {
                try {
                    conn.close();
                }
                catch (Exception ex) {
                    logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::returnToPool()", (Throwable)ex);
                }
            }
        }
        this.logPoolStats();
    }

    public void shutdown() {
        if (this.mShutdown.compareAndSet(false, true)) {
            if (logger.isInfoEnabled()) {
                logger.info(String.format("Shutting down connection pool [POOL=%s]", this.mPoolName), this.getClass().getName() + "::shutdown()");
            }
            for (AbstractProviderConnection conn : this.mConnectionQueue) {
                try {
                    if (conn.isClosed()) continue;
                    if (!conn.isInUse()) {
                        conn.casInUse(false, true);
                    }
                    conn.close();
                }
                catch (Throwable ex) {
                    logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::shutdown()", ex);
                }
            }
            this.mConnectionQueue.clear();
        }
    }

    public int getActiveInUseCount() {
        int count = 0;
        for (AbstractProviderConnection conn : this.mConnectionQueue) {
            if (!conn.isInUse()) continue;
            ++count;
        }
        return count;
    }

    public int getActiveIdleCount() {
        int count = 0;
        for (AbstractProviderConnection conn : this.mConnectionQueue) {
            if (conn.isInUse()) continue;
            ++count;
        }
        return count;
    }

    public int getActiveCount() {
        return this.mConnectionQueue.size();
    }

    public long getCreationCount() {
        return this.mCreationCount.get();
    }

    public long getReuseCount() {
        return this.mReuseCount.get();
    }

    private void assertNotShutdown() {
        if (this.mShutdown.get()) {
            throw new IllegalStateException("Pool was shutdown");
        }
    }

    private void logPoolStats() {
        if (logger.isDebugEnabled()) {
            String msg = String.format("[%s] STATS created:%d, reused:%d, activeIdle:%d, activeInUse:%d, activeTotal:%d", this.mPoolName, this.getCreationCount(), this.getReuseCount(), this.getActiveIdleCount(), this.getActiveInUseCount(), this.getActiveCount());
            logger.debug(msg, this.getClass().getName() + "::logPoolStats()");
        }
    }
}

