/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.provider.relational;

import com.ibm.cognos.aurora.api.model.datatype.DataTypes;
import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.aurora.api.model.value.BooleanValue;
import com.ibm.cognos.aurora.api.model.value.DateValue;
import com.ibm.cognos.aurora.api.model.value.DecimalValue;
import com.ibm.cognos.aurora.api.model.value.DoubleValue;
import com.ibm.cognos.aurora.api.model.value.FloatValue;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.IntegerValue;
import com.ibm.cognos.aurora.api.model.value.LongValue;
import com.ibm.cognos.aurora.api.model.value.TimeValue;
import com.ibm.cognos.aurora.api.model.value.TimestampValue;
import com.ibm.cognos.aurora.api.query.IQueryContext;
import com.ibm.cognos.aurora.api.query.OperationCanceledException;
import com.ibm.cognos.aurora.api.query.provider.tabular.ITabularResultSet;
import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LoggerManager;
import com.ibm.cognos.aurora.qls.exception.QLSMessageKeys;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.query.provider.relational.JDBCProviderConnection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;

public class JDBCTabularResultSet
implements ITabularResultSet {
    private final JDBCProviderConnection mConnection;
    private final IQueryContext mQueryContext;
    private final Statement mStatement;
    private final ResultSet mResultSet;
    private final ResultSetMetaData mMetadata;
    private IDataType[] mColumnTypes = null;
    private boolean mHasMore = false;
    private static final ILogger logger = LoggerManager.getLogger((String)"ATHENA.core.qls");

    public JDBCTabularResultSet(JDBCProviderConnection connection, IQueryContext queryContext, Statement statement, ResultSet resultSet) {
        this.mConnection = connection;
        this.mQueryContext = queryContext;
        this.mStatement = statement;
        this.mResultSet = resultSet;
        try {
            this.mMetadata = resultSet.getMetaData();
            this.discoverColumnTypes();
            this.mHasMore = this.mResultSet.first();
        }
        catch (SQLException ex) {
            logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::JDBCTabularResultSet()");
            throw new QLSRuntimeException(QLSMessageKeys.PRV_JDBCError, ex, (Object)ex.getErrorCode(), (Object)ex.getSQLState(), (Object)ex.getMessage());
        }
    }

    private void discoverColumnTypes() throws SQLException {
        int numColumns = this.mMetadata.getColumnCount();
        this.mColumnTypes = new IDataType[numColumns];
        block13: for (int i = 0; i < numColumns; ++i) {
            int sqlType = this.mMetadata.getColumnType(i + 1);
            switch (sqlType) {
                case 1: 
                case 12: {
                    this.mColumnTypes[i] = DataTypes.getStringType((int)Math.max(1, this.mMetadata.getColumnDisplaySize(i + 1)));
                    continue block13;
                }
                case 2005: {
                    this.mColumnTypes[i] = DataTypes.getStringType((int)Integer.MAX_VALUE);
                    continue block13;
                }
                case -5: {
                    this.mColumnTypes[i] = DataTypes.getLongType();
                    continue block13;
                }
                case 3: {
                    this.mColumnTypes[i] = DataTypes.getDecimalType();
                    continue block13;
                }
                case 8: {
                    this.mColumnTypes[i] = DataTypes.getDoubleType();
                    continue block13;
                }
                case 6: 
                case 7: {
                    this.mColumnTypes[i] = DataTypes.getFloatType();
                    continue block13;
                }
                case -6: 
                case 4: 
                case 5: {
                    this.mColumnTypes[i] = DataTypes.getIntegerType();
                    continue block13;
                }
                case 16: {
                    this.mColumnTypes[i] = DataTypes.getBooleanType();
                    continue block13;
                }
                case 91: {
                    this.mColumnTypes[i] = DataTypes.getDateType();
                    continue block13;
                }
                case 92: {
                    this.mColumnTypes[i] = DataTypes.getTimeType();
                    continue block13;
                }
                case 93: {
                    this.mColumnTypes[i] = DataTypes.getTimestampType();
                    continue block13;
                }
                default: {
                    this.mColumnTypes[i] = DataTypes.getStringType((int)Integer.MAX_VALUE);
                }
            }
        }
    }

    public int numColumns() {
        return this.mColumnTypes.length;
    }

    public String[] columnLabels() {
        if (this.mQueryContext.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            int labelCount = this.numColumns();
            String[] labels = new String[labelCount];
            for (int i = 0; i < labelCount; ++i) {
                labels[i] = this.mMetadata.getColumnLabel(i + 1);
            }
            return labels;
        }
        catch (SQLException ex) {
            logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::columnLabels()");
            throw new QLSRuntimeException(QLSMessageKeys.PRV_JDBCError, ex, (Object)ex.getErrorCode(), (Object)ex.getSQLState(), (Object)ex.getMessage());
        }
    }

    public IDataType[] columnTypes() {
        return this.mColumnTypes;
    }

    public boolean hasMore() {
        return this.mHasMore;
    }

    public IValue[] nextRow() {
        if (this.mQueryContext.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!this.mHasMore) {
            return null;
        }
        try {
            int columnCount = this.numColumns();
            IValue[] row = new IValue[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                row[i] = this.mColumnTypes[i].newValue();
                switch (this.mColumnTypes[i].getBaseType()) {
                    case DECIMAL: {
                        ((DecimalValue)row[i]).set(this.mResultSet.getBigDecimal(i + 1));
                        break;
                    }
                    case DOUBLE: {
                        ((DoubleValue)row[i]).set(this.mResultSet.getDouble(i + 1));
                        break;
                    }
                    case FLOAT: {
                        ((FloatValue)row[i]).set(this.mResultSet.getFloat(i + 1));
                        break;
                    }
                    case INTEGER: {
                        ((IntegerValue)row[i]).set(this.mResultSet.getInt(i + 1));
                        break;
                    }
                    case LONG: {
                        ((LongValue)row[i]).set(this.mResultSet.getLong(i + 1));
                        break;
                    }
                    case BOOLEAN: {
                        ((BooleanValue)row[i]).set(this.mResultSet.getBoolean(i + 1));
                        break;
                    }
                    case DATE: {
                        ((DateValue)row[i]).set((Date)this.mResultSet.getDate(i + 1));
                        break;
                    }
                    case TIME: {
                        ((TimeValue)row[i]).set((Date)this.mResultSet.getTime(i + 1));
                        break;
                    }
                    case TIMESTAMP: {
                        ((TimestampValue)row[i]).set((Date)this.mResultSet.getTimestamp(i + 1));
                        break;
                    }
                    default: {
                        row[i].assignFrom(this.mResultSet.getString(i + 1));
                    }
                }
                if (!this.mResultSet.wasNull()) continue;
                row[i].setNull();
            }
            this.mHasMore = this.mResultSet.next();
            return row;
        }
        catch (SQLException ex) {
            logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::nextRow()");
            throw new QLSRuntimeException(QLSMessageKeys.PRV_JDBCError, ex, (Object)ex.getErrorCode(), (Object)ex.getSQLState(), (Object)ex.getMessage());
        }
    }

    public void reset() {
        if (this.mQueryContext.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            this.mHasMore = this.mResultSet.first();
        }
        catch (SQLException ex) {
            logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::reset()");
            throw new QLSRuntimeException(QLSMessageKeys.PRV_JDBCError, ex, (Object)ex.getErrorCode(), (Object)ex.getSQLState(), (Object)ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        try {
            if (null == this.mResultSet) return;
            this.mResultSet.close();
            return;
        }
        catch (SQLException ex) {
            logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::close()", (Throwable)ex);
            return;
        }
        finally {
            try {
                if (null != this.mStatement) {
                    this.mStatement.close();
                }
            }
            catch (SQLException ex) {
                logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::close()", (Throwable)ex);
            }
            finally {
                if (null != this.mConnection) {
                    this.mConnection.returnToPool();
                }
            }
        }
    }
}

