/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.queryspec;

import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.api.model.IAttribute;
import com.ibm.cognos.aurora.api.model.ICalculation;
import com.ibm.cognos.aurora.api.model.IDataSource;
import com.ibm.cognos.aurora.api.model.IHierarchy;
import com.ibm.cognos.aurora.api.model.IMember;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.model.physical.IPhysicalModel;
import com.ibm.cognos.aurora.api.query.data.IAttributeValue;
import com.ibm.cognos.aurora.api.query.queryspec.IAggregationSpecification;
import com.ibm.cognos.aurora.api.query.queryspec.IAxisSpecification;
import com.ibm.cognos.aurora.api.query.queryspec.IQuerySpecification;
import com.ibm.cognos.aurora.api.query.queryspec.ISelectionSpecification;
import com.ibm.cognos.aurora.api.query.queryspec.ISetSpecification;
import com.ibm.cognos.aurora.api.query.queryspec.IView;
import com.ibm.cognos.aurora.api.query.queryspec.actions.IFilter;
import com.ibm.cognos.aurora.api.query.queryspec.actions.IFilterByData;
import com.ibm.cognos.aurora.api.query.queryspec.actions.ISelectionAction;
import com.ibm.cognos.aurora.api.query.queryspec.actions.ISortKey;
import com.ibm.cognos.aurora.api.query.queryspec.actions.selection.IAllSelection;
import com.ibm.cognos.aurora.api.query.queryspec.actions.selection.IAttributeSelection;
import com.ibm.cognos.aurora.api.query.queryspec.actions.selection.ICategorySelection;
import com.ibm.cognos.aurora.api.query.queryspec.actions.selection.IDefaultValueSelection;
import com.ibm.cognos.aurora.api.query.queryspec.actions.selection.IExpandMembers;
import com.ibm.cognos.aurora.api.query.queryspec.actions.selection.IExpandToDepth;
import com.ibm.cognos.aurora.api.query.queryspec.actions.selection.IMembersByDepth;
import com.ibm.cognos.aurora.api.query.queryspec.actions.selection.IMembersSelection;
import com.ibm.cognos.aurora.api.query.queryspec.actions.selection.IMetricsSelection;
import com.ibm.cognos.aurora.api.query.queryspec.actions.selection.INodesSelection;
import com.ibm.cognos.aurora.api.query.queryspec.actions.selection.ISortByAttribute;
import com.ibm.cognos.aurora.api.query.queryspec.actions.selection.ISortByHierarchyOrder;
import com.ibm.cognos.aurora.api.query.queryspec.actions.selection.IValuesSelection;
import com.ibm.cognos.aurora.api.query.queryspec.actions.set.IFilterOnRange;
import com.ibm.cognos.aurora.api.query.queryspec.actions.set.ISortByData;
import com.ibm.cognos.aurora.api.query.queryspec.expression.ICategoryMetricNode;
import com.ibm.cognos.aurora.api.query.queryspec.expression.ILiteralNode;
import com.ibm.cognos.aurora.api.query.queryspec.expression.IOperator;
import com.ibm.cognos.aurora.api.query.queryspec.expression.IQuerySpecAttributeValue;
import com.ibm.cognos.aurora.api.query.queryspec.expression.IScalarFunction;
import com.ibm.cognos.aurora.api.query.queryspec.expression.ISetFunction;
import com.ibm.cognos.aurora.api.query.queryspec.expression.IValueListNode;
import com.ibm.cognos.aurora.api.query.queryspec.visitor.IQueryNodeVisitor;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.qls.model.QueryHierarchy;
import com.ibm.cognos.aurora.qls.query.queryspec.AxisNodeMap;
import com.ibm.cognos.aurora.qls.query.queryspec.QuerySpecAbstractNode;
import com.ibm.cognos.aurora.qls.util.JSONEmitter;
import com.ibm.json.java.JSONArtifact;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class QuerySpecification
extends QuerySpecAbstractNode
implements IQuerySpecification {
    public static final String PROPERTY_DATASOURCE = "dataSource";
    public static final String PROPERTY_AXIS_NODES = "axisNodes";
    public static final String PROPERTY_METRIC_NODES = "metrics";
    public static final String PROPERTY_CALCULATION_MAPPINGS = "calculationMappings";
    public static final String PROPERTY_CALCULATION_NODE_MAPPINGS = "calculationNodeMappings";
    private Locale locale = new Locale("en", "us");

    @Override
    public IPhysicalModel findPhysicalModel() {
        throw new UnsupportedOperationException();
    }

    public int getType() {
        return 0;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale theLocale) {
        this.locale = theLocale;
    }

    public void addView(IView view) {
        this.addChild((IXQEQueryNode)((QuerySpecAbstractNode)view));
    }

    public List<IView> getViews() {
        IXQEQueryNode[] nodes = this.getChildren();
        ArrayList<IView> views = new ArrayList<IView>();
        for (IXQEQueryNode aNode : nodes) {
            views.add((IView)aNode);
        }
        return views;
    }

    public IDataSource getDataSource() {
        return (IDataSource)this.getPropertyValue(PROPERTY_DATASOURCE);
    }

    public void setDataSource(IDataSource dataSource) {
        this.setPropertyValue(PROPERTY_DATASOURCE, dataSource);
    }

    public List<AxisNodeMap> getAxisNodes(int axisId) {
        Map map = (Map)this.getPropertyValue(PROPERTY_AXIS_NODES);
        return (List)map.get(axisId);
    }

    public void setAxisNodes(int axisId, List<AxisNodeMap> nodeList) {
        Map map = (Map)this.getPropertyValue(PROPERTY_AXIS_NODES);
        map.put(axisId, nodeList);
    }

    public Map<Integer, List<AxisNodeMap>> getAxisNodesMap() {
        return (Map)this.getPropertyValue(PROPERTY_AXIS_NODES);
    }

    public List<INode> getMetrics() {
        return (List)this.getPropertyValue(PROPERTY_METRIC_NODES);
    }

    public void setMetrics(List<INode> nodeList) {
        this.setPropertyValue(PROPERTY_METRIC_NODES, nodeList);
    }

    public void accept(IQueryNodeVisitor visitor) {
        visitor.visit((IQuerySpecification)this);
    }

    public Set<IAssociativeModel> getReferencedModels() {
        ModelCollector visitor = new ModelCollector();
        visitor.visit(this);
        return visitor.getModels();
    }

    @Override
    public String toString() {
        JSONEmitter visitor = new JSONEmitter();
        this.accept(visitor);
        try {
            return ((JSONArtifact)visitor.pop()).serialize(true);
        }
        catch (IOException e) {
            return e.getMessage();
        }
    }

    private static class ModelCollector
    implements IQueryNodeVisitor {
        Set<IAssociativeModel> models = new HashSet<IAssociativeModel>();

        private ModelCollector() {
        }

        public void visit(IQuerySpecification querySpec) {
            for (IView view : querySpec.getViews()) {
                view.accept((IQueryNodeVisitor)this);
            }
        }

        public void visit(IView view) {
            for (IAxisSpecification axis : view.getAxes()) {
                axis.accept((IQueryNodeVisitor)this);
            }
        }

        public void visit(IAxisSpecification axis) {
            for (ISetSpecification set : axis.getSetSpecifications()) {
                set.accept((IQueryNodeVisitor)this);
            }
        }

        public void visit(ISetSpecification set) {
            for (ISelectionSpecification selection : set.getSelectionSpecifications()) {
                selection.accept((IQueryNodeVisitor)this);
            }
        }

        public void visit(ISelectionSpecification selection) {
            IAssociativeModel model;
            for (ISelectionAction action : selection.getSelectionActions()) {
                action.accept((IQueryNodeVisitor)this);
            }
            IHierarchy hierarchy = selection.getHierarchy();
            if (hierarchy != null) {
                this.models.add(hierarchy.getReferencedModel());
            } else if (selection.getHierarchy() instanceof QueryHierarchy && (model = ((QueryHierarchy)selection.getHierarchy()).getReferencedModel()) != null) {
                this.models.add(model);
            }
        }

        public void visit(IValueListNode node) {
        }

        public void visit(ICategoryMetricNode node) {
            this.models.add(node.getNode().getModel());
        }

        public void visit(ILiteralNode node) {
        }

        public void visit(IFilter node) {
            node.getPredicate().accept((IQueryNodeVisitor)this);
        }

        public void visit(ISortKey node) {
        }

        public void visit(ISetFunction node) {
        }

        public void visit(IOperator node) {
        }

        public void visit(IScalarFunction node) {
        }

        public void visit(ICategorySelection node) {
            this.models.add(node.getCategory().getModel());
        }

        public void visit(IMetricsSelection node) {
            INode[] nodes = node.getMetrics();
            if (nodes != null && nodes.length > 0) {
                this.models.add(nodes[0].getModel());
            }
        }

        public void visit(IAttributeSelection node) {
            INode attributeNode = null;
            attributeNode = node.getIAttribute() != null ? node.getIAttribute().getNode() : node.getAttribute();
            this.models.add(attributeNode.getModel());
        }

        public void visit(IQuerySpecAttributeValue node) {
            this.models.add(node.getAttribute().getModel());
        }

        Set<IAssociativeModel> getModels() {
            return this.models;
        }

        public void visit(IAllSelection node) {
        }

        public void visit(IDefaultValueSelection node) {
        }

        public void visit(IValuesSelection node) {
            IQuerySpecAttributeValue[] values;
            for (IQuerySpecAttributeValue aValue : values = node.getAttributeValues()) {
                this.models.add(aValue.getAttribute().getModel());
            }
        }

        public void visit(IAttributeValue node) {
            this.models.add(node.getAttribute().getModel());
        }

        public void visit(ISortByData node) {
        }

        public void visit(IAggregationSpecification node) {
        }

        public void visit(INodesSelection node) {
            INode[] selections;
            for (INode aNode : selections = node.getNodes()) {
                this.models.add(aNode.getModel());
            }
        }

        public void visit(ISortByAttribute node) {
            INode attrNode;
            IAttribute attribute = node.getIAttribute();
            if (attribute != null && (attrNode = attribute.getNode()) != null && attrNode.getModel() != null) {
                this.models.add(attrNode.getModel());
            }
        }

        public void visit(IFilterOnRange node) {
        }

        public void visit(IFilterByData node) {
        }

        public void visit(IMembersSelection node) {
            IMember member;
            IAssociativeModel model;
            IMember[] members = node.getMembers();
            if (members != null && members.length > 0 && (model = (member = members[0]).getReferencedModel()) != null) {
                this.models.add(model);
            }
        }

        public void visit(ICalculation node) {
        }

        public void visit(ISortByHierarchyOrder node) {
        }

        public void visit(IExpandToDepth node) {
        }

        public void visit(IExpandMembers node) {
        }

        public void visit(IMembersByDepth node) {
        }
    }
}

