/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.storage.data.tabular;

import com.ibm.cognos.aurora.api.query.IQueryLogicalStorage;
import com.ibm.cognos.aurora.api.storage.StorageException;
import com.ibm.cognos.aurora.api.storage.data.tabular.ColumnConstraint;
import com.ibm.cognos.aurora.api.storage.data.tabular.ColumnType;
import com.ibm.cognos.aurora.api.storage.data.tabular.IColumnDescriptor;
import com.ibm.cognos.aurora.api.storage.data.tabular.ILocalTabularStorage;
import com.ibm.cognos.aurora.api.storage.data.tabular.ITable;
import com.ibm.cognos.aurora.api.storage.data.tabular.ITableDescriptor;
import com.ibm.cognos.aurora.api.storage.data.tabular.SequenceParameters;
import com.ibm.cognos.aurora.qls.storage.data.AbstractLocalDataStorage;
import com.ibm.cognos.aurora.qls.storage.data.tabular.Table;
import com.ibm.cognos.aurora.qls.storage.data.tabular.TableDescriptor;
import com.ibm.cognos.aurora.qls.util.IdentifierMaker;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.dom4j.Element;

public abstract class AbstractLocalTabularStorage
extends AbstractLocalDataStorage
implements ILocalTabularStorage {
    private final Map<String, ITable> mTablesByName = new LinkedHashMap<String, ITable>();

    protected AbstractLocalTabularStorage(IQueryLogicalStorage qls, String uuid) {
        super(qls, uuid);
    }

    public boolean isDimensional() {
        return false;
    }

    public boolean isTabular() {
        return true;
    }

    public ITableDescriptor describeTable(String tableName) {
        String identifier = IdentifierMaker.fromParts(this.getUUID(), tableName);
        return new TableDescriptor(tableName, identifier);
    }

    public synchronized ITable[] getTables() throws StorageException {
        return this.mTablesByName.values().toArray(new ITable[0]);
    }

    public synchronized ITable getTable(String tableName) throws StorageException {
        return this.mTablesByName.get(tableName);
    }

    public synchronized void dropTable(String tableName) throws StorageException {
        ITable table = this.mTablesByName.remove(tableName);
        if (null != table) {
            this.dropTableImpl(table.getIdentifier());
            try {
                this.saveDescriptor();
            }
            catch (Exception ex) {
                throw new StorageException((Throwable)ex);
            }
        }
    }

    protected abstract boolean queryTableExists(String var1) throws StorageException;

    protected abstract void dropTableImpl(String var1) throws StorageException;

    public synchronized ITable createTable(ITableDescriptor tableDesc) throws StorageException {
        if (this.mTablesByName.containsKey(tableDesc.getName())) {
            throw new StorageException("Table already exists: " + tableDesc.getName());
        }
        this.createTableImpl(tableDesc);
        Table table = new Table(this, tableDesc);
        this.mTablesByName.put(table.getName(), table);
        try {
            this.saveDescriptor();
        }
        catch (Exception ex) {
            throw new StorageException((Throwable)ex);
        }
        return table;
    }

    protected abstract void createTableImpl(ITableDescriptor var1) throws StorageException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clear() throws StorageException {
        try {
            for (ITable table : this.mTablesByName.values()) {
                try {
                    this.dropTableImpl(table.getIdentifier());
                }
                catch (Exception ex) {}
            }
        }
        finally {
            this.mTablesByName.clear();
            try {
                this.saveDescriptor();
            }
            catch (Exception ex) {
                throw new StorageException((Throwable)ex);
            }
        }
    }

    protected void encodeDescriptorTables(Element rootElem) {
        Element tablesElem = rootElem.addElement("tables");
        for (Map.Entry<String, ITable> e : this.mTablesByName.entrySet()) {
            String name = e.getKey();
            ITableDescriptor tableDesc = e.getValue().getDescriptor();
            Element tableElem = tablesElem.addElement("table");
            tableElem.addAttribute("name", name);
            tableElem.addAttribute("identifier", tableDesc.getIdentifier());
            for (IColumnDescriptor colDesc : tableDesc.getColumns()) {
                Element colElem = tableElem.addElement("column");
                colElem.addAttribute("name", colDesc.getName());
                colElem.addAttribute("identifier", colDesc.getIdentifier());
                colElem.addAttribute("type", colDesc.getType().toString());
                if (null != colDesc.getDefaultValue()) {
                    colElem.addAttribute("defaultValue", colDesc.getDefaultValue().toString());
                }
                colElem.addAttribute("isAutoIncrement", Boolean.toString(colDesc.isAutoIncrement()));
                colElem.addAttribute("isGenerateAsIdentity", Boolean.toString(colDesc.isGenerateAsIdentity()));
                if (null == colDesc.getIdentityParameters()) continue;
                SequenceParameters identParams = colDesc.getIdentityParameters();
                if (null != identParams.mStartWith) {
                    colElem.addAttribute("startWith", identParams.mStartWith.toString());
                }
                if (null != identParams.mMinValue) {
                    colElem.addAttribute("minValue", identParams.mMinValue.toString());
                }
                if (null != identParams.mMaxValue) {
                    colElem.addAttribute("maxValue", identParams.mMaxValue.toString());
                }
                if (null != identParams.mIncrementBy) {
                    colElem.addAttribute("incrementBy", identParams.mIncrementBy.toString());
                }
                if (null != identParams.mCycle) {
                    colElem.addAttribute("cycle", identParams.mCycle.toString());
                }
                if (null == identParams.mCache) continue;
                colElem.addAttribute("cache", identParams.mCache.toString());
            }
        }
    }

    protected void decodeDescriptorTables(Element rootElem) {
        Element tablesElem = rootElem.element("tables");
        for (Element tableElem : tablesElem.elements("table")) {
            String tableName = tableElem.attributeValue("name");
            String tableIdent = tableElem.attributeValue("identifier");
            TableDescriptor tableDesc = new TableDescriptor(tableName, tableIdent);
            for (Element colElem : tableElem.elements("column")) {
                SequenceParameters identParams;
                String colName = colElem.attributeValue("name");
                String colType = colElem.attributeValue("type");
                String defaultValue = colElem.attributeValue("defaultValue");
                boolean isAutoIncrement = Boolean.parseBoolean(colElem.attributeValue("isAutoIncrement"));
                boolean isGenerateAsIdentity = Boolean.parseBoolean(colElem.attributeValue("isGenerateAsIdentity"));
                if (isGenerateAsIdentity) {
                    identParams = new SequenceParameters();
                    String tmp = colElem.attributeValue("startWith");
                    if (null != tmp) {
                        identParams.mStartWith = Long.parseLong(tmp);
                    }
                    if (null != (tmp = colElem.attributeValue("minValue"))) {
                        identParams.mMinValue = Long.parseLong(tmp);
                    }
                    if (null != (tmp = colElem.attributeValue("maxValue"))) {
                        identParams.mMaxValue = Long.parseLong(tmp);
                    }
                    if (null != (tmp = colElem.attributeValue("incrementBy"))) {
                        identParams.mIncrementBy = Long.parseLong(tmp);
                    }
                    if (null != (tmp = colElem.attributeValue("cycle"))) {
                        identParams.mCycle = Boolean.parseBoolean(tmp);
                    }
                    if (null != (tmp = colElem.attributeValue("cache"))) {
                        identParams.mCache = Long.parseLong(tmp);
                    }
                } else {
                    identParams = null;
                }
                tableDesc.addColumn(colName, ColumnType.parse((String)colType), EnumSet.noneOf(ColumnConstraint.class), defaultValue, isAutoIncrement, isGenerateAsIdentity, identParams);
            }
            this.mTablesByName.put(tableName, new Table(this, tableDesc));
        }
    }
}

