/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.storage.data.tabular;

import com.ibm.cognos.aurora.api.storage.StorageException;
import com.ibm.cognos.aurora.api.storage.data.tabular.IBatchRowInsert;
import com.ibm.cognos.aurora.api.storage.data.tabular.ILocalTabularStorage;
import com.ibm.cognos.aurora.api.storage.data.tabular.ITable;
import com.ibm.cognos.aurora.api.storage.data.tabular.ITableDescriptor;
import com.ibm.cognos.aurora.qls.storage.data.tabular.AbstractLocalTabularStorage;
import java.io.File;

public class Table
implements ITable {
    private final AbstractLocalTabularStorage mStorage;
    private final ITableDescriptor mDescriptor;

    protected Table(AbstractLocalTabularStorage storage, ITableDescriptor descriptor) {
        this.mStorage = storage;
        this.mDescriptor = descriptor;
    }

    public String getName() {
        return this.mDescriptor.getName();
    }

    public String getIdentifier() {
        return this.mDescriptor.getIdentifier();
    }

    public ITableDescriptor getDescriptor() {
        return this.mDescriptor;
    }

    public ILocalTabularStorage getStorage() {
        return this.mStorage;
    }

    public boolean exists() {
        return this.mStorage.queryTableExists(this.mDescriptor.getIdentifier());
    }

    public void clear() {
        this.mStorage.clearTable(this.mDescriptor.getName());
    }

    public void drop() {
        this.mStorage.dropTable(this.mDescriptor.getName());
    }

    public void importCSV(File csvPath, String fieldSeparator, String recordSeparator, String encapsulator, String nullIndicator) throws StorageException {
        this.mStorage.importCSV(this.mDescriptor.getName(), csvPath, fieldSeparator, recordSeparator, encapsulator, nullIndicator);
    }

    public void importCSV(File csvPath, long recordCount, String fieldSeparator, String recordSeparator, String encapsulator, String nullIndicator) throws StorageException {
        this.mStorage.importCSV(this.mDescriptor.getName(), recordCount, csvPath, fieldSeparator, recordSeparator, encapsulator, nullIndicator);
    }

    public IBatchRowInsert prepareBatchInsert() {
        return this.mStorage.prepareBatchInsert(this.mDescriptor.getName());
    }
}

