/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.storage.data.tabular;

import com.ibm.cognos.aurora.api.storage.data.tabular.ColumnConstraint;
import com.ibm.cognos.aurora.api.storage.data.tabular.ColumnType;
import com.ibm.cognos.aurora.api.storage.data.tabular.IColumnDescriptor;
import com.ibm.cognos.aurora.api.storage.data.tabular.ITableDescriptor;
import com.ibm.cognos.aurora.api.storage.data.tabular.SequenceParameters;
import com.ibm.cognos.aurora.qls.exception.QLSMessageKeys;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.storage.data.tabular.ColumnDescriptor;
import com.ibm.cognos.aurora.qls.util.IdentifierMaker;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class TableDescriptor
implements ITableDescriptor {
    private final String mName;
    private final String mIdentifier;
    private final List<IColumnDescriptor> mColumns = new ArrayList<IColumnDescriptor>();
    private String[] mUniqueColumns;
    private String[] mPrimaryKeyColumns;

    public TableDescriptor(String name, String identifier) {
        this.mName = name;
        this.mIdentifier = identifier;
    }

    public String getName() {
        return this.mName;
    }

    public String getIdentifier() {
        return this.mIdentifier;
    }

    public List<IColumnDescriptor> getColumns() {
        return this.mColumns;
    }

    public IColumnDescriptor getColumn(String name) {
        for (IColumnDescriptor col : this.mColumns) {
            if (!col.getName().equals(name)) continue;
            return col;
        }
        return null;
    }

    public IColumnDescriptor addColumn(String name, ColumnType type) {
        if (null != this.getColumn(name)) {
            throw new QLSRuntimeException(QLSMessageKeys.MOD_ColumnNameAlreadyUsed, name);
        }
        String identifier = IdentifierMaker.fromParts(name);
        ColumnDescriptor colDesc = new ColumnDescriptor(name, identifier, type, null, null, false, false, null);
        this.mColumns.add(colDesc);
        return colDesc;
    }

    public IColumnDescriptor addColumn(String name, ColumnType type, EnumSet<ColumnConstraint> constraints, Object defaultValue, boolean isAutoIncrement, boolean isGenerateAsIdentity, SequenceParameters identityParameters) {
        String identifier = IdentifierMaker.fromParts(name);
        ColumnDescriptor colDesc = new ColumnDescriptor(name, identifier, type, constraints, defaultValue, isAutoIncrement, isGenerateAsIdentity, identityParameters);
        this.mColumns.add(colDesc);
        return colDesc;
    }

    public String[] getUniqueColumns() {
        return this.mUniqueColumns;
    }

    public void setUniqueColumns(String[] uniqueColumns) {
        this.mUniqueColumns = uniqueColumns;
    }

    public String[] getPrimaryKeyColumns() {
        return this.mPrimaryKeyColumns;
    }

    public void setPrimaryKeyColumns(String[] primaryKeyColumns) {
        this.mPrimaryKeyColumns = primaryKeyColumns;
    }
}

