/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.storage.waypoint;

import com.ibm.cognos.aurora.api.storage.EStorageState;
import com.ibm.cognos.aurora.api.storage.StorageException;
import com.ibm.cognos.aurora.api.storage.StorageUnavailableException;
import com.ibm.cognos.aurora.api.storage.waypoint.IWaypointStorage;
import com.ibm.cognos.aurora.api.storage.waypoint.IWaypointStorageManager;
import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LoggerManager;
import com.ibm.cognos.aurora.qls.storage.waypoint.AbstractWaypointStorageManager;
import java.util.concurrent.TimeUnit;

public abstract class AbstractWaypointStorage
implements IWaypointStorage {
    protected static final ILogger looger = LoggerManager.getLogger((String)"ATHENA.core.qls");
    private final AbstractWaypointStorageManager mManager;
    private final String mUUID;
    private volatile EStorageState mState = EStorageState.PASSIVE;
    private volatile int mReservationCount = 0;
    private final Object mSync = new Object();
    private volatile long mLastAccessTime = System.nanoTime();

    public AbstractWaypointStorage(AbstractWaypointStorageManager manager, String uuid) {
        this.mManager = manager;
        this.mUUID = uuid;
    }

    public final IWaypointStorageManager getManager() {
        return this.mManager;
    }

    public final String getUUID() {
        return this.mUUID;
    }

    public final EStorageState getState() {
        return this.mState;
    }

    protected final long idleTime(TimeUnit unit) {
        long deltaNanos = System.nanoTime() - this.mLastAccessTime;
        return unit.convert(deltaNanos, TimeUnit.NANOSECONDS);
    }

    protected final void stampLastAccessTime() {
        this.mLastAccessTime = System.nanoTime();
    }

    protected abstract void autoCheckpoint();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void reserve() throws StorageException {
        this.stampLastAccessTime();
        if (looger.isDebugEnabled()) {
            looger.debug(String.format("Reserving storage (UUID=%s)", this.getUUID()), this.getClass().getName() + "::reserve()");
        }
        Object object = this.mSync;
        synchronized (object) {
            while (EStorageState.ACTIVE != this.mState) {
                if (this.mManager.isDisposed() || EStorageState.DESTROYED == this.mState || EStorageState.DESTROYING == this.mState) {
                    throw new StorageUnavailableException(this.getUUID());
                }
                if (EStorageState.PASSIVE == this.mState || EStorageState.PASSIVATING == this.mState) {
                    this.activate();
                    continue;
                }
                try {
                    this.mSync.wait();
                }
                catch (InterruptedException ex) {}
            }
            AbstractWaypointStorage.assertState(EStorageState.ACTIVE, this.mState);
            ++this.mReservationCount;
            if (looger.isDebugEnabled()) {
                looger.debug(String.format("Reservation count (UUID=%s) is now %d", this.getUUID(), this.mReservationCount), this.getClass().getName() + "::reserve()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean reserveIfActive() throws StorageException {
        if (looger.isDebugEnabled()) {
            looger.debug(String.format("Reserving storage if active (UUID=%s)", this.getUUID()), this.getClass().getName() + "::reserveIfActive()");
        }
        Object object = this.mSync;
        synchronized (object) {
            while (EStorageState.ACTIVE != this.mState) {
                if (this.mManager.isDisposed() || EStorageState.DESTROYED == this.mState || EStorageState.DESTROYING == this.mState) {
                    throw new StorageUnavailableException(this.getUUID());
                }
                if (EStorageState.PASSIVE == this.mState || EStorageState.PASSIVATING == this.mState) {
                    if (looger.isDebugEnabled()) {
                        looger.debug(String.format("Aborting reservation of storage (UUID=%s), since it is not active", this.getUUID()), this.getClass().getName() + "::reserveIfActive()");
                    }
                    return false;
                }
                try {
                    this.mSync.wait();
                }
                catch (InterruptedException ex) {}
            }
            AbstractWaypointStorage.assertState(EStorageState.ACTIVE, this.mState);
            ++this.mReservationCount;
            if (looger.isDebugEnabled()) {
                looger.debug(String.format("Reservation count (UUID=%s) is now %d", this.getUUID(), this.mReservationCount), this.getClass().getName() + "::reserveIfActive()");
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void unreserve() throws StorageException {
        if (looger.isDebugEnabled()) {
            looger.debug(String.format("Unreserving storage (UUID=%s)", this.getUUID()), this.getClass().getName() + "::unreserve()");
        }
        Object object = this.mSync;
        synchronized (object) {
            --this.mReservationCount;
            if (this.mReservationCount < 0) {
                throw new IllegalStateException("Reservation count < 0");
            }
            if (looger.isDebugEnabled()) {
                looger.debug(String.format("Reservation count (UUID=%s) is now %d", this.getUUID(), this.mReservationCount), this.getClass().getName() + "::unreserve()");
            }
            this.mSync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void activate() throws StorageException {
        this.stampLastAccessTime();
        if (looger.isDebugEnabled()) {
            looger.debug(String.format("Activating storage (UUID=%s)", this.getUUID()), this.getClass().getName() + "::activate()");
        }
        Object object = this.mSync;
        synchronized (object) {
            while (EStorageState.PASSIVE != this.mState) {
                if (this.mManager.isDisposed() || EStorageState.DESTROYED == this.mState || EStorageState.DESTROYING == this.mState) {
                    throw new StorageUnavailableException(this.getUUID());
                }
                if (EStorageState.ACTIVE == this.mState || EStorageState.ACTIVATING == this.mState) {
                    if (looger.isDebugEnabled()) {
                        looger.debug(String.format("Storage already active (UUID=%s)", this.getUUID()), this.getClass().getName() + "::activate()");
                    }
                    return;
                }
                try {
                    this.mSync.wait();
                }
                catch (InterruptedException ex) {}
            }
            AbstractWaypointStorage.assertState(EStorageState.PASSIVE, this.mState);
            this.mState = EStorageState.ACTIVATING;
            try {
                this.activateImpl();
                this.mState = EStorageState.ACTIVE;
            }
            catch (RuntimeException ex) {
                looger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::activate()", (Throwable)ex);
                this.mState = EStorageState.PASSIVE;
                throw ex;
            }
            finally {
                this.mSync.notifyAll();
            }
        }
    }

    protected abstract void activateImpl() throws StorageException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void passivate() throws StorageException {
        if (looger.isInfoEnabled()) {
            looger.info(String.format("Passivating storage (UUID=%s)", this.getUUID()), this.getClass().getName() + "::passivate()");
        }
        Object object = this.mSync;
        synchronized (object) {
            while (EStorageState.ACTIVE != this.mState) {
                if (EStorageState.DESTROYED == this.mState || EStorageState.DESTROYING == this.mState) {
                    throw new StorageUnavailableException(this.getUUID());
                }
                if (EStorageState.PASSIVE == this.mState || EStorageState.PASSIVATING == this.mState) {
                    if (looger.isInfoEnabled()) {
                        looger.info(String.format("Storage already passive (UUID=%s)", this.getUUID()), this.getClass().getName() + "::passivate()");
                    }
                    return;
                }
                try {
                    this.mSync.wait();
                }
                catch (InterruptedException ex) {}
            }
            AbstractWaypointStorage.assertState(EStorageState.ACTIVE, this.mState);
            this.mState = EStorageState.PASSIVATING;
            while (this.mReservationCount > 0) {
                AbstractWaypointStorage.assertState(EStorageState.PASSIVATING, this.mState);
                try {
                    this.mSync.wait();
                }
                catch (InterruptedException ex) {}
            }
            AbstractWaypointStorage.assertState(EStorageState.PASSIVATING, this.mState);
            try {
                this.passivateImpl();
            }
            finally {
                this.mState = EStorageState.PASSIVE;
                this.mSync.notifyAll();
            }
        }
    }

    protected abstract void passivateImpl() throws StorageException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy() throws StorageException {
        if (looger.isInfoEnabled()) {
            looger.info(String.format("Destroying storage (UUID=%s)", this.getUUID()), this.getClass().getName() + "::destroy()");
        }
        Object object = this.mSync;
        synchronized (object) {
            if (this.mManager.isDisposed()) {
                throw new StorageUnavailableException(this.getUUID());
            }
            if (EStorageState.DESTROYED == this.mState || EStorageState.DESTROYING == this.mState) {
                if (looger.isInfoEnabled()) {
                    looger.info(String.format("Storage already destroyed (UUID=%s)", this.getUUID()), this.getClass().getName() + "::destroy()");
                }
                return;
            }
            this.mState = EStorageState.DESTROYING;
            while (this.mReservationCount > 0) {
                AbstractWaypointStorage.assertState(EStorageState.DESTROYING, this.mState);
                try {
                    this.mSync.wait();
                }
                catch (InterruptedException ex) {}
            }
            AbstractWaypointStorage.assertState(EStorageState.DESTROYING, this.mState);
            try {
                this.destroyImpl();
            }
            finally {
                this.mState = EStorageState.DESTROYED;
                this.mSync.notifyAll();
            }
        }
    }

    protected abstract void destroyImpl() throws StorageException;

    private static void assertState(EStorageState expectedState, EStorageState actualState) {
        if (expectedState != actualState) {
            throw new IllegalStateException(String.format("Expected state to be <%s>, but found <%s>", expectedState.toString(), actualState.toString()));
        }
    }
}

