/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.storage.waypoint;

import com.ibm.cognos.aurora.api.query.IQueryLogicalStorage;
import com.ibm.cognos.aurora.api.storage.EStorageState;
import com.ibm.cognos.aurora.api.storage.StorageException;
import com.ibm.cognos.aurora.api.storage.waypoint.IWaypointStorage;
import com.ibm.cognos.aurora.api.storage.waypoint.IWaypointStorageManager;
import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LoggerManager;
import com.ibm.cognos.aurora.qls.storage.waypoint.AbstractWaypointStorage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public abstract class AbstractWaypointStorageManager
implements IWaypointStorageManager {
    private static final long DEFAULT_MAINTENANCE_INTERVAL = 1000L;
    private static final int DEFAULT_ACTIVE_IDLE_TIME = 300;
    private static final String WAYPOINT_DIR_PATH = "storage/waypoint";
    private static final String INDEX_FILE_PATH = "storage/waypoint/index.xml";
    private static final ILogger logger = LoggerManager.getLogger((String)"ATHENA.core.qls");
    private final IQueryLogicalStorage mQLS;
    private final String mWaypointStorageDirPath;
    private final ConcurrentHashMap<String, AbstractWaypointStorage> mStoragesByUUID = new ConcurrentHashMap();
    private int mActiveIdleTime = 300;
    private long mMaintenanceInterval = 1000L;
    private final Timer mMaintenanceTimer = new Timer("WPStorageTimer", true);
    private volatile boolean mDisposed = false;

    public AbstractWaypointStorageManager(IQueryLogicalStorage qls) {
        this.mQLS = qls;
        this.mWaypointStorageDirPath = FilenameUtils.concat((String)this.mQLS.getDataDirPath(), (String)WAYPOINT_DIR_PATH);
    }

    public final File getWaypointStorageDir() {
        return new File(this.mWaypointStorageDirPath);
    }

    public final void initialize() throws StorageException {
        this.initializeImpl();
        try {
            this.loadIndex();
        }
        catch (Exception ex) {
            throw new StorageException((Throwable)ex);
        }
        this.mMaintenanceTimer.schedule((TimerTask)new MaintenanceTask(), this.mMaintenanceInterval);
    }

    protected abstract void initializeImpl() throws StorageException;

    protected abstract AbstractWaypointStorage createStorageImpl(String var1) throws StorageException;

    private void runMaintenanceCheck() {
        for (AbstractWaypointStorage storage : this.mStoragesByUUID.values()) {
            if (this.mDisposed) {
                return;
            }
            long idleSeconds = storage.idleTime(TimeUnit.SECONDS);
            try {
                if (EStorageState.ACTIVE != storage.getState()) continue;
                if (idleSeconds > (long)this.mActiveIdleTime) {
                    if (logger.isInfoEnabled()) {
                        logger.info(String.format("Storage (UUID=%s) has been idle for too long (%d seconds) and will be passivated", storage.getUUID(), idleSeconds), this.getClass().getName() + "::runMaintenanceCheck()");
                    }
                    storage.passivate();
                    continue;
                }
                storage.autoCheckpoint();
            }
            catch (Throwable ex) {
                logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::runMaintenanceCheck()", ex);
            }
        }
        if (!this.mDisposed) {
            this.mMaintenanceTimer.schedule((TimerTask)new MaintenanceTask(), this.mMaintenanceInterval);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void saveIndex() throws IOException {
        FileUtils.forceMkdir((File)this.getWaypointStorageDir());
        String waypointIndexFilePath = FilenameUtils.concat((String)this.mQLS.getDataDirPath(), (String)INDEX_FILE_PATH);
        File waypointIndexFile = new File(waypointIndexFilePath);
        Document doc = this.encodeIndexDocument();
        OutputFormat format = OutputFormat.createPrettyPrint();
        FileOutputStream os = FileUtils.openOutputStream((File)waypointIndexFile);
        try {
            XMLWriter writer = new XMLWriter((OutputStream)os, format);
            writer.write(doc);
            writer.flush();
        }
        finally {
            ((OutputStream)os).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void loadIndex() throws IOException, DocumentException {
        String waypointIndexFilePath = FilenameUtils.concat((String)this.mQLS.getDataDirPath(), (String)INDEX_FILE_PATH);
        File waypointIndexFile = new File(waypointIndexFilePath);
        if (!waypointIndexFile.exists()) {
            return;
        }
        SAXReader reader = new SAXReader();
        FileInputStream is = FileUtils.openInputStream((File)waypointIndexFile);
        try {
            Document doc = reader.read((InputStream)is);
            this.decodeIndexDocument(doc);
        }
        finally {
            ((InputStream)is).close();
        }
    }

    private Document encodeIndexDocument() {
        Document doc = DocumentFactory.getInstance().createDocument("UTF8");
        Element rootElem = doc.addElement("waypointStorageIndex");
        for (String uuid : this.mStoragesByUUID.keySet()) {
            Element storageElem = rootElem.addElement("waypointStorage");
            storageElem.addAttribute("uuid", uuid);
        }
        return doc;
    }

    private void decodeIndexDocument(Document doc) throws IOException, DocumentException {
        this.mStoragesByUUID.clear();
        Element rootElem = doc.getRootElement();
        for (Element storageElem : rootElem.elements("waypointStorage")) {
            String uuid = storageElem.attributeValue("uuid");
            try {
                AbstractWaypointStorage storage = this.createStorageImpl(uuid);
                this.mStoragesByUUID.put(uuid, storage);
            }
            catch (Exception ex) {
                logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::decodeIndexDocument()", (Throwable)ex);
            }
        }
    }

    public IQueryLogicalStorage getQLS() {
        return this.mQLS;
    }

    public final boolean isDisposed() {
        return this.mDisposed;
    }

    protected final void assertNotDisposed() {
        if (this.mDisposed) {
            throw new IllegalStateException("Storage Manager was disposed");
        }
    }

    public final int getActiveIdleTime() {
        return this.mActiveIdleTime;
    }

    public void setActiveIdleTime(int activeIdleTime) {
        if (activeIdleTime < 1) {
            throw new IllegalArgumentException("activeIdleTime must be > 0");
        }
        this.mActiveIdleTime = activeIdleTime;
    }

    public final long getMaintenanceInterval() {
        return this.mMaintenanceInterval;
    }

    public void setMaintenanceInterval(long maintenanceInterval) {
        if (maintenanceInterval < 1L) {
            throw new IllegalArgumentException("maintenanceInterval must be > 0");
        }
        this.mMaintenanceInterval = maintenanceInterval;
    }

    public final IWaypointStorage createStorage() throws StorageException {
        this.assertNotDisposed();
        String uuid = UUID.randomUUID().toString();
        if (logger.isInfoEnabled()) {
            logger.info(String.format("Creating new storage (UUID=%s)", uuid), this.getClass().getName() + "::createStorage()");
        }
        AbstractWaypointStorage storage = this.createStorageImpl(uuid);
        try {
            storage.activate();
        }
        catch (RuntimeException ex) {
            logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::createStorage()");
            try {
                storage.destroy();
            }
            catch (Throwable ex2) {
                logger.error(ex2.getLocalizedMessage(), this.getClass().getName() + "::createStorage()", ex2);
            }
            throw ex;
        }
        this.mStoragesByUUID.putIfAbsent(uuid, storage);
        try {
            this.saveIndex();
        }
        catch (Exception ex) {
            throw new StorageException((Throwable)ex);
        }
        return storage;
    }

    public final IWaypointStorage getStorage(String uuid) throws StorageException {
        this.assertNotDisposed();
        return this.mStoragesByUUID.get(uuid);
    }

    public final IWaypointStorage[] getAllStorage() throws StorageException {
        this.assertNotDisposed();
        return this.mStoragesByUUID.values().toArray(new IWaypointStorage[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroyStorage(String uuid) throws StorageException {
        this.assertNotDisposed();
        if (logger.isInfoEnabled()) {
            logger.info(String.format("Destroying storage (UUID=%s)", uuid), this.getClass().getName() + "::destroyStorage()");
        }
        AbstractWaypointStorage storage = this.mStoragesByUUID.remove(uuid);
        try {
            if (null != storage) {
                storage.destroy();
            } else if (logger.isWarnEnabled()) {
                logger.warn(String.format("Storage not found (UUID=%s)", uuid), this.getClass().getName() + "::destroyStorage()");
            }
        }
        finally {
            try {
                this.saveIndex();
            }
            catch (Exception ex) {
                throw new StorageException((Throwable)ex);
            }
        }
    }

    public void dispose() throws StorageException {
        if (this.mDisposed) {
            return;
        }
        this.mDisposed = true;
        this.mMaintenanceTimer.cancel();
        logger.info("Storage Manager is being disposed", this.getClass().getName() + "::dispose()");
        for (AbstractWaypointStorage storage : this.mStoragesByUUID.values()) {
            try {
                EStorageState state = storage.getState();
                if (EStorageState.ACTIVE != state && EStorageState.ACTIVATING != state) continue;
                storage.passivate();
            }
            catch (Throwable ex) {
                logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::dispose()", ex);
            }
        }
        try {
            this.saveIndex();
        }
        catch (Exception ex) {
            throw new StorageException((Throwable)ex);
        }
        finally {
            this.mStoragesByUUID.clear();
            this.disposeImpl();
        }
    }

    protected abstract void disposeImpl() throws StorageException;

    private final class MaintenanceTask
    extends TimerTask {
        private MaintenanceTask() {
        }

        @Override
        public void run() {
            AbstractWaypointStorageManager.this.runMaintenanceCheck();
        }
    }
}

