/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.storage.waypoint.mem;

import com.ibm.cognos.aurora.api.storage.waypoint.TrailRecord;
import com.ibm.cognos.aurora.api.storage.waypoint.WaypointRecord;
import com.ibm.cognos.aurora.qls.storage.waypoint.mem.InMemoryWaypoint;
import java.util.ArrayList;
import java.util.List;

public final class InMemoryTrail {
    private final String mId;
    private String mName;
    private InMemoryWaypoint mRoot;
    private InMemoryWaypoint mCurrent;
    private final List<InMemoryWaypoint> mWaypoints = new ArrayList<InMemoryWaypoint>();

    public InMemoryTrail(String id, String name) {
        this.mId = id;
        this.mName = name;
    }

    public String getId() {
        return this.mId;
    }

    public synchronized String getName() {
        return this.mName;
    }

    public synchronized void setName(String name) {
        this.mName = name;
    }

    public synchronized InMemoryWaypoint getRoot() {
        return this.mRoot;
    }

    public synchronized InMemoryWaypoint getCurrent() {
        return this.mCurrent;
    }

    public synchronized void setCurrent(InMemoryWaypoint current) {
        this.mCurrent = current;
    }

    public synchronized InMemoryWaypoint[] getWaypoints() {
        return this.mWaypoints.toArray(new InMemoryWaypoint[0]);
    }

    public synchronized void addWaypoint(InMemoryWaypoint waypoint) {
        this.mWaypoints.add(waypoint);
        if (null == this.mRoot) {
            this.mRoot = waypoint;
        }
        this.mCurrent = waypoint;
    }

    public String toString() {
        return this.makeRecord().toString();
    }

    public synchronized TrailRecord makeRecord() {
        WaypointRecord[] wpRecs = new WaypointRecord[this.mWaypoints.size()];
        for (int i = 0; i < wpRecs.length; ++i) {
            wpRecs[i] = this.mWaypoints.get(i).makeRecord();
        }
        return new TrailRecord(this.mId, this.mName, null == this.mRoot ? null : this.mRoot.getId(), null == this.mCurrent ? null : this.mCurrent.getId(), wpRecs);
    }
}

