/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.storage.waypoint.mem;

import com.ibm.cognos.aurora.api.storage.waypoint.AnnotationRecord;
import com.ibm.cognos.aurora.api.storage.waypoint.WaypointRecord;
import com.ibm.cognos.aurora.qls.storage.waypoint.mem.InMemoryAnnotation;
import com.ibm.cognos.aurora.qls.storage.waypoint.mem.InMemoryTrail;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class InMemoryWaypoint {
    private final String mId;
    private InMemoryWaypoint mParent;
    private InMemoryTrail mTrail;
    private String mName;
    private final String mAuthor;
    private final Date mCreationDate;
    private final String mCanvasState;
    private List<String> mTags = new ArrayList<String>();
    private Map<String, String> mMetaInfo = new HashMap<String, String>();
    private final List<InMemoryAnnotation> mAnnotations = new ArrayList<InMemoryAnnotation>();

    public InMemoryWaypoint(String id, String name, String author, Date creationDate, String canvasState) {
        this.mId = id;
        this.mName = name;
        this.mAuthor = author;
        this.mCreationDate = creationDate;
        this.mCanvasState = canvasState;
    }

    public String getId() {
        return this.mId;
    }

    public synchronized InMemoryWaypoint getParent() {
        return this.mParent;
    }

    public synchronized void setParent(InMemoryWaypoint parent) {
        this.mParent = parent;
    }

    public synchronized InMemoryTrail getTrail() {
        return this.mTrail;
    }

    public synchronized void setTrail(InMemoryTrail trail) {
        this.mTrail = trail;
    }

    public synchronized String getName() {
        return this.mName;
    }

    public synchronized void setName(String name) {
        this.mName = name;
    }

    public String getAuthor() {
        return this.mAuthor;
    }

    public Date getCreationDate() {
        return this.mCreationDate;
    }

    public String getCanvasState() {
        return this.mCanvasState;
    }

    public synchronized String[] getTags() {
        return this.mTags.toArray(new String[0]);
    }

    public void setTags(List<String> tags) {
        this.mTags = tags;
    }

    public synchronized void addTag(String tag) {
        if (!this.mTags.contains(tag)) {
            this.mTags.add(tag);
        }
    }

    public synchronized void removeTag(String tag) {
        this.mTags.remove(tag);
    }

    public synchronized Map<String, String> getMetaInfo() {
        return Collections.unmodifiableMap(this.mMetaInfo);
    }

    public void setMetaInfo(Map<String, String> metaInfo) {
        this.mMetaInfo = metaInfo;
    }

    public synchronized InMemoryAnnotation[] getAnnotations() {
        return this.mAnnotations.toArray(new InMemoryAnnotation[0]);
    }

    public synchronized void addAnnotation(InMemoryAnnotation annot) {
        this.mAnnotations.add(annot);
    }

    public synchronized void removeAnnotation(InMemoryAnnotation annot) {
        this.mAnnotations.remove(annot);
    }

    public String toString() {
        return this.makeRecord().toString();
    }

    public synchronized WaypointRecord makeRecord() {
        AnnotationRecord[] annotRecs = new AnnotationRecord[this.mAnnotations.size()];
        for (int i = 0; i < annotRecs.length; ++i) {
            annotRecs[i] = this.mAnnotations.get(i).makeRecord();
        }
        return new WaypointRecord(this.mId, null == this.mParent ? null : this.mParent.getId(), null == this.mTrail ? null : this.mTrail.getId(), this.mName, this.mAuthor, this.mCreationDate, this.mCanvasState, this.mTags.toArray(new String[0]), this.mMetaInfo, annotRecs);
    }
}

