/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.storage.waypoint.mem;

import com.ibm.cognos.aurora.api.model.value.TimestampValue;
import com.ibm.cognos.aurora.api.model.value.ValueFactory;
import com.ibm.cognos.aurora.api.storage.ITransaction;
import com.ibm.cognos.aurora.api.storage.StorageException;
import com.ibm.cognos.aurora.api.storage.waypoint.AnnotationRecord;
import com.ibm.cognos.aurora.api.storage.waypoint.NoSuchAnnotationException;
import com.ibm.cognos.aurora.api.storage.waypoint.NoSuchTrailException;
import com.ibm.cognos.aurora.api.storage.waypoint.NoSuchWaypointException;
import com.ibm.cognos.aurora.api.storage.waypoint.TrailRecord;
import com.ibm.cognos.aurora.api.storage.waypoint.WaypointRecord;
import com.ibm.cognos.aurora.qls.storage.waypoint.AbstractWaypointStorage;
import com.ibm.cognos.aurora.qls.storage.waypoint.AbstractWaypointStorageManager;
import com.ibm.cognos.aurora.qls.storage.waypoint.mem.InMemoryAnnotation;
import com.ibm.cognos.aurora.qls.storage.waypoint.mem.InMemoryTrail;
import com.ibm.cognos.aurora.qls.storage.waypoint.mem.InMemoryWaypoint;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public final class InMemoryWaypointStorage
extends AbstractWaypointStorage {
    private final ConcurrentMap<String, InMemoryTrail> mTrailMap = new ConcurrentHashMap<String, InMemoryTrail>();
    private final ConcurrentMap<String, InMemoryWaypoint> mWaypointMap = new ConcurrentHashMap<String, InMemoryWaypoint>();
    private final ConcurrentMap<String, InMemoryAnnotation> mAnnotationMap = new ConcurrentHashMap<String, InMemoryAnnotation>();
    private final File mSnapshotFile;
    private final AtomicBoolean mDirty = new AtomicBoolean(false);

    public InMemoryWaypointStorage(AbstractWaypointStorageManager manager, String uuid, String snapshotDirPath) {
        super(manager, uuid);
        this.mSnapshotFile = new File(FilenameUtils.concat((String)snapshotDirPath, (String)(uuid + ".xml")));
    }

    public File getSnapshotFile() {
        return this.mSnapshotFile;
    }

    public boolean isTransactionSupported() {
        return false;
    }

    public ITransaction createTransaction() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkpoint() {
        if (looger.isInfoEnabled()) {
            looger.info(String.format("Checkpoint storage (UUID=%s)", this.getUUID()), this.getClass().getName() + "::checkpoint()");
        }
        this.reserve();
        try {
            this.saveSnapshot();
        }
        finally {
            this.unreserve();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void autoCheckpoint() {
        if (this.reserveIfActive()) {
            if (looger.isInfoEnabled()) {
                looger.info(String.format("Auto-Checkpoint storage (UUID=%s)", this.getUUID()), this.getClass().getName() + "::autoCheckpoint()");
            }
            try {
                this.saveSnapshot();
            }
            finally {
                this.unreserve();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WaypointRecord createWaypoint(String id, String name, String author, Date creationDate, String canvasState, ITransaction tx) {
        if (null == author) {
            throw new IllegalArgumentException("author was null");
        }
        if (null == creationDate) {
            throw new IllegalArgumentException("creationDate was null");
        }
        if (null == canvasState) {
            throw new IllegalArgumentException("canvasState was null");
        }
        if (looger.isInfoEnabled()) {
            looger.info(String.format("Creating waypoint (UUID=%s)", this.getUUID()), this.getClass().getName() + "::createWaypoint()");
        }
        this.reserve();
        try {
            InMemoryWaypoint wp = new InMemoryWaypoint(id, name, author, creationDate, canvasState);
            this.mWaypointMap.putIfAbsent(id, wp);
            this.mDirty.set(true);
            WaypointRecord waypointRecord = wp.makeRecord();
            return waypointRecord;
        }
        finally {
            this.unreserve();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WaypointRecord readWaypoint(String waypointId, ITransaction tx) {
        if (looger.isInfoEnabled()) {
            looger.info(String.format("Reading waypoint (UUID=%s)", this.getUUID()), this.getClass().getName() + "::readWaypoint()");
        }
        this.reserve();
        try {
            InMemoryWaypoint wp = (InMemoryWaypoint)this.mWaypointMap.get(waypointId);
            if (null == wp) {
                throw new NoSuchWaypointException(waypointId);
            }
            WaypointRecord waypointRecord = wp.makeRecord();
            return waypointRecord;
        }
        finally {
            this.unreserve();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWaypointName(String waypointId, String name, ITransaction tx) throws StorageException {
        if (looger.isInfoEnabled()) {
            looger.info(String.format("Updating waypoint (UUID=%s)", this.getUUID()), this.getClass().getName() + "::updateWaypointName()");
        }
        this.reserve();
        try {
            InMemoryWaypoint wp = (InMemoryWaypoint)this.mWaypointMap.get(waypointId);
            if (null == wp) {
                throw new NoSuchWaypointException(waypointId);
            }
            wp.setName(name);
            this.mDirty.set(true);
        }
        finally {
            this.unreserve();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TrailRecord createTrail(String id, String name, ITransaction tx) throws StorageException {
        if (looger.isInfoEnabled()) {
            looger.info(String.format("Creating trail (UUID=%s)", this.getUUID()), this.getClass().getName() + "::createTrail()");
        }
        this.reserve();
        try {
            InMemoryTrail trail = new InMemoryTrail(id, name);
            this.mTrailMap.putIfAbsent(id, trail);
            this.mDirty.set(true);
            TrailRecord trailRecord = trail.makeRecord();
            return trailRecord;
        }
        finally {
            this.unreserve();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TrailRecord readTrail(String trailId, ITransaction tx) throws StorageException {
        if (looger.isInfoEnabled()) {
            looger.info(String.format("Reading trail (UUID=%s)", this.getUUID()), this.getClass().getName() + "::createTrail()");
        }
        this.reserve();
        try {
            InMemoryTrail trail = (InMemoryTrail)this.mTrailMap.get(trailId);
            if (null == trail) {
                throw new NoSuchTrailException(trailId);
            }
            TrailRecord trailRecord = trail.makeRecord();
            return trailRecord;
        }
        finally {
            this.unreserve();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTrailCurrent(String trailId, String currentId, ITransaction tx) throws StorageException, IllegalStateException {
        if (looger.isInfoEnabled()) {
            looger.info(String.format("Updating trail (UUID=%s)", this.getUUID()), this.getClass().getName() + "::updateTrailCurrent()");
        }
        this.reserve();
        try {
            InMemoryTrail trail = (InMemoryTrail)this.mTrailMap.get(trailId);
            if (null == trail) {
                throw new NoSuchTrailException(trailId);
            }
            InMemoryWaypoint current = (InMemoryWaypoint)this.mWaypointMap.get(currentId);
            if (null == current) {
                throw new NoSuchWaypointException(currentId);
            }
            if (current.getTrail() != trail) {
                throw new IllegalStateException("The node was not attached to the trail");
            }
            trail.setCurrent(current);
            this.mDirty.set(true);
        }
        finally {
            this.unreserve();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachWaypointToTrail(String trailId, String waypointId, String parentId, ITransaction tx) throws StorageException, IllegalStateException {
        if (looger.isInfoEnabled()) {
            looger.info(String.format("Attaching waypoint to trail (UUID=%s)", this.getUUID()), this.getClass().getName() + "::attachWaypointToTrail()");
        }
        this.reserve();
        try {
            InMemoryTrail trail = (InMemoryTrail)this.mTrailMap.get(trailId);
            if (null == trail) {
                throw new NoSuchTrailException(trailId);
            }
            InMemoryWaypoint wp = (InMemoryWaypoint)this.mWaypointMap.get(waypointId);
            if (null == wp) {
                throw new NoSuchWaypointException(waypointId);
            }
            if (null != wp.getTrail()) {
                throw new IllegalStateException("Waypoint was already attached to a trail");
            }
            if (null == parentId) {
                if (null == trail.getRoot()) {
                    trail.addWaypoint(wp);
                    wp.setTrail(trail);
                    wp.setParent(null);
                } else {
                    trail.addWaypoint(wp);
                    wp.setTrail(trail);
                    wp.setParent(trail.getCurrent());
                }
            } else {
                InMemoryWaypoint parent = (InMemoryWaypoint)this.mWaypointMap.get(parentId);
                if (null == parent) {
                    throw new NoSuchWaypointException(parentId);
                }
                if (parent.getTrail() != trail) {
                    throw new IllegalStateException("The parent was not attached to the trail");
                }
                trail.addWaypoint(wp);
                wp.setTrail(trail);
                wp.setParent(parent);
            }
            this.mDirty.set(true);
        }
        finally {
            this.unreserve();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTag(String waypointId, String tag, ITransaction tx) throws StorageException {
        if (null == tag) {
            throw new IllegalArgumentException("tag was null");
        }
        if (tag.length() == 0) {
            throw new IllegalArgumentException("tag was empty");
        }
        if (looger.isInfoEnabled()) {
            looger.info(String.format("Creating tag (UUID=%s)", this.getUUID()), this.getClass().getName() + "::createTag()");
        }
        this.reserve();
        try {
            InMemoryWaypoint wp = (InMemoryWaypoint)this.mWaypointMap.get(waypointId);
            if (null == wp) {
                throw new NoSuchWaypointException(waypointId);
            }
            wp.addTag(tag);
            this.mDirty.set(true);
        }
        finally {
            this.unreserve();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTag(String waypointId, String tag, ITransaction tx) throws StorageException {
        if (looger.isInfoEnabled()) {
            looger.info(String.format("Deleting tag (UUID=%s)", this.getUUID()), this.getClass().getName() + "::deleteTag()");
        }
        this.reserve();
        try {
            InMemoryWaypoint wp = (InMemoryWaypoint)this.mWaypointMap.get(waypointId);
            if (null == wp) {
                throw new NoSuchWaypointException(waypointId);
            }
            wp.removeTag(tag);
            this.mDirty.set(true);
        }
        finally {
            this.unreserve();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTags(String waypointId, List<String> tags, ITransaction tx) throws StorageException {
        if (null == tags) {
            throw new IllegalArgumentException("tags is null");
        }
        if (looger.isInfoEnabled()) {
            looger.info(String.format("Setting tags (UUID=%s)", this.getUUID()), this.getClass().getName() + "::setTags()");
        }
        this.reserve();
        try {
            InMemoryWaypoint wp = (InMemoryWaypoint)this.mWaypointMap.get(waypointId);
            if (null == wp) {
                throw new NoSuchWaypointException(waypointId);
            }
            wp.setTags(tags);
            this.mDirty.set(true);
        }
        finally {
            this.unreserve();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMetaInfo(String waypointId, Map<String, String> metaInfo, ITransaction tx) throws StorageException {
        if (null == metaInfo) {
            throw new IllegalArgumentException("meta info is null");
        }
        if (looger.isInfoEnabled()) {
            looger.info(String.format("Setting meta info (UUID=%s)", this.getUUID()), this.getClass().getName() + "::setMetaInfo()");
        }
        this.reserve();
        try {
            InMemoryWaypoint wp = (InMemoryWaypoint)this.mWaypointMap.get(waypointId);
            if (null == wp) {
                throw new NoSuchWaypointException(waypointId);
            }
            wp.setMetaInfo(metaInfo);
            this.mDirty.set(true);
        }
        finally {
            this.unreserve();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnnotationRecord createAnnotation(String annotationId, String waypointId, String body, ITransaction tx) throws StorageException {
        if (null == body) {
            throw new IllegalArgumentException("body was null");
        }
        if (looger.isInfoEnabled()) {
            looger.info(String.format("Creating annotation (UUID=%s)", this.getUUID()), this.getClass().getName() + "::createAnnotation()");
        }
        this.reserve();
        try {
            InMemoryWaypoint wp = (InMemoryWaypoint)this.mWaypointMap.get(waypointId);
            if (null == wp) {
                throw new NoSuchWaypointException(waypointId);
            }
            InMemoryAnnotation annot = new InMemoryAnnotation(annotationId, wp, body);
            wp.addAnnotation(annot);
            this.mAnnotationMap.putIfAbsent(annotationId, annot);
            this.mDirty.set(true);
            AnnotationRecord annotationRecord = annot.makeRecord();
            return annotationRecord;
        }
        finally {
            this.unreserve();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnnotationRecord readAnnotation(String annotationId, ITransaction tx) throws StorageException {
        if (looger.isInfoEnabled()) {
            looger.info(String.format("Reading annotation (UUID=%s)", this.getUUID()), this.getClass().getName() + "::readAnnotation()");
        }
        this.reserve();
        try {
            InMemoryAnnotation annot = (InMemoryAnnotation)this.mAnnotationMap.get(annotationId);
            if (null == annot) {
                throw new NoSuchAnnotationException(annotationId);
            }
            AnnotationRecord annotationRecord = annot.makeRecord();
            return annotationRecord;
        }
        finally {
            this.unreserve();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAnnotationBody(String annotationId, String body, ITransaction tx) throws StorageException {
        if (null == body) {
            throw new IllegalArgumentException("body was null");
        }
        if (looger.isInfoEnabled()) {
            looger.info(String.format("Updating annotation (UUID=%s)", this.getUUID()), this.getClass().getName() + "::updateAnnotationBody()");
        }
        this.reserve();
        try {
            InMemoryAnnotation annot = (InMemoryAnnotation)this.mAnnotationMap.get(annotationId);
            if (null == annot) {
                throw new NoSuchAnnotationException(annotationId);
            }
            annot.setBody(body);
            this.mDirty.set(true);
        }
        finally {
            this.unreserve();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAnnotation(String annotationId, ITransaction tx) throws StorageException {
        if (looger.isInfoEnabled()) {
            looger.info(String.format("Deleting annotation (UUID=%s)", this.getUUID()), this.getClass().getName() + "::deleteAnnotation()");
        }
        this.reserve();
        try {
            InMemoryAnnotation annot = (InMemoryAnnotation)this.mAnnotationMap.remove(annotationId);
            if (null == annot) {
                throw new NoSuchAnnotationException(annotationId);
            }
            annot.getWaypoint().removeAnnotation(annot);
            this.mDirty.set(true);
        }
        finally {
            this.unreserve();
        }
    }

    public String toString() {
        return "InMemoryWaypointStorage(uuid=" + this.getUUID() + ")";
    }

    @Override
    protected void activateImpl() throws StorageException {
        if (this.mSnapshotFile.exists()) {
            this.loadSnapshot();
        } else {
            try {
                this.mSnapshotFile.createNewFile();
            }
            catch (IOException ex) {
                throw new StorageException((Throwable)ex);
            }
        }
    }

    @Override
    protected void passivateImpl() throws StorageException {
        this.saveSnapshot();
        this.clearStorage();
    }

    @Override
    protected void destroyImpl() throws StorageException {
        this.clearStorage();
        if (this.mSnapshotFile.exists()) {
            this.mSnapshotFile.delete();
        }
    }

    private void clearStorage() {
        this.mAnnotationMap.clear();
        this.mTrailMap.clear();
        this.mWaypointMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSnapshot() {
        this.clearStorage();
        if (!this.mSnapshotFile.exists()) {
            return;
        }
        try {
            SAXReader reader = new SAXReader();
            FileInputStream is = FileUtils.openInputStream((File)this.mSnapshotFile);
            try {
                Document doc = reader.read((InputStream)is);
                this.decodeSnapshotDocument(doc);
            }
            finally {
                ((InputStream)is).close();
            }
        }
        catch (Exception ex) {
            throw new StorageException((Throwable)ex);
        }
    }

    private void decodeSnapshotDocument(Document doc) {
        Element rootElem = doc.getRootElement();
        Element trailsElem = rootElem.element("trails");
        for (Element trailElem : trailsElem.elements("trail")) {
            InMemoryTrail trail = new InMemoryTrail(trailElem.attributeValue("id"), trailElem.attributeValue("name"));
            this.mTrailMap.putIfAbsent(trail.getId(), trail);
            for (Element wpElem : trailElem.elements("waypoint")) {
                TimestampValue ts = ValueFactory.createTimestamp();
                ts.assignFrom(wpElem.attributeValue("creationDate"));
                if (!ts.isOK()) {
                    throw new IllegalArgumentException("creationDate was malformed");
                }
                InMemoryWaypoint wp = new InMemoryWaypoint(wpElem.attributeValue("id"), wpElem.attributeValue("name"), wpElem.attributeValue("author"), ts.dateValue(), wpElem.attributeValue("canvasState"));
                this.mWaypointMap.putIfAbsent(wp.getId(), wp);
                trail.addWaypoint(wp);
                wp.setTrail(trail);
                if (null != wpElem.attributeValue("parentId")) {
                    String parentId = wpElem.attributeValue("parentId");
                    wp.setParent((InMemoryWaypoint)this.mWaypointMap.get(parentId));
                }
                for (Element tagElem : wpElem.elements("tag")) {
                    wp.addTag(tagElem.getText());
                }
                for (Element annotElem : wpElem.elements("annotation")) {
                    InMemoryAnnotation annot = new InMemoryAnnotation(annotElem.attributeValue("id"), wp, annotElem.getText());
                    this.mAnnotationMap.putIfAbsent(annot.getId(), annot);
                    wp.addAnnotation(annot);
                }
                if (trailElem.attributeValue("currentId") == null) continue;
                String currentId = trailElem.attributeValue("currentId");
                trail.setCurrent((InMemoryWaypoint)this.mWaypointMap.get(currentId));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSnapshot() {
        if (this.mDirty.compareAndSet(true, false)) {
            try {
                Document doc = this.encodeSnapshotDocument();
                OutputFormat format = OutputFormat.createPrettyPrint();
                FileOutputStream os = FileUtils.openOutputStream((File)this.mSnapshotFile);
                try {
                    XMLWriter writer = new XMLWriter((OutputStream)os, format);
                    writer.write(doc);
                    writer.flush();
                }
                finally {
                    ((OutputStream)os).close();
                }
            }
            catch (Exception ex) {
                throw new StorageException((Throwable)ex);
            }
        }
    }

    private Document encodeSnapshotDocument() {
        Document doc = DocumentFactory.getInstance().createDocument("UTF8");
        Element rootElem = doc.addElement("waypointSnapshot");
        Element trailsElem = rootElem.addElement("trails");
        for (InMemoryTrail trail : this.mTrailMap.values()) {
            Element trailElem = trailsElem.addElement("trail");
            trailElem.addAttribute("id", trail.getId());
            if (null != trail.getName()) {
                trailElem.addAttribute("name", trail.getName());
            }
            if (null != trail.getCurrent()) {
                trailElem.addAttribute("currentId", trail.getCurrent().getId());
            }
            for (InMemoryWaypoint wp : trail.getWaypoints()) {
                Element wpElem = trailElem.addElement("waypoint");
                wpElem.addAttribute("id", wp.getId());
                if (null != wp.getName()) {
                    wpElem.addAttribute("name", wp.getName());
                }
                if (null != wp.getAuthor()) {
                    wpElem.addAttribute("author", wp.getAuthor());
                }
                if (null != wp.getParent()) {
                    wpElem.addAttribute("parentId", wp.getParent().getId());
                }
                wpElem.addAttribute("creationDate", ValueFactory.createTimestamp((Date)wp.getCreationDate()).stringValue());
                wpElem.addAttribute("canvasState", wp.getCanvasState());
                for (String tag : wp.getTags()) {
                    wpElem.addElement("tag").setText(tag);
                }
                for (Map.Entry<String, String> e : wp.getMetaInfo().entrySet()) {
                    Element metaElem = wpElem.addElement("metaInfo");
                    metaElem.addAttribute(e.getKey(), e.getValue());
                }
                for (InMemoryAnnotation annot : wp.getAnnotations()) {
                    Element annotElem = wpElem.addElement("annotation");
                    annotElem.addAttribute("id", annot.getId());
                    annotElem.setText(annot.getBody());
                }
            }
        }
        return doc;
    }
}

