/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.storage.waypoint.mem;

import com.ibm.cognos.aurora.api.query.IQueryLogicalStorage;
import com.ibm.cognos.aurora.api.storage.StorageException;
import com.ibm.cognos.aurora.qls.storage.waypoint.AbstractWaypointStorage;
import com.ibm.cognos.aurora.qls.storage.waypoint.AbstractWaypointStorageManager;
import com.ibm.cognos.aurora.qls.storage.waypoint.mem.InMemoryWaypointStorage;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public final class InMemoryWaypointStorageManager
extends AbstractWaypointStorageManager {
    private static final String SNAPSHOTS_DIR_PATH = "storage/waypoint/snapshots";

    public InMemoryWaypointStorageManager(IQueryLogicalStorage qls) {
        super(qls);
    }

    @Override
    protected void initializeImpl() throws StorageException {
        String snapshotsDirPath = FilenameUtils.concat((String)this.getQLS().getDataDirPath(), (String)SNAPSHOTS_DIR_PATH);
        File snapshotsDir = new File(snapshotsDirPath);
        try {
            if (!snapshotsDir.exists()) {
                FileUtils.forceMkdir((File)snapshotsDir);
            }
        }
        catch (IOException ex) {
            throw new StorageException((Throwable)ex);
        }
    }

    @Override
    protected void disposeImpl() throws StorageException {
    }

    @Override
    protected AbstractWaypointStorage createStorageImpl(String uuid) {
        String snapshotsDirPath = FilenameUtils.concat((String)this.getQLS().getDataDirPath(), (String)SNAPSHOTS_DIR_PATH);
        return new InMemoryWaypointStorage(this, uuid, snapshotsDirPath);
    }
}

