/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.util;

import java.util.UUID;

public final class IdentifierMaker {
    public static String fromParts(String ... parts) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            long hash = 0L;
            for (int j = 0; j < part.length(); ++j) {
                char ch = part.charAt(j);
                if (ch > '~') {
                    hash += (long)ch;
                    continue;
                }
                if (Character.isLetterOrDigit(ch)) {
                    sb.append(ch);
                    continue;
                }
                if (ch == '_' || ch == '-' || ch == '/' || ch == '\\' || Character.isWhitespace(ch)) {
                    sb.append('_');
                    continue;
                }
                hash += (long)ch;
            }
            if (hash != 0L) {
                sb.append(Long.toHexString(hash));
            }
            if (i + 1 >= parts.length) continue;
            sb.append('_');
        }
        return sb.toString();
    }

    public static String generateRandomUUID() {
        return UUID.randomUUID().toString();
    }

    private IdentifierMaker() {
    }
}

