/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.util;

import com.ibm.cognos.aurora.api.model.IAttribute;
import com.ibm.cognos.aurora.api.model.ICalculation;
import com.ibm.cognos.aurora.api.model.IHierarchy;
import com.ibm.cognos.aurora.api.model.IMember;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.query.data.IAttributeValue;
import com.ibm.cognos.aurora.api.query.queryspec.IAggregationSpecification;
import com.ibm.cognos.aurora.api.query.queryspec.IAxisSpecification;
import com.ibm.cognos.aurora.api.query.queryspec.IQueryNode;
import com.ibm.cognos.aurora.api.query.queryspec.IQuerySpecification;
import com.ibm.cognos.aurora.api.query.queryspec.ISelectionSpecification;
import com.ibm.cognos.aurora.api.query.queryspec.ISetSpecification;
import com.ibm.cognos.aurora.api.query.queryspec.IView;
import com.ibm.cognos.aurora.api.query.queryspec.actions.IAxisAction;
import com.ibm.cognos.aurora.api.query.queryspec.actions.IFilter;
import com.ibm.cognos.aurora.api.query.queryspec.actions.IFilterByData;
import com.ibm.cognos.aurora.api.query.queryspec.actions.ISelectionAction;
import com.ibm.cognos.aurora.api.query.queryspec.actions.ISetAction;
import com.ibm.cognos.aurora.api.query.queryspec.actions.ISortKey;
import com.ibm.cognos.aurora.api.query.queryspec.actions.selection.IAllSelection;
import com.ibm.cognos.aurora.api.query.queryspec.actions.selection.IAttributeSelection;
import com.ibm.cognos.aurora.api.query.queryspec.actions.selection.ICategorySelection;
import com.ibm.cognos.aurora.api.query.queryspec.actions.selection.IDefaultValueSelection;
import com.ibm.cognos.aurora.api.query.queryspec.actions.selection.IExpandMembers;
import com.ibm.cognos.aurora.api.query.queryspec.actions.selection.IExpandToDepth;
import com.ibm.cognos.aurora.api.query.queryspec.actions.selection.IMembersByDepth;
import com.ibm.cognos.aurora.api.query.queryspec.actions.selection.IMembersSelection;
import com.ibm.cognos.aurora.api.query.queryspec.actions.selection.IMetricsSelection;
import com.ibm.cognos.aurora.api.query.queryspec.actions.selection.INodesSelection;
import com.ibm.cognos.aurora.api.query.queryspec.actions.selection.ISortByAttribute;
import com.ibm.cognos.aurora.api.query.queryspec.actions.selection.ISortByHierarchyOrder;
import com.ibm.cognos.aurora.api.query.queryspec.actions.selection.IValuesSelection;
import com.ibm.cognos.aurora.api.query.queryspec.actions.set.IFilterOnRange;
import com.ibm.cognos.aurora.api.query.queryspec.actions.set.ISortByData;
import com.ibm.cognos.aurora.api.query.queryspec.expression.EAggregationFunction;
import com.ibm.cognos.aurora.api.query.queryspec.expression.ICategoryMetricNode;
import com.ibm.cognos.aurora.api.query.queryspec.expression.IExpression;
import com.ibm.cognos.aurora.api.query.queryspec.expression.ILiteralNode;
import com.ibm.cognos.aurora.api.query.queryspec.expression.IOperator;
import com.ibm.cognos.aurora.api.query.queryspec.expression.IQuerySpecAttributeValue;
import com.ibm.cognos.aurora.api.query.queryspec.expression.IScalarFunction;
import com.ibm.cognos.aurora.api.query.queryspec.expression.ISetFunction;
import com.ibm.cognos.aurora.api.query.queryspec.expression.IValueListNode;
import com.ibm.cognos.aurora.api.query.queryspec.visitor.IQueryNodeVisitor;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.qls.query.queryspec.QuerySpecAbstractNode;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONArtifact;
import com.ibm.json.java.JSONObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class JSONEmitter
extends Stack<JSONArtifact>
implements IQueryNodeVisitor {
    public void visit(IQuerySpecification querySpec) {
        List views = querySpec.getViews();
        JSONObject jQuerySpec = new JSONObject();
        JSONArray jViews = new JSONArray();
        jQuerySpec.put((Object)"QuerySpec", (Object)jViews);
        for (IView view : views) {
            view.accept((IQueryNodeVisitor)this);
            jViews.add(this.pop());
        }
        this.push(jQuerySpec);
    }

    public void visit(IView view) {
        List axes = view.getAxes();
        ICalculation[] calculations = view.getCalculations();
        JSONObject jView = new JSONObject();
        JSONArray jCalcAndAxis = new JSONArray(axes.size());
        jView.put((Object)"View", (Object)jCalcAndAxis);
        for (ICalculation calculation : calculations) {
            calculation.accept((IQueryNodeVisitor)this);
            jCalcAndAxis.add(this.pop());
        }
        for (IAxisSpecification axis : axes) {
            axis.accept((IQueryNodeVisitor)this);
            jCalcAndAxis.add(this.pop());
        }
        this.push(jView);
    }

    public void visit(IAxisSpecification axis) {
        List sets = axis.getSetSpecifications();
        List actions = axis.getAxisActions();
        JSONObject jContent = new JSONObject();
        JSONArray jSets = new JSONArray(sets.size());
        jContent.put((Object)"axisId", (Object)axis.getAxisSpecID());
        jContent.put((Object)"sets", (Object)jSets);
        for (ISetSpecification set : sets) {
            set.accept((IQueryNodeVisitor)this);
            jSets.add(this.pop());
        }
        if (actions.size() > 0) {
            JSONArray jActions = new JSONArray(actions.size());
            jContent.put((Object)"actions", (Object)jActions);
            for (IAxisAction action : actions) {
                action.accept((IQueryNodeVisitor)this);
                jActions.add(this.pop());
            }
        }
        JSONObject jAxis = new JSONObject();
        jAxis.put((Object)"Axis", (Object)jContent);
        this.push(jAxis);
    }

    public void visit(ISetSpecification set) {
        List selections = set.getSelectionSpecifications();
        List actions = set.getSetActions();
        JSONArray jSelections = new JSONArray(selections.size());
        JSONObject jContent = new JSONObject();
        jContent.put((Object)"setId", (Object)set.getSetSpecID());
        jContent.put((Object)"selections", (Object)jSelections);
        for (ISelectionSpecification selection : selections) {
            selection.accept((IQueryNodeVisitor)this);
            jSelections.add(this.pop());
        }
        if (actions.size() > 0) {
            JSONArray jActions = new JSONArray(actions.size());
            jContent.put((Object)"actions", (Object)jActions);
            for (ISetAction action : actions) {
                action.accept((IQueryNodeVisitor)this);
                jActions.add(this.pop());
            }
        }
        JSONObject jSet = new JSONObject();
        jSet.put((Object)"Set", (Object)jContent);
        this.push(jSet);
    }

    public void visit(ISelectionSpecification selection) {
        List actions = selection.getSelectionActions();
        IHierarchy hierarchy = selection.getHierarchy();
        JSONObject jContent = new JSONObject();
        if (hierarchy != null) {
            jContent.put((Object)"hierarchy", (Object)hierarchy.getUniqueName());
        }
        JSONArray jActions = new JSONArray(actions.size());
        jContent.put((Object)"actions", (Object)jActions);
        for (ISelectionAction action : actions) {
            action.accept((IQueryNodeVisitor)this);
            jActions.add(this.pop());
        }
        IAggregationSpecification aggrSpec = selection.getAggregationSpecification();
        if (aggrSpec != null) {
            aggrSpec.accept((IQueryNodeVisitor)this);
            jActions.add(this.pop());
        }
        JSONObject jSelection = new JSONObject();
        jSelection.put((Object)"Selection", (Object)jContent);
        this.push(jSelection);
    }

    public void visit(IAggregationSpecification node) {
        JSONObject jContent;
        Iterator functions = node.getRollupFunctions();
        JSONArray jFunctions = new JSONArray(node.getNumberOfRollupFunctions());
        while (functions.hasNext()) {
            jContent = new JSONObject();
            Map.Entry function = (Map.Entry)functions.next();
            jContent.put((Object)"type", (Object)((EAggregationFunction)function.getValue()).toString());
            JSONArray jParameters = new JSONArray(1);
            jContent.put((Object)"parameters", (Object)jParameters);
            jParameters.add((Object)((INode)function.getKey()).toString());
            jFunctions.add((Object)jContent);
        }
        jContent = new JSONObject();
        jContent.put((Object)"AggregationSpecification", (Object)jFunctions);
        this.push(jContent);
    }

    public void visit(ICategorySelection node) {
        JSONObject jContent = new JSONObject();
        jContent.put((Object)"Category", (Object)node.getCategory().toString());
        this.push(jContent);
    }

    public void visit(IAttributeSelection node) {
        JSONObject jContent = new JSONObject();
        IAttribute attribute = node.getIAttribute();
        if (attribute != null) {
            jContent.put((Object)"Attribute", (Object)attribute.toString());
        } else {
            jContent.put((Object)"Attribute", (Object)node.getAttribute());
        }
        this.push(jContent);
    }

    public void visit(IMetricsSelection node) {
        INode[] metrics = node.getMetrics();
        JSONArray jMetrics = new JSONArray(metrics.length);
        for (INode metric : metrics) {
            jMetrics.add((Object)metric.toString());
        }
        JSONObject jContent = new JSONObject();
        jContent.put((Object)"Metrics", (Object)jMetrics);
        this.push(jContent);
    }

    public void visit(ICategoryMetricNode node) {
        JSONObject jContent = new JSONObject();
        jContent.put((Object)"Category", (Object)node.getNode().toString());
        this.push(jContent);
    }

    public void visit(ISetFunction node) {
        IExpression[] parameters = node.getParameters();
        JSONArray jParameters = new JSONArray(parameters.length);
        for (IExpression parameter : parameters) {
            parameter.accept((IQueryNodeVisitor)this);
            jParameters.add(this.pop());
        }
        JSONObject jContent = new JSONObject();
        jContent.put((Object)"type", (Object)node.getFunctionType().toString());
        jContent.put((Object)"parameters", (Object)jParameters);
        JSONObject jOperator = new JSONObject();
        jOperator.put((Object)"SetFunction", (Object)jContent);
        this.push(jOperator);
    }

    public void visit(IOperator node) {
        IExpression[] parameters = node.getParameters();
        JSONArray jParameters = new JSONArray(parameters.length);
        for (IExpression parameter : parameters) {
            parameter.accept((IQueryNodeVisitor)this);
            jParameters.add(this.pop());
        }
        JSONObject jContent = new JSONObject();
        jContent.put((Object)"type", (Object)node.getOperatorType().toString());
        jContent.put((Object)"parameters", (Object)jParameters);
        JSONObject jOperator = new JSONObject();
        jOperator.put((Object)"Operator", (Object)jContent);
        this.push(jOperator);
    }

    public void visit(IScalarFunction node) {
        IXQEQueryNode[] parameters = ((QuerySpecAbstractNode)node).getChildren();
        JSONArray jParameters = new JSONArray(parameters.length);
        for (IXQEQueryNode parameter : parameters) {
            ((IQueryNode)parameter).accept((IQueryNodeVisitor)this);
            jParameters.add(this.pop());
        }
        JSONObject jContent = new JSONObject();
        jContent.put((Object)"type", (Object)node.getFunctionType().toString());
        jContent.put((Object)"parameters", (Object)jParameters);
        JSONObject jOperator = new JSONObject();
        jOperator.put((Object)"Function", (Object)jContent);
        this.push(jOperator);
    }

    public void visit(IValueListNode node) {
        JSONArray jArray = new JSONArray();
        for (IXQEQueryNode literalNode : ((QuerySpecAbstractNode)node).getChildren()) {
            ((IQueryNode)literalNode).accept((IQueryNodeVisitor)this);
            jArray.add(this.pop());
        }
        JSONObject jValueList = new JSONObject();
        jValueList.put((Object)"ValueList", (Object)jArray);
        this.push(jValueList);
    }

    public void visit(ILiteralNode node) {
        JSONObject jLiteral = new JSONObject();
        jLiteral.put((Object)"Literal", (Object)node.getValue().toString());
        this.push(jLiteral);
    }

    public void visit(IFilter node) {
        node.getPredicate().accept((IQueryNodeVisitor)this);
        JSONObject jFilter = new JSONObject();
        jFilter.put((Object)"Filter", this.pop());
        this.push(jFilter);
    }

    public void visit(ISortKey node) {
        JSONObject jObject = new JSONObject();
        if (((QuerySpecAbstractNode)node).getChildren().length > 0) {
            ((IQueryNode)((QuerySpecAbstractNode)node).getChild(0)).accept((IQueryNodeVisitor)this);
            jObject.put((Object)"key", this.pop());
        }
        jObject.put((Object)"isAscending", (Object)node.isAscending());
        jObject.put((Object)"isHierarchical", (Object)node.isHierarchical());
        this.push(jObject);
    }

    public void visit(IQuerySpecAttributeValue node) {
        JSONObject jObject = new JSONObject();
        jObject.put((Object)"category", (Object)node.getAttribute().toString());
        IValue value = node.getValue();
        if (value == null || value.isNull()) {
            jObject.put((Object)"value", (Object)"");
        } else {
            jObject.put((Object)"value", (Object)node.getValue().stringValue());
        }
        JSONObject jContent = new JSONObject();
        jContent.put((Object)"ExpressionAttributeValue", (Object)jObject);
        this.push(jContent);
    }

    public void visit(IAllSelection node) {
        JSONObject jContent = new JSONObject();
        jContent.put((Object)"AllHierarchyValues", (Object)"");
        this.push(jContent);
    }

    public void visit(IDefaultValueSelection node) {
        JSONObject jContent = new JSONObject();
        jContent.put((Object)"DefaultHierarchyValue", (Object)"");
        this.push(jContent);
    }

    public void visit(IValuesSelection node) {
        JSONArray jArray = new JSONArray();
        for (IXQEQueryNode attributeValueNode : ((QuerySpecAbstractNode)node).getChildren()) {
            ((IQueryNode)attributeValueNode).accept((IQueryNodeVisitor)this);
            jArray.add(this.pop());
        }
        JSONObject jValueList = new JSONObject();
        jValueList.put((Object)"AttributeValues", (Object)jArray);
        this.push(jValueList);
    }

    public void visit(IAttributeValue node) {
        JSONObject jObject = new JSONObject();
        jObject.put((Object)"category", (Object)node.getAttribute().toString());
        jObject.put((Object)"value", (Object)node.getValue().stringValue());
        JSONObject jContent = new JSONObject();
        jContent.put((Object)"AttributeValue", (Object)jObject);
        this.push(jContent);
    }

    public void visit(ISortByData node) {
        JSONObject jObject = new JSONObject();
        JSONArray context = new JSONArray();
        IMember[] contextMembers = node.getContext();
        if (contextMembers == null) {
            for (IMember iMember : ((QuerySpecAbstractNode)node).getChildren()) {
                ((IQueryNode)iMember).accept((IQueryNodeVisitor)this);
                context.add(this.pop());
            }
        } else {
            for (IMember iMember : contextMembers) {
                context.add((Object)iMember.toString());
            }
        }
        jObject.put((Object)"context", (Object)context);
        JSONObject jValueList = new JSONObject();
        jValueList.put((Object)"SortByData", (Object)jObject);
        this.push(jValueList);
    }

    public void visit(INodesSelection node) {
        INode[] selectedNodes = node.getNodes();
        JSONObject jNodes = new JSONObject();
        JSONArray jNodeIds = new JSONArray(selectedNodes.length);
        jNodes.put((Object)"nodes", (Object)jNodeIds);
        for (INode aNode : selectedNodes) {
            jNodeIds.add((Object)aNode.toString());
        }
        this.push(jNodes);
    }

    public void visit(ISortByAttribute node) {
        JSONObject jObject = new JSONObject();
        INode attribute = node.getAttribute();
        if (attribute != null) {
            jObject.put((Object)"attribute", (Object)node.getAttribute().toString());
        } else if (node.getIAttribute() != null) {
            jObject.put((Object)"attribute", (Object)node.getIAttribute().toString());
        } else {
            jObject.put((Object)"attribute", (Object)"MEMBER_CAPTION");
        }
        ISortKey sortKey = node.getSortKey();
        if (sortKey != null) {
            sortKey.accept((IQueryNodeVisitor)this);
            jObject.put((Object)"sortKey", this.pop());
        }
        JSONObject jContent = new JSONObject();
        jContent.put((Object)"SortByAttribute", (Object)jObject);
        this.push(jContent);
    }

    public void visit(IFilterOnRange node) {
        IMember[] contextMembers;
        JSONObject jObject = new JSONObject();
        JSONArray context = new JSONArray();
        for (IMember aMember : contextMembers = node.getContext()) {
            context.add((Object)aMember.toString());
        }
        JSONObject jValueList = new JSONObject();
        jValueList.put((Object)"FilterOnRange", (Object)jObject);
        jObject.put((Object)"from", (Object)node.getFrom());
        jObject.put((Object)"to", (Object)node.getTo());
        jObject.put((Object)"context", (Object)context);
        this.push(jValueList);
    }

    public void visit(IMembersSelection node) {
        IMember[] selectedMembers = node.getMembers();
        JSONObject jMembers = new JSONObject();
        jMembers.put((Object)"operationType", (Object)node.getOperationType().toString());
        JSONArray jMemberIds = new JSONArray(selectedMembers.length);
        jMembers.put((Object)"members", (Object)jMemberIds);
        for (IMember member : selectedMembers) {
            jMemberIds.add((Object)member.getUniqueName());
        }
        this.push(jMembers);
    }

    public void visit(ICalculation node) {
        JSONObject jObject = new JSONObject();
        jObject.put((Object)"name", (Object)node.getUniqueName());
        jObject.put((Object)"hierarchy", (Object)node.getHierarchy().getUniqueName());
        JSONArray jCalculationSpec = new JSONArray();
        jObject.put((Object)node.getCalculationType().toString(), (Object)jCalculationSpec);
        JSONObject jContent = new JSONObject();
        jContent.put((Object)"calculations", (Object)jObject);
        this.push(jContent);
    }

    public void visit(ISortByHierarchyOrder node) {
        JSONObject jObject = new JSONObject();
        jObject.put((Object)"orderType", (Object)node.getHierarchySortOrder().toString());
        JSONObject jContent = new JSONObject();
        jContent.put((Object)"SortByHierarchyOrder", (Object)jObject);
        this.push(jContent);
    }

    public void visit(IExpandToDepth node) {
        JSONObject jObject = new JSONObject();
        jObject.put((Object)"depth", (Object)Integer.valueOf(node.getDepth()).toString());
        JSONObject jContent = new JSONObject();
        jContent.put((Object)"ExpandToDepth", (Object)jObject);
        this.push(jContent);
    }

    public void visit(IExpandMembers node) {
        IMember[] selectedMembers = node.getMembers();
        JSONObject jMembers = new JSONObject();
        JSONArray jMemberIds = new JSONArray(selectedMembers.length);
        jMembers.put((Object)"members", (Object)jMemberIds);
        for (IMember member : selectedMembers) {
            jMemberIds.add((Object)member.getUniqueName());
        }
        jMembers.put((Object)"expand", (Object)String.valueOf(node.isExpandOperation()));
        this.push(jMembers);
    }

    public void visit(IMembersByDepth node) {
        JSONObject jObject = new JSONObject();
        jObject.put((Object)"operationType", (Object)node.getOperationType().toString());
        jObject.put((Object)"depth", (Object)Integer.valueOf(node.getDepth()).toString());
        JSONObject jContent = new JSONObject();
        jContent.put((Object)"MembersByDepth", (Object)jObject);
        this.push(jContent);
    }

    public void visit(IFilterByData node) {
        IMember[] contextMembers;
        JSONObject jObject = new JSONObject();
        jObject.put((Object)"direction", (Object)node.getDirection().toString());
        jObject.put((Object)"countType", (Object)node.getCountType().toString());
        jObject.put((Object)"countType", (Object)node.getCount());
        if (node.getTiesType() != null) {
            jObject.put((Object)"tiesType", (Object)node.getTiesType().toString());
        }
        JSONArray context = new JSONArray();
        for (IMember aMember : contextMembers = node.getContext()) {
            context.add((Object)aMember.toString());
        }
        jObject.put((Object)"context", (Object)context);
        JSONObject jContent = new JSONObject();
        jContent.put((Object)"FilterByData", (Object)jObject);
        this.push(jContent);
    }
}

