/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.athena.qls.bi.cm;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.DataSourceConnection;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.ibm.cognos.athena.qls.bi.cm.CMObject;
import com.ibm.cognos.athena.qls.bi.cm.CMSignon;
import com.ibm.cognos.aurora.core.util.collection.MapCast;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.Flat3Map;
import org.dom4j.Element;

public class CMConnection
extends CMObject {
    public static final String CONNECTION_INFO = "dataSourceConnection";
    private static final String CONNECTION_STRING_PROPERTY = "connectionString";
    private final String namespace;
    private final Map<String, CMSignon> signons = MapCast.uncheckedCast((Map)new Flat3Map());
    private volatile String userGroups = null;

    public CMConnection(Element itemElement) {
        super(itemElement);
        List<CMObject> arrayProperties = this.getArrayProperty(PropEnum.credentialNamespaces.getValue());
        if (arrayProperties != null && arrayProperties.size() > 0) {
            CMObject obj = arrayProperties.get(0);
            this.namespace = obj.getStringProperty(PropEnum.searchPath.getValue());
        } else {
            this.namespace = null;
        }
    }

    public CMConnection(DataSourceConnection dsConnection) {
        super((BaseClass)dsConnection);
        this.extractConnectionProperties(dsConnection);
        Object obj = this.getProperty(PropEnum.credentialNamespaces.getValue());
        if (obj != null) {
            BaseClass[] props = (BaseClass[])obj;
            String searchPath = null;
            for (BaseClass prop : props) {
                if (prop == null || prop.getSearchPath().getValue() == null) continue;
                searchPath = prop.getSearchPath().getValue();
                break;
            }
            this.namespace = searchPath;
        } else {
            this.namespace = null;
        }
    }

    void addSignon(CMSignon theSignon) {
        if (theSignon != null) {
            this.signons.put(theSignon.getDefaultName(), theSignon);
        }
    }

    public String getConnectionString() {
        return this.getStringProperty(CONNECTION_STRING_PROPERTY);
    }

    public boolean isDisabled() {
        return this.getBooleanProperty("disabled", false);
    }

    public Collection<CMSignon> getSignons() {
        return this.signons.values();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getUserGroups() {
        return this.userGroups;
    }

    public void setUserGroups(String sUserGroups) {
        this.userGroups = sUserGroups;
    }

    @Override
    public String toString() {
        return super.toString() + ":Signons=" + this.signons;
    }

    private void extractConnectionProperties(DataSourceConnection dsConnection) {
        if (dsConnection.getOpenConnectionCommands().getValue() != null) {
            this.addProperty(PropEnum.openConnectionCommands.toString(), dsConnection.getOpenConnectionCommands().getValue().toString());
        }
        if (dsConnection.getOpenSessionCommands().getValue() != null) {
            this.addProperty(PropEnum.openSessionCommands.toString(), dsConnection.getOpenSessionCommands().getValue().toString());
        }
        if (dsConnection.getCloseSessionCommands().getValue() != null) {
            this.addProperty(PropEnum.closeSessionCommands.toString(), dsConnection.getCloseSessionCommands().getValue().toString());
        }
        if (dsConnection.getCloseConnectionCommands().getValue() != null) {
            this.addProperty(PropEnum.closeConnectionCommands.toString(), dsConnection.getCloseConnectionCommands().getValue().toString());
        }
        if (dsConnection.getIsolationLevel().getValue() != null) {
            this.addProperty(PropEnum.isolationLevel.toString(), dsConnection.getIsolationLevel().getValue());
        }
        if (dsConnection.getConnectionString().getValue() != null) {
            this.addProperty(PropEnum.connectionString.toString(), dsConnection.getConnectionString().getValue());
        }
        if (dsConnection.getCredentialNamespaces().getValue() != null) {
            this.addProperty(PropEnum.credentialNamespaces.toString(), dsConnection.getCredentialNamespaces().getValue());
        }
    }

    public CMSignon getSignon(String cmSignonName) {
        return this.signons.get(cmSignonName);
    }
}

