/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.athena.qls.bi.cm;

import com.cognos.developer.schemas.bibus._3.AncestorInfo;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.Flat3Map;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class CMObject {
    protected static final String DEFAULT_NAME_PROPERTY = "defaultName";
    protected static final String SEARCH_PATH_PROPERTY = "searchPath";
    protected static final String DATA_SOURCE_CONNECTION_PROPERTY = "dataSourceConnectionName";
    public static final String DISABLED_STRING_PROPERTY = "disabled";
    private static final Namespace XSI = new Namespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
    private static final Namespace SOAPENC = new Namespace("SOAP-ENC", "http://schemas.xmlsoap.org/soap/encoding/");
    private static final QName ARRAY_TYPE = new QName("arrayType", SOAPENC);
    private static final QName TYPE = new QName("type", XSI);
    private static final String DOM_ELEMENT_VALUE = "value";
    private String type = null;
    private Map<String, Object> props = null;

    public CMObject(Element cmItemElement) {
        this.type = cmItemElement.attributeValue(TYPE);
        this.parseItem(cmItemElement);
    }

    public CMObject(BaseClass baseClass) {
        this.setType(baseClass.getObjectClass().getValue().toString());
        this.props = new HashMap<String, Object>();
        if (baseClass.getDisabled() != null) {
            this.props.put(PropEnum.disabled.toString(), String.valueOf(baseClass.getDisabled().isValue()));
        }
        if (baseClass.getDefaultName().getValue() != null) {
            this.props.put(PropEnum.defaultName.toString(), baseClass.getDefaultName().getValue());
        }
        if (baseClass.getSearchPath().getValue() != null) {
            this.props.put(PropEnum.searchPath.toString(), baseClass.getSearchPath().getValue());
        }
    }

    public CMObject(AncestorInfo ancestor) {
        this.setType(ancestor.getObjectClass().toString());
        this.props = new HashMap<String, Object>();
        this.props.put(PropEnum.disabled.toString(), String.valueOf(false));
        this.props.put(PropEnum.defaultName.toString(), ancestor.getTitle());
        this.props.put(PropEnum.searchPath.toString(), ancestor.getSearchPath());
    }

    public String getType() {
        return this.type;
    }

    public void setType(String value) {
        StringBuilder sb = new StringBuilder();
        sb.append("cm:");
        sb.append(value);
        this.type = sb.toString();
    }

    protected void parseItem(Element itemElement) {
        this.props = new Flat3Map();
        Iterator itr = itemElement.elementIterator();
        while (itr.hasNext()) {
            Element e = (Element)itr.next();
            String name = e.getName();
            Element valueElement = e.element(DOM_ELEMENT_VALUE);
            if (valueElement == null) continue;
            String arrayType = valueElement.attributeValue(ARRAY_TYPE);
            if (arrayType != null) {
                LinkedList<CMObject> objects = new LinkedList<CMObject>();
                this.props.put(name, objects);
                Iterator itr1 = valueElement.elementIterator("item");
                while (itr1.hasNext()) {
                    CMObject obj = new CMObject((Element)itr1.next());
                    objects.add(obj);
                }
                continue;
            }
            String value = valueElement.getText();
            if (value == null) continue;
            this.props.put(name, value);
        }
    }

    public Object getProperty(String name) {
        if (this.props != null) {
            return this.props.get(name);
        }
        return null;
    }

    public void addProperty(String propName, Object propValue) {
        this.props.put(propName, propValue);
    }

    public List<CMObject> getArrayProperty(String name) {
        Object obj = this.getProperty(name);
        if (obj instanceof List) {
            return (List)this.props.get(name);
        }
        return null;
    }

    public String getStringProperty(String name) {
        Object obj = this.getProperty(name);
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    public boolean getBooleanProperty(String name, boolean defaultvalue) {
        Object obj = this.getProperty(name);
        if (obj != null) {
            return Boolean.valueOf(obj.toString());
        }
        return defaultvalue;
    }

    public String getDefaultName() {
        return this.getStringProperty(DEFAULT_NAME_PROPERTY);
    }

    public String getSearchPath() {
        return this.getStringProperty(SEARCH_PATH_PROPERTY);
    }

    public String getDataSourceConnectionName() {
        return this.getStringProperty(DATA_SOURCE_CONNECTION_PROPERTY);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.type);
        buffer.append(":Properties=");
        buffer.append(this.props);
        return buffer.toString();
    }
}

