/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.athena.qls.bi.cm;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.contentmanager.ContentManagerQueryCommand;
import com.cognos.pogo.http.ConnectionPool;
import com.cognos.pogo.http.ServerConnection;
import java.net.MalformedURLException;
import java.net.URL;

public class CMQuery
extends ContentManagerQueryCommand {
    private static final String NAME_ATTRIBUTE = "[@name=";
    private static String dispatcherUrl;
    private static ConnectionPool dispatcherConnectionPool;
    private static boolean initialized;
    public static final int MAX_DISPATCHER_CONNECTIONS = 20;

    public CMQuery(String objectName) {
        super(objectName);
    }

    public static synchronized void initialize() {
        if (initialized) {
            return;
        }
        ICCLConfiguration config = CCLConfigurationFactory.getInstance();
        try {
            config.init();
            String externalDispatcher = config.getValue("externalDispatcher", false);
            URL dispatcherURL = new URL(externalDispatcher);
            dispatcherConnectionPool = new ConnectionPool(dispatcherURL.getHost(), dispatcherURL.getPort(), "https".equals(dispatcherURL.getProtocol()), 20);
            dispatcherUrl = dispatcherURL.getPath();
            initialized = true;
        }
        catch (CCLConfigurationException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    protected ServerConnection fetchServerConnection() {
        ServerConnection aConnection = dispatcherConnectionPool.getConnection();
        aConnection.getHttpClient().getState().clearCookies();
        return aConnection;
    }

    protected String fetchRequestContext() {
        return dispatcherUrl;
    }

    public void execute() throws CommandExecutionException {
        if (!initialized) {
            CMQuery.initialize();
        }
        super.execute();
    }

    public static String getSearchPathPropName(String searchPath, String property) {
        int startingIndex;
        String quote;
        int quoteIndex;
        int nameIndex;
        int propertyIndex;
        String ret = null;
        if (searchPath != null && (propertyIndex = searchPath.indexOf(property)) >= 0 && (nameIndex = searchPath.indexOf(NAME_ATTRIBUTE, propertyIndex + property.length())) >= 0 && (quoteIndex = searchPath.indexOf(quote = searchPath.substring((startingIndex = nameIndex + NAME_ATTRIBUTE.length() + 1) - 1, startingIndex), startingIndex)) >= 0) {
            ret = searchPath.substring(startingIndex, quoteIndex);
        }
        return ret;
    }

    static {
        initialized = false;
    }

    public static enum Commands {
        CMD_OPEN_CONNECTION("openConnectionCommands"),
        CMD_OPEN_SESSION("openSessionCommands"),
        CMD_CLOSE_SESSION("closeSessionCommands"),
        CMD_CLOSE_CONNECTION("closeConnectionCommands");

        private final String cmdName;

        private Commands(String name) {
            this.cmdName = name;
        }

        public String getName() {
            return this.cmdName;
        }

        public static Commands fromString(String cmdName) {
            for (Commands cmd : Commands.values()) {
                if (!cmd.getName().equals(cmdName)) continue;
                return cmd;
            }
            return null;
        }
    }
}

