/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.athena.qls.bi.exception;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.ibm.cognos.athena.qls.bi.cm.BaseCMCommand;
import com.ibm.cognos.athena.qls.bi.exception.QLSBIRuntimeException;
import com.ibm.cognos.athena.qls.bi.exception.RecoverableException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis.AxisFault;
import org.apache.axis.message.SOAPHeaderElement;
import org.dom4j.Element;

public class RecoverableAxisFault
extends RecoverableException {
    private static final long serialVersionUID = -4608176266662433665L;
    private final AxisFault axisFault;
    private final String faultCode;
    private final String faultString;

    public RecoverableAxisFault(AxisFault theFault, String fCode, String fString) {
        this.axisFault = theFault;
        this.faultCode = fCode;
        this.faultString = fString;
    }

    @Override
    protected String getDetail() {
        BIBusEnvelope faultEnvelope = new BIBusEnvelope();
        faultEnvelope.createFaultElement(this.getFaultCode(), this.getFaultString());
        return faultEnvelope.getBodyFault().asXML();
    }

    @Override
    public String getFaultCode() {
        return this.faultCode;
    }

    @Override
    protected String getFaultString() {
        return this.faultString;
    }

    private Element getBIBusHeaderElement() {
        SOAPHeaderElement headerElement = (SOAPHeaderElement)this.axisFault.getHeaders().get(0);
        Element bibusHeader = null;
        try {
            bibusHeader = BaseCMCommand.convert(headerElement.getAsDocument());
        }
        catch (ParserConfigurationException e) {
            throw QLSBIRuntimeException.wrap(e);
        }
        catch (Exception e) {
            throw QLSBIRuntimeException.wrap(e);
        }
        return bibusHeader;
    }

    @Override
    public BIBusEnvelope getBIBusEnvelope() {
        BIBusEnvelope env = new BIBusEnvelope();
        env.setBIBusHeader(this.getBIBusHeaderElement());
        return env;
    }
}

