/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.athena.qls.bi.exception;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.ibm.cognos.athena.qls.bi.cm.CMConnection;
import com.ibm.cognos.athena.qls.bi.cm.CMDataSource;
import com.ibm.cognos.athena.qls.bi.cm.CMSignon;
import com.ibm.cognos.athena.qls.bi.exception.RecoverableException;
import com.ibm.cognos.aurora.api.exception.IMessageKey;
import com.ibm.cognos.aurora.api.exception.IRecoveryInfo;
import java.util.Locale;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.dom.DOMElement;

public abstract class RecoverableDatasourceException
extends RecoverableException
implements IRecoveryInfo {
    protected final CMDataSource dataSource;
    private final String m_strDataSourceType;
    private static final long serialVersionUID = -1683613611713928302L;

    public RecoverableDatasourceException(Locale locale, IMessageKey.Param1 messageKey, String par1, CMDataSource ds, String dsType) {
        super(locale, messageKey, par1);
        this.dataSource = ds;
        this.m_strDataSourceType = dsType;
    }

    public RecoverableDatasourceException(Locale locale, IMessageKey.Param2 messageKey, String par1, String par2, CMDataSource ds, String dsType) {
        super(locale, messageKey, par1, par2);
        this.dataSource = ds;
        this.m_strDataSourceType = dsType;
    }

    @Override
    protected String getFaultString() {
        return this.getMessage();
    }

    private Element getFaultDetail() {
        DOMElement exception = new DOMElement(BIBusEnvelope.BUS_EXCEPTION);
        this.addMessage((Element)exception, this.getFaultString());
        for (Throwable cause = this.getCause(); cause != null; cause = cause.getCause()) {
            String msg = cause.getLocalizedMessage();
            if (msg != null) {
                this.addMessage((Element)exception, msg);
            }
            if (cause == cause.getCause()) break;
        }
        return exception;
    }

    private void addMessage(Element exception, String msg) {
        DOMElement message = new DOMElement(BIBusEnvelope.BUS_MESSAGE);
        exception.add((Element)message);
        DOMElement messageString = new DOMElement(new QName("messageString"));
        messageString.addText(msg);
        message.add((Element)messageString);
    }

    protected abstract Element getDataSourceElement();

    protected Element getBaseDataSourceElement() {
        Element dataSourceElement = DocumentHelper.createElement((String)"dataSource");
        Element nameElement = dataSourceElement.addElement("name");
        nameElement.addAttribute("value", this.dataSource.getName());
        Element typeElement = dataSourceElement.addElement("type");
        typeElement.addAttribute("value", this.m_strDataSourceType);
        return dataSourceElement;
    }

    protected Element getBaseConnectionElement(CMConnection _dataSourceConnection) {
        Element connectionElement = DocumentHelper.createElement((String)"connection");
        Element nameElement = connectionElement.addElement("name");
        nameElement.addAttribute("value", _dataSourceConnection.getDefaultName());
        Element searchPathElement = connectionElement.addElement("searchPath");
        searchPathElement.addAttribute("value", _dataSourceConnection.getSearchPath());
        return connectionElement;
    }

    protected Element getBaseSignonElement(CMSignon signon) {
        Element signonElement = DocumentHelper.createElement((String)"signon");
        Element nameElement = signonElement.addElement("name");
        nameElement.addAttribute("value", signon.getDefaultName());
        Element searchPathElement = signonElement.addElement("searchPath");
        searchPathElement.addAttribute("value", signon.getSearchPath());
        return signonElement;
    }

    @Override
    public BIBusEnvelope getBIBusEnvelope() {
        if (this.dataSource != null) {
            return this.dataSource.getBIBusEnvelope();
        }
        return null;
    }

    @Override
    public String getDetail() {
        BIBusEnvelope faultEnvelope = this.getFaultEnvelope();
        return faultEnvelope.getBodyFault().asXML();
    }

    public BIBusEnvelope getFaultEnvelope() {
        BIBusEnvelope faultEnvelope = new BIBusEnvelope();
        Element faultElement = faultEnvelope.createFaultElement(this.getFaultCode(), this.getFaultString());
        Element dsElement = this.getDataSourceElement();
        if (dsElement != null) {
            faultElement.add(dsElement);
        }
        return faultEnvelope;
    }
}

