/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.athena.qls.bi.security;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.pogo.util.base64;
import com.ibm.cognos.athena.qls.bi.exception.QLSBIRuntimeException;
import com.ibm.cognos.athena.qls.bi.security.Credentials;
import com.ibm.cognos.aurora.api.exception.CoreMessageKeys;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnection;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public final class CryptoProvider {
    public static final String UTF_8_CHARSET = "UTF-8";
    public static final String SERVICE_ID = "QLSBI";
    private static final byte[] INITDOC = "<initializeDocument><serviceID>QLSBI</serviceID></initializeDocument>".getBytes();
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private volatile boolean mInitialized = false;
    private CAMFactory mCAMFactory = null;
    private static final String MISS_SPELLED_PSWD_TAG = "</passwrod>";
    private static final String PASSWORD_TAG = "<password>";

    public void initialize() throws Exception {
        if (this.mInitialized) {
            throw new IllegalStateException("Already initialized");
        }
        this.mCAMFactory = new CAMFactory();
        this.mCAMFactory.initialize(INITDOC);
        this.mInitialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() throws Exception {
        if (!this.mInitialized) {
            throw new IllegalStateException("Not initialized");
        }
        try {
            this.mCAMFactory.terminate();
        }
        finally {
            this.mCAMFactory = null;
            this.mInitialized = false;
        }
    }

    public byte[] encrypt(byte[] data) throws CAMCryptoException {
        if (!this.mInitialized) {
            throw new IllegalStateException("Not initialized");
        }
        return this.mCAMFactory.createEncryptingSession().encryptData(data);
    }

    public byte[] decrypt(byte[] data) throws CAMCryptoException {
        if (!this.mInitialized) {
            throw new IllegalStateException("Not initialized");
        }
        return this.mCAMFactory.createEncryptingSession().decryptData(data);
    }

    public String decrypt(String encrypted, int baseEncoding, String charset) {
        String decryptedString = null;
        try {
            byte[] data = base64.decode((int)0, (String)encrypted);
            data = this.decrypt(data);
            decryptedString = new String(data, charset);
        }
        catch (CAMCryptoException e) {
            throw new QLSBIRuntimeException(CoreMessageKeys.GEN_FoundInternalError, e);
        }
        catch (UnsupportedEncodingException e) {
            throw new QLSBIRuntimeException(CoreMessageKeys.GEN_FoundInternalError, e);
        }
        return decryptedString;
    }

    public String encrypt(String toencrypt, int baseEncoding, String charset) {
        try {
            byte[] encrypted = this.encrypt(toencrypt.getBytes(charset));
            return base64.encode((int)0, (byte[])encrypted);
        }
        catch (CAMCryptoException e) {
            throw new QLSBIRuntimeException(CoreMessageKeys.GEN_FoundInternalError, e);
        }
        catch (UnsupportedEncodingException e) {
            throw new QLSBIRuntimeException(CoreMessageKeys.GEN_FoundInternalError, e);
        }
    }

    public OutputStream createEncryptingOutputStream(OutputStream out) throws CAMCryptoException {
        if (!this.mInitialized) {
            throw new IllegalStateException("Not initialized");
        }
        return this.mCAMFactory.createEncryptingOutputStream(out);
    }

    public InputStream createDecryptingInputStream(InputStream in) throws CAMCryptoException {
        if (!this.mInitialized) {
            throw new IllegalStateException("Not initialized");
        }
        return this.mCAMFactory.createDecryptingInputStream(in);
    }

    public HttpConnection createHttpConnection(String host, int port, boolean isSecure) throws Exception {
        if (!this.mInitialized) {
            throw new IllegalStateException("Not initialized");
        }
        return this.mCAMFactory.createHttpConnection(host, port, isSecure);
    }

    public HttpClient createHttpClient(String host, int port, boolean isSecure) throws Exception {
        if (!this.mInitialized) {
            throw new IllegalStateException("Not initialized");
        }
        return this.mCAMFactory.createHttpClient(host, port, isSecure);
    }

    public Credentials retrieveSignonsCredentials(String encryptedXML) {
        Element namespaceElement;
        Element passwordElement;
        Document doc;
        SAXReader reader;
        String username = null;
        String password = null;
        String namespace = null;
        String base64EncodedString = null;
        try {
            reader = new SAXReader();
            doc = reader.read((Reader)new StringReader(encryptedXML));
            Element encryptedValueElement = doc.getRootElement().element("encryptedValue");
            base64EncodedString = encryptedValueElement.getText();
        }
        catch (Exception e) {
            throw QLSBIRuntimeException.wrap(e);
        }
        if (base64EncodedString == null) {
            return null;
        }
        String decryptedCredentials = null;
        try {
            byte[] data = base64.decode((int)0, (String)base64EncodedString);
            data = this.decrypt(data);
            decryptedCredentials = new String(data, UTF_8_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw QLSBIRuntimeException.wrap(e);
        }
        catch (CAMCryptoException e) {
            throw QLSBIRuntimeException.wrap(e);
        }
        String validdecryptedCredentials = decryptedCredentials;
        if (decryptedCredentials.contains(MISS_SPELLED_PSWD_TAG)) {
            validdecryptedCredentials = decryptedCredentials.replace(MISS_SPELLED_PSWD_TAG, PASSWORD_TAG);
        }
        StringReader stringReader = new StringReader(validdecryptedCredentials);
        try {
            doc = reader.read((Reader)stringReader);
        }
        catch (DocumentException e) {
            throw QLSBIRuntimeException.wrap(e);
        }
        Element credentialsElement = doc.getRootElement();
        Element usernameElement = credentialsElement.element(USERNAME);
        if (usernameElement != null) {
            username = usernameElement.getText();
        }
        if ((passwordElement = credentialsElement.element(PASSWORD)) != null) {
            password = passwordElement.getText();
        }
        if ((namespaceElement = credentialsElement.element("namespace")) != null) {
            namespace = namespaceElement.getText();
        }
        return new Credentials(username, password, namespace);
    }

    public String encryptCredentials(Credentials credentials) {
        byte[] data;
        Document document = DocumentHelper.createDocument();
        Element rootCredential = document.addElement("credential");
        Element encryptedValue = rootCredential.addElement("encryptedValue");
        Element credential = encryptedValue.addElement("credential");
        Element usernameElement = credential.addElement(USERNAME);
        usernameElement.setText(credentials.getUsername());
        Element passwordElement = credential.addElement(PASSWORD);
        passwordElement.setText(credentials.getPassword());
        if (credentials.getNameSpace() != null) {
            Element namespaceElement = credential.addElement("namespace");
            namespaceElement.setText(credentials.getNameSpace());
        }
        try {
            data = this.encrypt(credential.asXML().getBytes());
        }
        catch (CAMCryptoException e) {
            throw QLSBIRuntimeException.wrap(e);
        }
        String encryptedText = base64.encode((int)0, (byte[])data);
        credential.detach();
        encryptedValue.setText(encryptedText);
        return rootCredential.asXML();
    }

    public String decryptCredentials(Credentials credentials) {
        byte[] data;
        Document document = DocumentHelper.createDocument();
        Element rootCredential = document.addElement("credential");
        Element encryptedValue = rootCredential.addElement("encryptedValue");
        Element credential = encryptedValue.addElement("credential");
        Element usernameElement = credential.addElement(USERNAME);
        usernameElement.setText(credentials.getUsername());
        Element passwordElement = credential.addElement(PASSWORD);
        passwordElement.setText(credentials.getPassword());
        if (credentials.getNameSpace() != null) {
            Element namespaceElement = credential.addElement("namespace");
            namespaceElement.setText(credentials.getNameSpace());
        }
        try {
            data = this.encrypt(credential.asXML().getBytes());
        }
        catch (CAMCryptoException e) {
            throw QLSBIRuntimeException.wrap(e);
        }
        String encryptedText = base64.encode((int)0, (byte[])data);
        credential.detach();
        encryptedValue.setText(encryptedText);
        return rootCredential.asXML();
    }
}

