/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.qls.format.factory;

import com.ibm.cognos.aurora.api.format.IValueFormat;
import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LoggerManager;
import com.ibm.cognos.qls.format.factory.TM1ValueFormatFactory;
import com.ibm.cognos.qls.format.impl.tm1.TM1CurrencyValueFormat;
import com.ibm.cognos.qls.format.impl.tm1.TM1NumberValueFormat;
import com.ibm.cognos.qls.format.impl.tm1.TM1PercentValueFormat;
import com.ibm.cognos.qls.format.impl.tm1.pattern.TM1BuildInNumericPatternInfo;
import com.ibm.cognos.qls.format.impl.tm1.pattern.TM1CustomNumericPatternInfo;
import com.ibm.cognos.qls.format.impl.tm1.pattern.TM1NumericPatternInfo;
import java.util.Locale;

public class TM1NumericFormatFactory
extends TM1ValueFormatFactory {
    private static final ILogger logger = LoggerManager.getLogger((String)"ATHENA.core.qls_formatting");

    private TM1NumericFormatFactory() {
    }

    public static IValueFormat createNumericFormatByValue(String inFormatString, IDataType dataType, Locale locale) {
        TM1NumericPatternInfo patternInfo = TM1NumericFormatFactory.processFormatPattern(inFormatString, locale);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Parsed a TM1 format string: (%s); locale: (%s); isCustom: (%s)", inFormatString, locale.toString(), patternInfo.isCustom()), TM1NumericFormatFactory.class.getName() + "::createNumericFormatByValue()");
        }
        if (patternInfo.isCurrencyFormat()) {
            return TM1CurrencyValueFormat.createInstance(inFormatString, dataType, locale, patternInfo);
        }
        if (patternInfo.isPercentFormat()) {
            return new TM1PercentValueFormat(inFormatString, dataType, locale, patternInfo);
        }
        return new TM1NumberValueFormat(inFormatString, dataType, locale, patternInfo);
    }

    private static TM1NumericPatternInfo processFormatPattern(String inFormatString, Locale locale) {
        TM1NumericPatternInfo ptnInfo;
        String pattern = inFormatString;
        if (pattern.contains("\f")) {
            if (pattern.startsWith("b:")) {
                pattern = pattern.replace("b:", "");
            }
            if (pattern.startsWith("d:")) {
                pattern = pattern.replace("d:", "");
            }
            if (TM1NumericFormatFactory.isICUCustom(pattern)) {
                pattern = pattern.substring(0, pattern.indexOf("\f"));
                ptnInfo = new TM1CustomNumericPatternInfo(pattern, locale);
            } else {
                ptnInfo = new TM1BuildInNumericPatternInfo(pattern);
            }
        } else {
            if (pattern.startsWith("c:")) {
                pattern = pattern.replace("c:", "");
            }
            ptnInfo = new TM1CustomNumericPatternInfo(pattern, locale);
        }
        return ptnInfo;
    }

    private static boolean isICUCustom(String pattern) {
        return pattern.endsWith("\fIC");
    }
}

