/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.qls.format.impl;

import com.ibm.cognos.aurora.api.format.IValueFormat;
import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LoggerManager;
import com.ibm.cognos.qls.format.exception.DataTypeMisMatchException;
import com.ibm.cognos.qls.format.exception.InvalidFormatPatternException;
import com.ibm.cognos.qls.format.exception.QLSFormattingMessageKeys;
import java.util.Locale;

public abstract class AbstractValueFormat
implements IValueFormat {
    protected static final ILogger logger = LoggerManager.getLogger((String)"ATHENA.core.qls_formatting");
    protected final String dsFormatString;
    protected final IDataType dataType;
    protected final Locale locale;
    public static final String NULL = "null";
    public static final String EMPTYSTRING = "";
    public static final String ESCAPE_STRING = "\\";
    public static final String QUOTE_STRING = "\"";
    public static final String SINGLEQUOTE = "'";
    public static final String ZERO = "0";

    protected AbstractValueFormat(String inFormatString, IDataType inDataType, Locale loc) {
        if (inFormatString == null || inDataType == null || loc == null) {
            throw new InvalidFormatPatternException(QLSFormattingMessageKeys.GEN_InternalError, "Parameters to AbstractValueFormat can not be null");
        }
        this.dsFormatString = inFormatString;
        this.dataType = inDataType;
        this.locale = loc;
    }

    public String format(IValue inValue) {
        if (inValue == null || inValue.isNull()) {
            if (this.getWhenNull() == null) {
                return EMPTYSTRING;
            }
            return this.getWhenNull();
        }
        if (!this.isTypeCorrect(inValue)) {
            throw new DataTypeMisMatchException(QLSFormattingMessageKeys.GEN_TypeMismatch, this.getDataType().toString(), inValue.getType().toString());
        }
        return this.formatImpl(inValue);
    }

    protected boolean compareObjs(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 == null && obj2 != null || obj1 != null && obj2 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }

    public Locale getLocale() {
        return this.locale;
    }

    protected abstract IDataType getDataType();

    protected abstract boolean compareDataType(IDataType var1);

    protected abstract boolean isTypeCorrect(IValue var1);

    protected abstract String formatImpl(IValue var1);
}

