/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.qls.format.impl.tm1;

import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.qls.format.impl.tm1.TM1CurrencyValueFormat;
import com.ibm.cognos.qls.format.impl.tm1.TM1NumericBuildInFormatHelper;
import com.ibm.cognos.qls.format.impl.tm1.pattern.TM1BuildInNumericPatternInfo;
import com.ibm.cognos.qls.format.impl.tm1.pattern.TM1NumericPatternInfo;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import java.util.Locale;

public class TM1CurrencyValueBuildInFormat
extends TM1CurrencyValueFormat {
    private static final char NON_BREAK_SPACE = '\u00a0';
    private static final char WHITE_SPACE = '\u0000';

    protected TM1CurrencyValueBuildInFormat(String inFormatString, IDataType inDataType, Locale inLocale, TM1NumericPatternInfo patternInfo) {
        super(inFormatString, inDataType, inLocale, patternInfo);
        TM1BuildInNumericPatternInfo bldInPtnInfo = (TM1BuildInNumericPatternInfo)patternInfo;
        this.processCurrency(this.format, bldInPtnInfo);
        this.useTrailingSymbol = "D";
        TM1NumericBuildInFormatHelper.processCommonBuildInSections(this.format, bldInPtnInfo);
    }

    private void processCurrency(DecimalFormat format, TM1BuildInNumericPatternInfo bldInPtnInfo) {
        if (bldInPtnInfo.getCurrencySymbolDisplay().equalsIgnoreCase("Y")) {
            this.displayCurrencyCode(format, bldInPtnInfo);
        } else if (bldInPtnInfo.getCurrencySymbolDisplay().equalsIgnoreCase("D")) {
            this.displayCurrencySymbol(format, bldInPtnInfo);
        } else {
            this.displayNumberOnly(format);
        }
    }

    private void displayCurrencySymbol(DecimalFormat format, TM1BuildInNumericPatternInfo bldInPtnInfo) {
        DecimalFormatSymbols symbols = format.getDecimalFormatSymbols();
        String curSymbol = bldInPtnInfo.getCurrencySymbol();
        if (TM1CurrencyValueFormat.getAllI18nCurrencyCodes().contains(curSymbol)) {
            String symbol = TM1CurrencyValueFormat.getCurrencyCodeSymbolMap().get(curSymbol);
            symbols.setCurrencySymbol(symbol);
            this.currencySymbol = symbol;
        } else {
            symbols.setCurrencySymbol(curSymbol);
            this.currencySymbol = curSymbol;
        }
        format.setDecimalFormatSymbols(symbols);
    }

    private void displayNumberOnly(DecimalFormat format) {
        DecimalFormatSymbols symbols = format.getDecimalFormatSymbols();
        symbols.setCurrencySymbol("");
        format.setDecimalFormatSymbols(symbols);
        format.setPositivePrefix(format.getPositivePrefix().replace('\u00a0', '\u0000').trim());
        format.setPositiveSuffix(format.getPositiveSuffix().replace('\u00a0', '\u0000').trim());
        format.setNegativePrefix(format.getNegativePrefix().replace('\u00a0', '\u0000').trim());
        format.setNegativeSuffix(format.getNegativeSuffix().replace('\u00a0', '\u0000').trim());
        this.currencySymbol = "";
    }

    private void displayCurrencyCode(DecimalFormat format, TM1BuildInNumericPatternInfo bldInPtnInfo) {
        DecimalFormatSymbols symbols = format.getDecimalFormatSymbols();
        String inputCurrencyCode = bldInPtnInfo.getCurrencySymbol();
        if (!TM1CurrencyValueFormat.getAllI18nCurrencyCodes().contains(inputCurrencyCode) && logger.isWarnEnabled()) {
            logger.warn(String.format("Unidentified Currency Code (%s) in build-in Currency Format (%s).", inputCurrencyCode, this.getDsFormatString()), this.getClass().getName() + "::displayCurrencyCode()");
        }
        symbols.setCurrencySymbol(inputCurrencyCode);
        this.currencySymbol = inputCurrencyCode;
        format.setDecimalFormatSymbols(symbols);
    }

    public boolean isShowNumberOnlyInCurrencyDisplay() {
        return ((TM1BuildInNumericPatternInfo)this.getPatternInfo()).getCurrencySymbolDisplay().equalsIgnoreCase("N");
    }
}

