/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.qls.format.impl.tm1;

import com.ibm.cognos.aurora.api.format.INumberValueFormat;
import com.ibm.cognos.aurora.api.format.IValueFormatCategory;
import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.qls.format.impl.tm1.TM1NumericBuildInFormatHelper;
import com.ibm.cognos.qls.format.impl.tm1.TM1NumericValueFormat;
import com.ibm.cognos.qls.format.impl.tm1.pattern.TM1BuildInNumericPatternInfo;
import com.ibm.cognos.qls.format.impl.tm1.pattern.TM1NumericPatternInfo;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.NumberFormat;
import java.util.Locale;

public class TM1NumberValueFormat
extends TM1NumericValueFormat
implements INumberValueFormat {
    public TM1NumberValueFormat(String inFormatString, IDataType inDataType, Locale inLocale, TM1NumericPatternInfo patternInfo) {
        super(inFormatString, inDataType, inLocale, patternInfo);
        this.format = patternInfo.isScientificFormat() ? (DecimalFormat)NumberFormat.getScientificInstance((Locale)inLocale) : (DecimalFormat)NumberFormat.getInstance((Locale)inLocale);
        DecimalFormatSymbols symbols = this.format.getDecimalFormatSymbols();
        symbols.setZeroDigit('0');
        if (patternInfo.isCustom()) {
            this.format.applyPattern(patternInfo.getFormatPattern());
        } else {
            this.format.setExponentSignAlwaysShown(true);
            TM1NumericBuildInFormatHelper.processCommonBuildInSections(this.format, (TM1BuildInNumericPatternInfo)patternInfo);
        }
    }

    public boolean isUseScientific() {
        return this.format.isScientificNotation();
    }

    public String getExponentSymbol() {
        return this.format.getDecimalFormatSymbols().getExponentSeparator();
    }

    public IValueFormatCategory getValueFormatCategory() {
        return IValueFormatCategory.INumberValueFormat;
    }

    public boolean isExponentSignAlwaysShown() {
        return this.format.isExponentSignAlwaysShown();
    }

    public byte getMinimumExponentDigits() {
        return this.format.getMinimumExponentDigits();
    }
}

