/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.qls.format.impl.tm1.pattern;

import com.ibm.cognos.qls.format.exception.InvalidFormatPatternException;
import com.ibm.cognos.qls.format.exception.QLSFormattingMessageKeys;
import com.ibm.cognos.qls.format.impl.tm1.TM1CurrencyValueFormat;
import com.ibm.cognos.qls.format.impl.tm1.pattern.TM1NumericPatternInfo;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TM1CustomNumericPatternInfo
extends TM1NumericPatternInfo {
    private String negativeInnerPattern = "";
    private String positiveInnerPattern = "";
    private static final String DECIMAL_SEPARATOR = ".";
    private static final Double TEST_DOUBLE = new Double(-12345.67);

    public TM1CustomNumericPatternInfo(String ptn, Locale locale) {
        super(ptn);
        this.parseSections();
        this.parsePrefixSuffixInnerPattern();
        this.covertCustomExponent2ICU();
        this.initialValidation(locale);
        this.parseCurrencySymbol();
        this.parsePercentSymbol();
        this.setIfShowNegativeInBracket();
        this.setUseTrailingSign();
        this.checkIfUniqueFormat();
        this.setDecimalSize();
        this.setFormatPattern();
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Processing a TM1 custom format string (%s) with Locale %s", ptn, locale.toString()), TM1CustomNumericPatternInfo.class.getName() + "::TM1CustomNumericPatternInfo()");
        }
    }

    private void setUseTrailingSign() {
        if (this.useParentheses.equalsIgnoreCase("N") && this.hasNegativePattern()) {
            if (!this.getNegativeSuffix().contains("-")) {
                this.useTrailingSign = "N";
            } else if (!this.getNegativePrefix().contains("-")) {
                this.useTrailingSign = "Y";
            }
        }
    }

    private void setDecimalSize() {
        String ptn;
        int indexE = this.positiveInnerPattern.indexOf("E");
        String string = ptn = indexE >= 0 ? this.positiveInnerPattern.substring(0, indexE) : this.positiveInnerPattern;
        if (ptn.contains(DECIMAL_SEPARATOR)) {
            int indexD = ptn.indexOf(DECIMAL_SEPARATOR);
            int end = indexE < 0 ? ptn.length() : indexE;
            this.decimalSize = (byte)(end - indexD - 1);
        }
    }

    private void covertCustomExponent2ICU() {
        if (this.getPositivePattern().contains("E")) {
            String newPositiveInnerPattern = this.covertMDXExponent2ICU(this.positiveInnerPattern);
            this.setPositivePattern(this.getPositivePattern().replace(this.positiveInnerPattern, newPositiveInnerPattern));
            this.positiveInnerPattern = newPositiveInnerPattern;
        }
        if (this.getNegativePattern().contains("E")) {
            String newNegativeInnerPattern = this.covertMDXExponent2ICU(this.negativeInnerPattern);
            this.setNegativePattern(this.getNegativePattern().replace(this.negativeInnerPattern, newNegativeInnerPattern));
            this.negativeInnerPattern = newNegativeInnerPattern;
        }
    }

    private void parsePrefixSuffixInnerPattern() {
        this.parsePositivePattern(this.getPositivePattern());
        if (this.hasNegativePattern()) {
            this.parseNegativePattern(this.getNegativePattern());
            if (!this.positiveInnerPattern.equals(this.negativeInnerPattern) && logger.isWarnEnabled()) {
                logger.warn("Warning: " + this.origFormatString + " has different numeric parts in its positive and negative sections." + " For the negative section, only the PREFIX and SUFFIX are noted; other" + " attributes are taken only from the positive section. ", this.getClass().getName() + "::parsePrefixSuffixInnerPattern()");
            }
        }
    }

    private void parsePositivePattern(String positivePattern) {
        Matcher m = this.parsePattern(positivePattern);
        if (m == null) {
            this.positivePrefix = positivePattern;
            this.positvieSuffix = "";
            this.positiveInnerPattern = "";
        } else {
            this.positivePrefix = positivePattern.substring(0, m.start());
            this.positvieSuffix = positivePattern.substring(m.end());
            this.positiveInnerPattern = m.group();
        }
    }

    private void parseNegativePattern(String negativePattern) {
        Matcher m = this.parsePattern(negativePattern);
        if (m == null) {
            this.negativePrefix = negativePattern;
            this.negativeSuffix = "";
            this.negativeInnerPattern = "";
        } else {
            this.negativePrefix = negativePattern.substring(0, m.start());
            this.negativeSuffix = negativePattern.substring(m.end());
            this.negativeInnerPattern = m.group();
        }
    }

    private Matcher parsePattern(String target) {
        Matcher m = numericPtn.matcher(target);
        if (m.find()) {
            return m;
        }
        return null;
    }

    private void initialValidation(Locale locale) {
        DecimalFormatSymbols symbolsByLocale = new DecimalFormatSymbols(locale);
        try {
            DecimalFormat testFormat = new DecimalFormat(this.getIntrimFormatString(this.getPositivePattern(), this.getNegativePattern()), symbolsByLocale);
            testFormat.format((Object)TEST_DOUBLE);
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidFormatPatternException(QLSFormattingMessageKeys.GEN_InvalidICUFormat, this.origFormatString, ex.getMessage());
        }
    }

    private void checkIfUniqueFormat() {
        if (this.isPercentFormat() && this.isCurrencyFormat()) {
            throw new InvalidFormatPatternException(QLSFormattingMessageKeys.GEN_InvalidPercentCurrencyFormat, this.origFormatString);
        }
    }

    private void setFormatPattern() {
        this.formatPattern = this.getIntrimFormatString(this.getPositivePattern(), this.getNegativePattern());
    }

    private String getIntrimFormatString(String pPtn, String nPtn) {
        String interimFormatString = pPtn;
        if (!nPtn.isEmpty()) {
            interimFormatString = interimFormatString + ";" + nPtn;
        }
        return interimFormatString;
    }

    private void parseSections() {
        String[] scs = this.origFormatString.split(Pattern.quote(";"));
        int len = scs.length;
        if (len <= 4) {
            this.setPositivePattern(TM1CustomNumericPatternInfo.processEscapeQuote(scs[0]));
            switch (len) {
                case 1: {
                    this.processRemainder(1);
                    break;
                }
                case 2: {
                    this.setNegativePattern(TM1CustomNumericPatternInfo.processEscapeQuote(scs[1]));
                    this.processRemainder(2);
                    break;
                }
                case 3: {
                    this.setNegativePattern(TM1CustomNumericPatternInfo.processEscapeQuote(scs[1]));
                    this.setZeroPattern(TM1CustomNumericPatternInfo.removeEscapeQuote(scs[2]));
                    break;
                }
                case 4: {
                    this.setNegativePattern(TM1CustomNumericPatternInfo.processEscapeQuote(scs[1]));
                    this.setZeroPattern(TM1CustomNumericPatternInfo.removeEscapeQuote(scs[2]));
                    this.setNullPattern(TM1CustomNumericPatternInfo.removeEscapeQuote(scs[3]));
                }
            }
        } else {
            throw new InvalidFormatPatternException(QLSFormattingMessageKeys.GEN_InvalidNumberOfSections, this.origFormatString);
        }
        if (this.getPositivePattern().isEmpty()) {
            throw new InvalidFormatPatternException(QLSFormattingMessageKeys.GEN_InvalidPositivePattern, this.origFormatString);
        }
    }

    private void processRemainder(int section) {
        String remainder = null;
        int i = -1;
        if (section == 1) {
            i = this.origFormatString.indexOf(";");
        } else {
            int k = this.origFormatString.indexOf(";");
            if (++k < this.origFormatString.length()) {
                i = this.origFormatString.indexOf(";", k);
            }
        }
        if (++i < this.origFormatString.length() && i > 0 && !(remainder = this.origFormatString.substring(i)).isEmpty()) {
            this.checkRemainder(remainder, section);
        }
    }

    private void checkRemainder(String remainder, int section) {
        if (section == 2) {
            this.setZeroPattern("");
            return;
        }
        if (section == 1) {
            if (remainder.startsWith(";;")) {
                this.setNegativePattern("");
                this.setZeroPattern("");
                return;
            }
            if (remainder.equals(";")) {
                this.setNegativePattern("");
            }
        }
    }

    private void parseCurrencySymbol() {
        String intrimCurrencySymbol = this.getCurrencySymbolFromPattern(this.getPositivePrefix(), this.getPositiveSuffix(), TM1CurrencyValueFormat.getAllI18nCurrencyCodes());
        if (intrimCurrencySymbol.isEmpty()) {
            intrimCurrencySymbol = this.getCurrencySymbolFromPattern(this.getPositivePrefix(), this.getPositiveSuffix(), TM1CurrencyValueFormat.getAllI18nCurrencySymbols());
        }
        if (!intrimCurrencySymbol.isEmpty()) {
            if (intrimCurrencySymbol.equals(this.getPositivePrefix().trim()) || intrimCurrencySymbol.equals(this.getPositiveSuffix().trim())) {
                this.currencySymbol = intrimCurrencySymbol;
            } else if (logger.isWarnEnabled()) {
                logger.warn("Warning: " + intrimCurrencySymbol + " could be identified as a currency symbol" + " only when it's used as prefix or suffix alone.", this.getClass().getName() + "::parseCurrencySymbol()");
            }
        }
    }

    private String getCurrencySymbolFromPattern(String prefix, String suffix, Set<String> currencySymbols) {
        for (String symbol : currencySymbols) {
            if (prefix.startsWith(symbol)) {
                if (suffix.endsWith(symbol)) {
                    throw new InvalidFormatPatternException(QLSFormattingMessageKeys.GEN_InvalidCurrencySymbol, symbol);
                }
                return symbol;
            }
            if (!suffix.endsWith(symbol)) continue;
            return symbol;
        }
        return "";
    }

    @Override
    protected void parsePercentSymbol() {
        if (this.positivePtn.endsWith("%") && "%".equals(this.getPositiveSuffix().trim())) {
            this.percentSymbol = "%";
            this.useTrailingPercent = "Y";
            return;
        }
        if (this.positivePtn.endsWith("\u2030") && "\u2030".equals(this.getPositiveSuffix().trim())) {
            this.percentSymbol = "\u2030";
            this.useTrailingPercent = "Y";
            return;
        }
        if (this.positivePtn.startsWith("%") && "%".equals(this.getPositivePrefix().trim())) {
            this.percentSymbol = "%";
            this.useTrailingPercent = "N";
            return;
        }
        if (this.positivePtn.startsWith("\u2030") && "\u2030".equals(this.getPositivePrefix().trim())) {
            this.percentSymbol = "\u2030";
            this.useTrailingPercent = "N";
            return;
        }
    }

    @Override
    public String getNullPattern() {
        return this.whenNull;
    }

    private void setNullPattern(String nullPtn) {
        this.whenNull = nullPtn;
    }

    private boolean isNonEmpty(String str) {
        return str != null && !str.isEmpty() && !str.trim().isEmpty();
    }

    private void setPositivePattern(String ptn) {
        if (this.isNonEmpty(ptn)) {
            this.positivePtn = ptn.trim();
        }
    }

    private void setNegativePattern(String ptn) {
        if (this.isNonEmpty(ptn)) {
            this.negativePtn = ptn.trim();
        }
    }

    private void setIfShowNegativeInBracket() {
        this.useParentheses = this.hasNegativePattern() ? (this.getNegativePrefix().contains("(") && this.getNegativeSuffix().contains(")") ? "Y" : "N") : "D";
    }

    @Override
    public boolean isPercentFormat() {
        return !this.percentSymbol.isEmpty();
    }

    @Override
    public boolean isScientificFormat() {
        return this.positiveInnerPattern.contains("E");
    }

    @Override
    public boolean isCustom() {
        return true;
    }

    @Override
    public boolean isCurrencyFormat() {
        return !this.currencySymbol.isEmpty();
    }

    public String toString() {
        return "TM1CustomNumericPatternInfo [negativeInnerPattern=" + this.negativeInnerPattern + ", positiveInnerPattern=" + this.positiveInnerPattern + ", decimalSize=" + this.decimalSize + ", useParentheses=" + this.useParentheses + ", positivePtn=" + this.positivePtn + ", negativePtn=" + this.negativePtn + ", formatPattern=" + this.formatPattern + ", origFormatString=" + this.origFormatString + ", currencySymbol=" + this.currencySymbol + ", percentSymbol=" + this.percentSymbol + ", whenZero=" + this.whenZero + ", whenNull=" + this.whenNull + ", positivePrefix=" + this.positivePrefix + ", positvieSuffix=" + this.positvieSuffix + ", negativePrefix=" + this.negativePrefix + ", negativeSuffix=" + this.negativeSuffix + "]";
    }
}

