/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.qls.format.impl.tm1.pattern;

import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LoggerManager;
import com.ibm.cognos.qls.format.exception.InvalidFormatPatternException;
import com.ibm.cognos.qls.format.exception.QLSFormattingMessageKeys;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class TM1NumericPatternInfo {
    protected static final ILogger logger = LoggerManager.getLogger((String)"ATHENA.core.qls_formatting");
    public static final String PATTERN_SEPARATOR = ";";
    public static final String LEFT_BRACKET = "(";
    public static final String RIGHT_BRACKET = ")";
    public static final String MINUS_SIGN = "-";
    protected static final String E = "E";
    protected static final char PLUS = '+';
    protected static final Pattern numericPtn = Pattern.compile("(#|0|,|\\.)+(#|0)*(E(\\+)?(#|0)+)?");
    protected static final Pattern expPtn = Pattern.compile("E(\\+)?");
    private static final Pattern hashZeroPtn = Pattern.compile("(#*0)");
    private static final Pattern hashTrailingPtn = Pattern.compile("(#+)$");
    protected byte decimalSize;
    protected String useParentheses = "";
    protected String positivePtn = "";
    protected String negativePtn = "";
    protected String formatPattern = "";
    protected String origFormatString = "";
    protected String currencySymbol = "";
    protected String percentSymbol = "";
    protected String whenZero = null;
    protected String whenNull = "";
    protected String positivePrefix = "";
    protected String positvieSuffix = "";
    protected String negativePrefix = "";
    protected String negativeSuffix = "";
    protected String useTrailingSign = "D";
    protected String useTrailingPercent = "D";

    protected TM1NumericPatternInfo(String ptn) {
        if (ptn == null || ptn.isEmpty()) {
            throw new InvalidFormatPatternException(QLSFormattingMessageKeys.GEN_InvalidFormatString, ptn);
        }
        this.origFormatString = ptn;
    }

    public byte getDecimalSize() {
        return this.decimalSize;
    }

    public abstract boolean isCustom();

    public abstract boolean isCurrencyFormat();

    public boolean hasNegativePattern() {
        return !this.negativePtn.isEmpty();
    }

    public String getPositivePattern() {
        return this.positivePtn;
    }

    public String getNegativePattern() {
        return this.negativePtn;
    }

    public String getUseParentheses() {
        return this.useParentheses;
    }

    public String getFormatPattern() {
        return this.formatPattern;
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public String getPercentSymbol() {
        return this.percentSymbol;
    }

    public String getUseTrailingPercent() {
        return this.useTrailingPercent;
    }

    public String getNullPattern() {
        return this.whenNull;
    }

    public abstract boolean isPercentFormat();

    public abstract boolean isScientificFormat();

    protected abstract void parsePercentSymbol();

    public String getPositivePrefix() {
        return this.positivePrefix;
    }

    public String getPositiveSuffix() {
        return this.positvieSuffix;
    }

    public String getNegativePrefix() {
        return this.negativePrefix;
    }

    public String getNegativeSuffix() {
        return this.negativeSuffix;
    }

    protected String covertMDXExponent2ICU(String numericPart) {
        Matcher m = expPtn.matcher(numericPart);
        if (m.find()) {
            String leading = numericPart.substring(0, m.end());
            String trailing = numericPart.substring(m.end());
            trailing = hashTrailingPtn.matcher(hashZeroPtn.matcher(trailing).replaceAll("0")).replaceAll("0");
            numericPart = leading + trailing;
        }
        return numericPart;
    }

    public String getZeroPattern() {
        return this.whenZero;
    }

    protected void setZeroPattern(String zeroPtn) {
        this.whenZero = zeroPtn;
    }

    protected static String processEscapeQuote(String inFormatString) {
        return inFormatString.replaceAll(Pattern.quote("\\%"), "'%'").replaceAll(Pattern.quote("\\"), "").replaceAll(Pattern.quote("\""), "'");
    }

    protected static String removeEscapeQuote(String inFormatString) {
        return inFormatString.replaceAll(Pattern.quote("\\"), "").replaceAll(Pattern.quote("\""), "");
    }

    public String getUseTrailingSign() {
        return this.useTrailingSign;
    }
}

