/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.provider.olap.tm1;

import com.ibm.cognos.aurora.api.model.IConnectionSpec;
import com.ibm.cognos.aurora.api.query.provider.IDataProvider;
import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LoggerManager;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.query.provider.connection.AbstractProviderConnection;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.ESecurityMode;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.TM1DataProvider;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.exception.TM1MessageKeys;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1CubeCache;
import com.ibm.cognos.tm1.API;
import com.ibm.cognos.tm1.Server;
import java.util.concurrent.TimeUnit;

public class TM1Connection
extends AbstractProviderConnection {
    public static final String SERVER_NAME = "serverName";
    public static final String ADMIN_HOST = "adminHost";
    public static final String SECURITY_MODE = "securityMode";
    private static final long VALIDATE_INTERVAL = 2000L;
    public static final String PASSPORT = "passport";
    public static final String CAF_ID = "cafId";
    private static final ILogger logger = LoggerManager.getLogger((String)"ATHENA.core.qls.connection");
    private final Server mServer;
    private long mLastValidateTimestamp = 0L;
    private ESecurityMode mServerSecurityMode = ESecurityMode.TM1_SECURITY_MODE_UNKNOWN;
    private final TM1CubeCache mCubeCache = new TM1CubeCache(this);
    private Boolean mRESTSupported = null;

    public TM1Connection(TM1DataProvider provider, IConnectionSpec connSpec, Server server) {
        super((IDataProvider)provider, connSpec);
        this.mServer = server;
    }

    public API getAPI() {
        TM1DataProvider provider = (TM1DataProvider)this.getProvider();
        return provider.getAPI();
    }

    public final Server getServer() {
        return this.mServer;
    }

    public final void setServerSecurityMode(ESecurityMode securityMode) {
        this.mServerSecurityMode = securityMode;
    }

    public final ESecurityMode getServerSecurityMode() {
        return this.mServerSecurityMode;
    }

    public final TM1CubeCache getCubeCache() {
        return this.mCubeCache;
    }

    public boolean validateImpl() {
        if (TimeUnit.NANOSECONDS.toMillis(System.nanoTime()) - this.mLastValidateTimestamp >= 2000L) {
            try {
                return this.mServer.validateConnection();
            }
            catch (Exception ex) {
                int connectionID = System.identityHashCode((Object)this);
                logger.error(String.format("Connection validation error [CONNECTION_ID=%h]: %s", connectionID, ex.getMessage()), "TM1Connection::validateImpl()", (Throwable)ex);
                return false;
            }
        }
        return true;
    }

    public boolean matches(IConnectionSpec connSpec) {
        IConnectionSpec thisConnSpec = this.getConnectionSpec();
        if (!TM1Connection.matchStringIgnoreCase((IConnectionSpec)thisConnSpec, (IConnectionSpec)connSpec, (String)ADMIN_HOST)) {
            return false;
        }
        if (!TM1Connection.matchStringIgnoreCase((IConnectionSpec)thisConnSpec, (IConnectionSpec)connSpec, (String)SERVER_NAME)) {
            return false;
        }
        if (connSpec.containsParameter("locale") && !TM1Connection.matchLocale((IConnectionSpec)thisConnSpec, (IConnectionSpec)connSpec, (String)"locale")) {
            return false;
        }
        switch (this.getServerSecurityMode()) {
            case TM1_SECURITY_MODE_BASIC: {
                if (!TM1Connection.matchStringIgnoreCase((IConnectionSpec)thisConnSpec, (IConnectionSpec)connSpec, (String)"user")) {
                    return false;
                }
                if (TM1Connection.matchStringIgnoreCase((IConnectionSpec)thisConnSpec, (IConnectionSpec)connSpec, (String)"password")) break;
                return false;
            }
            case TM1_SECURITY_MODE_CAM: {
                if (TM1Connection.matchString((IConnectionSpec)thisConnSpec, (IConnectionSpec)connSpec, (String)PASSPORT) && TM1Connection.matchString((IConnectionSpec)thisConnSpec, (IConnectionSpec)connSpec, (String)CAF_ID)) break;
                return false;
            }
            default: {
                throw new QLSRuntimeException(TM1MessageKeys.CON_UnsupportedSecurityMode, (Object)this.getServerSecurityMode().toString());
            }
        }
        return true;
    }

    protected void closeImpl() {
        if (logger.isInfoEnabled()) {
            logger.info(String.format("Closing connection [CONNECTION_ID=%h]", System.identityHashCode((Object)this)), "TM1Connection::closeImpl()");
        }
        this.mServer.dispose(true);
    }

    public boolean isRESTSupported() {
        if (null != this.mRESTSupported) {
            return this.mRESTSupported;
        }
        this.mRESTSupported = TM1DataProvider.isRESTSupported(this.getAPI().getVersion()) && TM1DataProvider.isRESTSupported(this.getServer().getVersion());
        return this.mRESTSupported;
    }

    public String toString() {
        return String.format("TM1Connection[CONNECTION_ID=%h, CONNECTION_SPEC=%s]", System.identityHashCode((Object)this), this.getConnectionSpec().toString());
    }
}

