/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.provider.olap.tm1;

import com.ibm.cognos.aurora.api.exception.CoreMessageKeys;
import com.ibm.cognos.aurora.api.model.IConnectionSpec;
import com.ibm.cognos.aurora.api.pmta_bridge.IPMTAApplication;
import com.ibm.cognos.aurora.api.query.IQueryLogicalStorage;
import com.ibm.cognos.aurora.api.query.provider.connection.IProviderConnection;
import com.ibm.cognos.aurora.api.query.provider.connection.IProviderConnectionFactory;
import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LoggerManager;
import com.ibm.cognos.aurora.core.util.LocaleUtil;
import com.ibm.cognos.aurora.qls.exception.QLSMessageKeys;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.ESecurityMode;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.PMTAConnection;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.TM1Connection;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.TM1DataProvider;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.exception.TM1MessageKeys;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.exception.TM1ProviderException;
import com.ibm.cognos.tm1.Server;
import com.ibm.cognos.tm1.TM1Exception;
import java.util.Locale;

public class TM1ConnectionFactory
implements IProviderConnectionFactory {
    private final TM1DataProvider mProvider;
    private static final ILogger logger = LoggerManager.getLogger((String)"ATHENA.core.qls.connection");

    public TM1ConnectionFactory(TM1DataProvider provider) {
        this.mProvider = provider;
    }

    public IProviderConnection create(IConnectionSpec connSpec) {
        connSpec = connSpec.duplicate();
        String adminHost = "";
        String serverName = "";
        Server server = null;
        try {
            Boolean usePMTA = connSpec.getParameterBooleanValue("usePMTA");
            if (Boolean.TRUE.equals(usePMTA)) {
                adminHost = "losthost";
                serverName = connSpec.getParameterStringValue("url");
                return this.connectPMTA(connSpec);
            }
            adminHost = connSpec.getParameterStringValue("adminHost");
            TM1ConnectionFactory.checkRequiredParameter("adminHost", adminHost);
            serverName = connSpec.getParameterStringValue("serverName");
            TM1ConnectionFactory.checkRequiredParameter("serverName", serverName);
            ESecurityMode mode = ESecurityMode.valueOf(this.mProvider.getAPI().getServerSecurityMode(adminHost, serverName));
            connSpec.setParameterValue("securityMode", (Object)mode.name());
            switch (mode) {
                case TM1_SECURITY_MODE_BASIC: {
                    server = this.connectBasic(connSpec);
                    break;
                }
                case TM1_SECURITY_MODE_CAM: {
                    server = this.connectCAM(connSpec);
                    break;
                }
                case TM1_SECURITY_MODE_DISTRIBUTED: {
                    server = this.connectDistributed(connSpec);
                    break;
                }
                case TM1_SECURITY_MODE_MIXED: {
                    server = this.connectMixed(connSpec);
                    break;
                }
                case TM1_SECURITY_MODE_WIA: {
                    server = this.connectWIA(connSpec);
                    break;
                }
                default: {
                    throw new QLSRuntimeException(TM1MessageKeys.CON_UnsupportedSecurityMode, (Object)mode.toString());
                }
            }
            TM1Connection connection = new TM1Connection(this.mProvider, connSpec, server);
            connection.setServerSecurityMode(mode);
            return connection;
        }
        catch (TM1Exception ex) {
            throw TM1ProviderException.convertConnectionError(ex, adminHost, serverName);
        }
    }

    private Server connectBasic(IConnectionSpec connSpec) throws TM1Exception {
        if (logger.isInfoEnabled()) {
            logger.info(String.format("connectBasic with parameters: %s", connSpec.toString()), this.getClass().getName() + "::connectBasic()");
        }
        String adminHost = connSpec.getParameterStringValue("adminHost");
        TM1ConnectionFactory.checkRequiredParameter("adminHost", adminHost);
        String serverName = connSpec.getParameterStringValue("serverName");
        TM1ConnectionFactory.checkRequiredParameter("serverName", serverName);
        String userName = connSpec.getParameterStringValue("user");
        TM1ConnectionFactory.checkRequiredParameter("user", userName);
        String password = connSpec.getParameterStringValue("password");
        TM1ConnectionFactory.checkRequiredParameter("password", password);
        if (connSpec.containsParameter("locale")) {
            Locale locale = LocaleUtil.localeFromString((String)connSpec.getParameterStringValue("locale"));
            return this.mProvider.getAPI().logon(adminHost, serverName, userName, password, locale);
        }
        return this.mProvider.getAPI().logon(adminHost, serverName, userName, password);
    }

    private Server connectCAM(IConnectionSpec connSpec) throws TM1Exception {
        if (logger.isInfoEnabled()) {
            logger.info(String.format("connectCAM with parameters: %s", connSpec.toString()), this.getClass().getName() + "::connectCAM()");
        }
        String passport = connSpec.getParameterStringValue("passport");
        String cafID = connSpec.getParameterStringValue("cafId");
        String adminHost = connSpec.getParameterStringValue("adminHost");
        String serverName = connSpec.getParameterStringValue("serverName");
        if (connSpec.containsParameter("locale")) {
            Locale locale = LocaleUtil.localeFromString((String)connSpec.getParameterStringValue("locale"));
            return this.mProvider.getAPI().logonCAM(adminHost, serverName, passport, cafID, locale);
        }
        return this.mProvider.getAPI().logonCAM(adminHost, serverName, passport, cafID);
    }

    private Server connectDistributed(IConnectionSpec connSpec) throws TM1Exception {
        if (logger.isInfoEnabled()) {
            logger.info(String.format("connectDistributed with parameters: %s", connSpec.toString()), this.getClass().getName() + "::connectDistributed()");
        }
        throw new QLSRuntimeException(CoreMessageKeys.GEN_NotYetSupported, (Object)"TM1ConnectionFactory.connectDistributed");
    }

    private Server connectMixed(IConnectionSpec connSpec) throws TM1Exception {
        if (logger.isInfoEnabled()) {
            logger.info(String.format("connectMixed with parameters: %s", connSpec.toString()), this.getClass().getName() + "::connectMixed()");
        }
        throw new QLSRuntimeException(CoreMessageKeys.GEN_NotYetSupported, (Object)"TM1ConnectionFactory.connectMixed");
    }

    private Server connectWIA(IConnectionSpec connSpec) throws TM1Exception {
        if (logger.isInfoEnabled()) {
            logger.info(String.format("connectWIA with parameters: %s", connSpec.toString()), this.getClass().getName() + "::connectWIA()");
        }
        throw new QLSRuntimeException(CoreMessageKeys.GEN_NotYetSupported, (Object)"TM1ConnectionFactory.connectWIA");
    }

    private TM1Connection connectPMTA(IConnectionSpec connSpec) throws TM1Exception {
        IQueryLogicalStorage qls;
        if (logger.isInfoEnabled()) {
            logger.info(String.format("connectPMTA with parameters: %s", connSpec.toString()), this.getClass().getName() + "::connectPMTA()");
        }
        if (!(qls = this.mProvider.getQLS()).isPMTABridgeAvailable()) {
            throw new QLSRuntimeException(CoreMessageKeys.GEN_FoundInternalErrorParam, (Object)"PMTA Bridge was not available");
        }
        String sessionID = connSpec.getParameterStringValue("sessionID");
        String url = connSpec.getParameterStringValue("url");
        boolean inProcess = connSpec.getParameterBooleanValue("inProcess");
        Locale locale = connSpec.containsParameter("locale") ? LocaleUtil.localeFromString((String)connSpec.getParameterStringValue("locale")) : Locale.getDefault();
        IPMTAApplication pmtaApp = inProcess ? qls.getPMTABridge().openPrivateClientModel(sessionID, url, connSpec.getParameterStringValue("dataDir"), locale) : qls.getPMTABridge().openModel(sessionID, url, locale);
        PMTAConnection connection = new PMTAConnection(this.mProvider, connSpec, pmtaApp);
        connection.setServerSecurityMode(ESecurityMode.TM1_SECURITY_MODE_BASIC);
        return connection;
    }

    private static void checkRequiredParameter(String name, Object value) {
        if (null == value) {
            throw new QLSRuntimeException(QLSMessageKeys.CON_MissingConnectionParam, (Object)name);
        }
    }
}

