/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.provider.olap.tm1.data;

import com.ibm.cognos.aurora.api.exception.CoreMessageKeys;
import com.ibm.cognos.aurora.api.model.value.BooleanValue;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.ValueFactory;
import com.ibm.cognos.aurora.api.query.OperationCanceledException;
import com.ibm.cognos.aurora.api.query.provider.dim.IAxisIterator;
import com.ibm.cognos.aurora.api.query.provider.dim.IMemberRecord;
import com.ibm.cognos.aurora.core.util.UniqueNameGenerator;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.query.provider.olap.metadata.MemberRecord;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.data.TM1CubeResultSet;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.exception.TM1MessageKeys;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.exception.TM1ProviderException;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.MemberDepthHelper;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Attribute;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Cube;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Dimension;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Hierarchy;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Level;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Member;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.util.ITM1RowsetView;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.util.TM1RowsetAccessor;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.util.TM1Utils;
import com.ibm.cognos.tm1.Axis;
import com.ibm.cognos.tm1.FieldType;
import com.ibm.cognos.tm1.Rowset;
import com.ibm.cognos.tm1.TM1Exception;

public class TM1AxisIterator
implements IAxisIterator {
    private final TM1CubeResultSet mResultSet;
    private final Axis mAxis;
    private final Rowset mRowset;
    private final TM1Dimension[] mDimensions;
    private final String[] mCommonMUNPrefixes;
    private final TM1RowsetAccessor<TM1Member.TM1MemberFields> mRowsetAccessor;
    private final ITM1RowsetView<TM1Member.TM1MemberFields>[] mRowsetViews;
    private final MemberDepthHelper mDepthHelper;
    private IMemberRecord[] mNextTuple;
    private volatile boolean mClosed = false;

    public TM1AxisIterator(TM1CubeResultSet rs, Axis axis) throws TM1Exception {
        this.mResultSet = rs;
        this.mDepthHelper = rs.getDepthHelper();
        this.mAxis = axis;
        this.mRowset = this.mAxis.getTupleRowset();
        TM1Cube cube = rs.getCube();
        String[] dimNames = this.mAxis.getDimensionNames();
        this.mDimensions = new TM1Dimension[dimNames.length];
        this.mCommonMUNPrefixes = new String[dimNames.length];
        this.mRowsetViews = new ITM1RowsetView[dimNames.length];
        this.mRowsetAccessor = TM1RowsetAccessor.create(this.mRowset, TM1Member.TM1MemberFields.class);
        for (int i = 0; i < dimNames.length; ++i) {
            String dun = UniqueNameGenerator.createSingleNamePart((String)dimNames[i]);
            this.mDimensions[i] = cube.findDimension(dun);
            if (null == this.mDimensions[i]) {
                throw new QLSRuntimeException(TM1MessageKeys.MET_DimensionNotFound, (Object)dun);
            }
            this.mCommonMUNPrefixes[i] = TM1Utils.createCommonMUNPrefix(this.mDimensions[i]);
            this.mRowsetViews[i] = this.mRowsetAccessor.createQualifiedView(dimNames[i]);
        }
        this.fetchNextTuple();
    }

    public boolean hasNext() {
        this.assertNotClosed();
        return null != this.mNextTuple;
    }

    public IMemberRecord[] next() {
        this.assertNotClosed();
        IMemberRecord[] tuple = this.mNextTuple;
        if (null == tuple) {
            return null;
        }
        try {
            this.fetchNextTuple();
        }
        catch (TM1Exception ex) {
            throw TM1ProviderException.convert(ex);
        }
        return tuple;
    }

    private void fetchNextTuple() throws TM1Exception {
        if (this.mResultSet.getQueryContext().isCanceled()) {
            throw new OperationCanceledException();
        }
        if (this.mRowsetAccessor.next()) {
            this.mNextTuple = new IMemberRecord[this.mDimensions.length];
            for (int i = 0; i < this.mDimensions.length; ++i) {
                this.mNextTuple[i] = this.readMember(i);
            }
        } else {
            this.mNextTuple = null;
        }
    }

    private IMemberRecord readMember(int tupleIndex) throws TM1Exception {
        String parentKey;
        TM1Dimension dimension = this.mDimensions[tupleIndex];
        TM1Hierarchy hierarchy = dimension.getDefaultHierarchy();
        String commonMUNPrefix = this.mCommonMUNPrefixes[tupleIndex];
        ITM1RowsetView<TM1Member.TM1MemberFields> view = this.mRowsetViews[tupleIndex];
        String providerMUN = view.getStringField(TM1Member.TM1MemberFields.MEMBER_UNIQUE_NAME);
        MemberRecord member = this.mResultSet.getCachedMember(providerMUN);
        if (null != member) {
            return member;
        }
        member = new MemberRecord(this.mResultSet.getSharedMemberFieldIndex());
        member.setUniqueName(TM1Utils.convertProviderMUNToMDDSMUN(commonMUNPrefix, providerMUN));
        member.setCaption(view.getStringField(TM1Member.TM1MemberFields.MEMBER_CAPTION));
        if (view.containsField(TM1Member.TM1MemberFields.MEMBER_NAME)) {
            member.setName(view.getStringField(TM1Member.TM1MemberFields.MEMBER_NAME));
        }
        if (null == member.getName()) {
            member.setName(member.getCaption());
        }
        if (view.containsField(TM1Member.TM1MemberFields.CHILDREN_CARDINALITY)) {
            member.setChildrenCardinality((long)((int)view.getIntegerField(TM1Member.TM1MemberFields.CHILDREN_CARDINALITY)));
        }
        TM1Level level = null;
        if (view.containsField(TM1Member.TM1MemberFields.LEVEL_UNIQUE_NAME)) {
            String levelUniqueName = view.getStringField(TM1Member.TM1MemberFields.LEVEL_UNIQUE_NAME);
            level = hierarchy.findLevel(levelUniqueName);
        }
        if (null == level) {
            int levelNumber = 0;
            if (view.containsField(TM1Member.TM1MemberFields.LEVEL_NUMBER)) {
                levelNumber = (int)view.getIntegerField(TM1Member.TM1MemberFields.LEVEL_NUMBER);
            }
            level = hierarchy.findLevel(levelNumber);
        }
        member.setLevelNumber(level.getLevelNumber());
        member.setLevelUniqueName(level.getUniqueName());
        member.setHierarchyUniqueName(hierarchy.getUniqueName());
        member.setDimensionUniqueName(dimension.getUniqueName());
        if (hierarchy.isRagged()) {
            if (hierarchy.isParentChild() && view.containsField(TM1Member.TM1MemberFields.LEVEL_NUMBER)) {
                member.setDepth((int)view.getIntegerField(TM1Member.TM1MemberFields.LEVEL_NUMBER));
            } else {
                member.setDepth(this.mDepthHelper.getMemberDepth(hierarchy, providerMUN));
            }
        } else {
            member.setDepth(member.getLevelNumber());
        }
        if (view.containsField(TM1Member.TM1MemberFields.PARENT_UNIQUE_NAME)) {
            String pun = view.getStringField(TM1Member.TM1MemberFields.PARENT_UNIQUE_NAME);
            if (null != pun && pun.length() > 0) {
                member.setParentUniqueName(TM1Utils.convertProviderMUNToMDDSMUN(commonMUNPrefix, view.getStringField(TM1Member.TM1MemberFields.PARENT_UNIQUE_NAME)));
            }
        } else if (view.containsField(TM1Member.TM1MemberFields.PARENT_KEY) && null != (parentKey = view.getStringField(TM1Member.TM1MemberFields.PARENT_KEY)) && parentKey.length() > 0) {
            member.setParentUniqueName(TM1Utils.createMDDSMUN(commonMUNPrefix, parentKey));
        }
        if (null != member.getParentUniqueName() && member.getParentUniqueName().length() > 0) {
            if (view.containsField(TM1Member.TM1MemberFields.PARENT_LEVEL)) {
                member.setParentLevel((int)view.getIntegerField(TM1Member.TM1MemberFields.PARENT_LEVEL));
            } else {
                member.setParentLevel(member.getLevelNumber() - 1);
            }
        } else {
            member.setParentLevel(-1);
        }
        for (TM1Attribute attr : level.getAttributes()) {
            String propUN = attr.getUniqueName();
            if (!this.mRowsetAccessor.containsField(propUN)) continue;
            FieldType fieldType = this.mRowsetAccessor.getFieldType(propUN);
            BooleanValue value = null;
            boolean isNull = false;
            boolean isError = false;
            boolean isDivByZero = false;
            switch (fieldType) {
                case Boolean: {
                    value = ValueFactory.createBoolean((boolean)this.mRowsetAccessor.getBooleanField(propUN));
                    break;
                }
                case Double: {
                    double dValue = this.mRowsetAccessor.getDoubleField(propUN);
                    value = ValueFactory.createDouble((double)dValue);
                    break;
                }
                case Integer: {
                    value = ValueFactory.createLong((long)this.mRowsetAccessor.getIntegerField(propUN));
                    break;
                }
                case String: {
                    String strValue = this.mRowsetAccessor.getStringField(propUN);
                    if ("".equals(strValue) || "\u0011n".equals(strValue) || "\u0011r".equals(strValue)) {
                        isNull = true;
                        break;
                    }
                    if ("\u0011e".equals(strValue)) {
                        isError = true;
                        break;
                    }
                    if ("\u0011d".equals(strValue)) {
                        isDivByZero = true;
                        break;
                    }
                    if ("\u0011z".equals(strValue)) {
                        value = ValueFactory.createDouble((double)0.0);
                        break;
                    }
                    value = ValueFactory.createString((String)strValue);
                    break;
                }
                default: {
                    isError = true;
                }
            }
            if (isNull) continue;
            if (isError) {
                value = ValueFactory.createString((int)1);
                value.setError();
            } else if (isDivByZero) {
                value = ValueFactory.createDouble((double)Double.NaN);
                value.setDivByZero();
            }
            member.setFieldValue(propUN, (IValue)value);
        }
        this.mResultSet.putCachedMember(member);
        return member;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.mClosed) {
            return;
        }
        try {
            this.mRowset.dispose();
        }
        finally {
            this.mClosed = true;
        }
    }

    void assertNotClosed() {
        if (this.mClosed) {
            throw new TM1ProviderException(CoreMessageKeys.GEN_FoundInternalErrorParam, "TM1AxisIterator was closed");
        }
    }
}

