/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.provider.olap.tm1.data;

import com.ibm.cognos.aurora.api.exception.CoreMessageKeys;
import com.ibm.cognos.aurora.api.query.IQueryContext;
import com.ibm.cognos.aurora.api.query.OperationCanceledException;
import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LogDataHelper;
import com.ibm.cognos.aurora.core.logging.LoggerManager;
import com.ibm.cognos.aurora.core.logging.Operation;
import com.ibm.cognos.aurora.core.logging.event.AuditLogBaseEvent;
import com.ibm.cognos.aurora.core.logging.event.PerfLogEvent;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.TM1Connection;
import com.ibm.cognos.tm1.AsyncJob;
import com.ibm.cognos.tm1.Cellset;
import com.ibm.cognos.tm1.StateType;
import com.ibm.cognos.tm1.TM1Exception;
import java.util.Arrays;

public class TM1MDXQuery {
    private static final int RECOVERABLE_CANCEL_MIN_CLIENT_VERSION = 90520100;
    private static final int RECOVERABLE_CANCEL_MIN_SERVER_VERSION = 90520100;
    private static final int QUERY_WAIT_TIME = 20;
    private static final int MAX_CANCEL_WAIT_TIME = 30000;
    private static final int FIRST_CANCEL_WAIT_TIME = 100;
    private static final int CANCEL_WAIT_INCREMENT_FACTOR = 2;
    private final TM1Connection mConnection;
    private final IQueryContext mQueryContext;
    private long[] mPartitions = new long[0];
    private boolean mCachingCells = false;
    private static final ILogger logger = LoggerManager.getLogger((String)"ATHENA.core.qls_providers");

    public TM1MDXQuery(TM1Connection connection, IQueryContext queryContext) {
        this.mConnection = connection;
        this.mQueryContext = queryContext;
    }

    public long[] getPartitions() {
        return this.mPartitions;
    }

    public void setPartitions(long[] partitions) {
        this.mPartitions = partitions;
    }

    public boolean isCachingCells() {
        return this.mCachingCells;
    }

    public void setCachingCells(boolean isCachingCells) {
        this.mCachingCells = isCachingCells;
    }

    public Cellset execute(String mdx) throws TM1Exception {
        int queryId = System.identityHashCode(this);
        int connectionId = System.identityHashCode((Object)this.mConnection);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Began MDX data query [CONNECTION_ID=%h, QUERY_ID=%h, PARTITIONS=%s, IS_CACHING=%b] \n%s", connectionId, queryId, Arrays.toString(this.mPartitions), this.mCachingCells, mdx), this.getClass().getName() + "::execute()");
        }
        if (logger.isAuditDebugEventEnabled()) {
            logger.auditDebugEvent(new AuditLogBaseEvent("", "", "", Operation.QUERY, LogDataHelper.createFunctionDebugLogData((String)"execute", (String)"MDXQuery", (String)String.format("MDX for query [CONNECTION_ID=%h, QUERY_ID=%h]: \n%s", connectionId, queryId, mdx))));
        }
        PerfLogEvent event = null;
        if (logger.isPerfDebugEnabled()) {
            event = logger.startPerfDebug(this.getClass().getName(), "execute", "Start executing");
        }
        AsyncJob mdxJob = this.mConnection.getServer().executeMDXBegin(mdx, this.mPartitions, this.mCachingCells);
        try {
            int cancelWaitTime = 100;
            int timeLeftToCancel = 30000;
            while (mdxJob.getState() == StateType.Running) {
                if (this.mQueryContext.isCanceled()) {
                    if (!this.supportsRecoverableCancel()) break;
                    if (logger.isWarnEnabled()) {
                        logger.warn(String.format("Cancelling data query [CONNECTION_ID=%h, QUERY_ID=%h]", connectionId, queryId), this.getClass().getName() + "::execute()");
                    }
                    mdxJob.cancel();
                    if (timeLeftToCancel > 0 && cancelWaitTime <= timeLeftToCancel) {
                        mdxJob.wait(cancelWaitTime);
                        cancelWaitTime = Math.min(cancelWaitTime * 2, timeLeftToCancel -= cancelWaitTime);
                        continue;
                    }
                    logger.error(String.format("Cancel timed out [CONNECTION_ID=%h, QUERY_ID=%h]", connectionId, queryId), this.getClass().getName() + "::execute()");
                    break;
                }
                mdxJob.wait(20);
            }
            if (this.mQueryContext.isCanceled()) {
                if (logger.isInfoEnabled()) {
                    logger.info(String.format("Cancelling data query [CONNECTION_ID=%h, QUERY_ID=%h]", connectionId, queryId), this.getClass().getName() + "::execute()");
                }
                if (this.supportsRecoverableCancel()) {
                    if (mdxJob.getState() == StateType.Completed || mdxJob.getState() == StateType.Cancelled) {
                        throw new OperationCanceledException();
                    }
                    logger.warn(String.format("Data query abandoned [CONNECTION_ID=%h, QUERY_ID=%h]", connectionId, queryId), this.getClass().getName() + "::execute()");
                    this.mConnection.invalidate();
                } else {
                    logger.warn(String.format("Data query abandoned [CONNECTION_ID=%h, QUERY_ID=%h]", connectionId, queryId), this.getClass().getName() + "::execute()");
                    this.mConnection.invalidate();
                    throw new OperationCanceledException();
                }
            }
            if (mdxJob.getState() == StateType.Failed) {
                TM1Exception error = mdxJob.getException();
                logger.error(String.format("Data query failed [CONNECTION_ID=%h, QUERY_ID=%h]: \n%s", connectionId, queryId, error.getMessage()), this.getClass().getName() + "::execute()");
                throw error;
            }
            if (mdxJob.getState() == StateType.Completed) {
                Cellset cellset = this.mConnection.getServer().executeMDXEnd(mdxJob);
                if (event != null) {
                    logger.stopPerfDebug(event, "Finished executing");
                }
                Cellset cellset2 = cellset;
                return cellset2;
            }
            throw new QLSRuntimeException(CoreMessageKeys.GEN_FoundInternalErrorParam, (Object)("Unexpected AsyncJob state: " + mdxJob.getState()));
        }
        finally {
            mdxJob.dispose();
        }
    }

    private boolean supportsRecoverableCancel() {
        return this.mConnection.getAPI().getVersion() >= 90520100 && this.mConnection.getServer().getVersion() >= 90520100;
    }
}

