/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.provider.olap.tm1.exception;

import com.ibm.cognos.aurora.api.exception.CoreMessageKeys;
import com.ibm.cognos.aurora.api.exception.IMessageKey;
import com.ibm.cognos.aurora.api.query.OperationCanceledException;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.query.provider.connection.InvalidConnectionException;
import com.ibm.cognos.aurora.qls.query.provider.connection.InvalidCredentialsException;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.exception.TM1MessageKeys;
import com.ibm.cognos.tm1.ErrorCode;
import com.ibm.cognos.tm1.TM1Exception;

public class TM1ProviderException
extends QLSRuntimeException {
    private static final long serialVersionUID = 1L;

    public TM1ProviderException(IMessageKey.Param0 messageKey) {
        super(messageKey);
    }

    public TM1ProviderException(IMessageKey.Param1 messageKey, Object par1) {
        super(messageKey, par1);
    }

    public TM1ProviderException(IMessageKey.Param2 messageKey, Object par1, Object par2) {
        super(messageKey, par1, par2);
    }

    public TM1ProviderException(IMessageKey.Param3 messageKey, Object par1, Object par2, Object par3) {
        super(messageKey, par1, par2, par3);
    }

    public TM1ProviderException(IMessageKey.Param4 messageKey, Object par1, Object par2, Object par3, Object par4) {
        super(messageKey, par1, par2, par3, par4);
    }

    public TM1ProviderException(IMessageKey.Param5 messageKey, Object par1, Object par2, Object par3, Object par4, Object par5) {
        super(messageKey, par1, par2, par3, par4, par5);
    }

    public TM1ProviderException(IMessageKey.Param6 messageKey, Object par1, Object par2, Object par3, Object par4, Object par5, Object par6) {
        super(messageKey, par1, par2, par3, par4, par5, par6);
    }

    public TM1ProviderException(IMessageKey.Param0 messageKey, Throwable aCause) {
        super(messageKey, aCause);
    }

    public TM1ProviderException(IMessageKey.Param1 messageKey, Throwable aCause, Object par1) {
        super(messageKey, aCause, par1);
    }

    public TM1ProviderException(IMessageKey.Param2 messageKey, Throwable aCause, Object par1, Object par2) {
        super(messageKey, aCause, par1, par2);
    }

    public TM1ProviderException(IMessageKey.Param3 messageKey, Throwable aCause, Object par1, Object par2, Object par3) {
        super(messageKey, aCause, par1, par2, par3);
    }

    public TM1ProviderException(IMessageKey.Param4 messageKey, Throwable aCause, Object par1, Object par2, Object par3, Object par4) {
        super(messageKey, aCause, par1, par2, par3, par4);
    }

    public TM1ProviderException(IMessageKey.Param5 messageKey, Throwable aCause, Object par1, Object par2, Object par3, Object par4, Object par5) {
        super(messageKey, aCause, par1, par2, par3, par4, par5);
    }

    public TM1ProviderException(IMessageKey.Param6 messageKey, Throwable aCause, Object par1, Object par2, Object par3, Object par4, Object par5, Object par6) {
        super(messageKey, aCause, par1, par2, par3, par4, par5, par6);
    }

    public static RuntimeException wrap(Throwable e) {
        return TM1ProviderException.wrap(null, e);
    }

    public static RuntimeException wrap(IMessageKey.Param0 key, Throwable e) {
        if (e instanceof TM1ProviderException) {
            return (TM1ProviderException)((Object)e);
        }
        if (key == null) {
            return new TM1ProviderException(CoreMessageKeys.GEN_FoundInternalError, e);
        }
        return new TM1ProviderException(key, e);
    }

    public static RuntimeException convert(TM1Exception error) {
        ErrorCode errCode = error.getErrorCode();
        String message = error.getMessage();
        switch (errCode) {
            case CAMDllLoadFailed: 
            case CannotInitializeAPI: 
            case JavaAPIInitializationFailed: {
                return new TM1ProviderException(TM1MessageKeys.API_InitializationError, error, (Object)errCode.toString(), (Object)message);
            }
            case SystemServerConnectionInvalid: {
                throw new InvalidConnectionException((Throwable)error);
            }
            case SystemServerOperationCanceled: {
                return new OperationCanceledException();
            }
        }
        return new TM1ProviderException(TM1MessageKeys.API_GenericError, error, (Object)errCode.toString(), (Object)message);
    }

    public static RuntimeException convertConnectionError(TM1Exception error, String adminHost, String serverName) {
        ErrorCode errCode = error.getErrorCode();
        switch (errCode) {
            case SystemServerClientNotFound: 
            case SystemServerClientPasswordInvalid: 
            case SystemServerClientConnectFailed: {
                return new InvalidCredentialsException((Throwable)error);
            }
            case SystemServerClientExceedMaxLogonNumber: {
                return new TM1ProviderException(TM1MessageKeys.CON_ExceedMaxLogonNumber, error);
            }
            case SystemServerClientPasswordExpired: {
                return new TM1ProviderException(TM1MessageKeys.CON_PasswordExpired, error);
            }
            case SystemServerIncompatibleVersion: {
                return new TM1ProviderException(TM1MessageKeys.CON_IncompatibleServerVersion, error);
            }
            case SystemServerNotFound: {
                return new TM1ProviderException(TM1MessageKeys.CON_ServerNotFound, error, (Object)adminHost, (Object)serverName);
            }
            case SystemServerConnectionInvalid: {
                throw new InvalidConnectionException((Throwable)error);
            }
            case SystemServerOperationCanceled: {
                return new OperationCanceledException();
            }
        }
        return new TM1ProviderException(TM1MessageKeys.CON_GenericError, error, (Object)errCode.toString(), (Object)adminHost, (Object)serverName);
    }
}

