/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata;

import com.ibm.cognos.aurora.api.model.datatype.DataTypes;
import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.aurora.api.query.provider.dim.EAggregateType;
import com.ibm.cognos.aurora.api.query.provider.dim.EDimensionType;
import com.ibm.cognos.aurora.api.query.provider.dim.EMemberType;
import com.ibm.cognos.aurora.api.query.provider.dim.ERollupType;
import com.ibm.cognos.aurora.qls.query.provider.FieldIndex;
import com.ibm.cognos.aurora.qls.query.provider.olap.metadata.CubeRecord;
import com.ibm.cognos.aurora.qls.query.provider.olap.metadata.DimensionRecord;
import com.ibm.cognos.aurora.qls.query.provider.olap.metadata.HierarchyRecord;
import com.ibm.cognos.aurora.qls.query.provider.olap.metadata.LevelRecord;
import com.ibm.cognos.aurora.qls.query.provider.olap.metadata.MeasureRecord;
import com.ibm.cognos.aurora.qls.query.provider.olap.metadata.MemberRecord;
import com.ibm.cognos.aurora.qls.query.provider.olap.metadata.PropertyRecord;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Attribute;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Cube;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Dimension;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Hierarchy;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Level;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Member;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.util.TM1Utils;

public class MetadataRecordBuilder {
    public static CubeRecord buildCube(TM1Cube cube, FieldIndex sharedFieldIndex) {
        CubeRecord record = new CubeRecord(sharedFieldIndex);
        record.setCatalogName("CATALOG");
        record.setCubeName(cube.getName());
        record.setCaption(cube.getCaption());
        record.setLastDataUpdate(cube.getLastDataUpdate());
        record.setLastSchemaUpdate(cube.getLastSchemaUpdate());
        return record;
    }

    public static DimensionRecord buildDimension(TM1Dimension dimension, FieldIndex sharedFieldIndex) {
        TM1Cube cube = dimension.getCube();
        DimensionRecord record = new DimensionRecord(sharedFieldIndex);
        record.setCatalogName("CATALOG");
        record.setCubeName(cube.getName());
        record.setName(dimension.getName());
        record.setCaption(dimension.getCaption());
        record.setUniqueName(dimension.getUniqueName());
        record.setOrdinal(dimension.getOrdinal());
        record.setCardinality(dimension.getCardinality());
        record.setDefaultHierarchy(dimension.getDefaultHierarchy().getUniqueName());
        if (dimension.isMeasureDimension()) {
            record.setDimensionType(EDimensionType.MEASURE);
        } else if (dimension.isTimeDimension()) {
            record.setDimensionType(EDimensionType.TIME);
        } else {
            record.setDimensionType(EDimensionType.REGULAR);
        }
        return record;
    }

    public static HierarchyRecord buildHierarchy(TM1Hierarchy hierarchy, FieldIndex sharedFieldIndex) {
        TM1Dimension dimension = hierarchy.getDimension();
        TM1Cube cube = dimension.getCube();
        HierarchyRecord record = new HierarchyRecord(sharedFieldIndex);
        record.setCatalogName("CATALOG");
        record.setCubeName(cube.getName());
        record.setDimensionUniqueName(dimension.getUniqueName());
        record.setName(hierarchy.getName());
        record.setCaption(hierarchy.getCaption());
        record.setUniqueName(hierarchy.getUniqueName());
        record.setCardinality((long)((int)hierarchy.getCardinality()));
        record.setRagged(hierarchy.isRagged());
        record.setBalanced(hierarchy.isBalanced());
        record.setParentChild(hierarchy.isParentChild());
        String defaultMUN = TM1Utils.convertProviderMUNToMDDSMUN(hierarchy.getCommonMUNPrefix(), hierarchy.getDefaultMemberUN());
        record.setDefaultMember(defaultMUN);
        String allMUN = null == hierarchy.getAllMemberUN() || hierarchy.getAllMemberUN().isEmpty() ? null : TM1Utils.convertProviderMUNToMDDSMUN(hierarchy.getCommonMUNPrefix(), hierarchy.getAllMemberUN());
        record.setAllMember(allMUN);
        return record;
    }

    public static LevelRecord buildLevel(TM1Level level, FieldIndex sharedFieldIndex) {
        TM1Hierarchy hierarchy = level.getHierarchy();
        TM1Dimension dimension = hierarchy.getDimension();
        TM1Cube cube = dimension.getCube();
        LevelRecord record = new LevelRecord(sharedFieldIndex);
        record.setCatalogName("CATALOG");
        record.setCubeName(cube.getName());
        record.setDimensionUniqueName(dimension.getUniqueName());
        record.setHierarchyUniqueName(hierarchy.getUniqueName());
        record.setUniqueName(level.getUniqueName());
        record.setName(level.getName());
        record.setCaption(level.getCaption());
        record.setCardinality(level.getCardinality());
        record.setLevelNumber(level.getLevelNumber());
        return record;
    }

    public static MemberRecord buildMember(TM1Member member, FieldIndex sharedFieldIndex) {
        TM1Level level = member.getLevel();
        TM1Hierarchy hierarchy = level.getHierarchy();
        TM1Dimension dimension = hierarchy.getDimension();
        TM1Cube cube = dimension.getCube();
        MemberRecord record = new MemberRecord(sharedFieldIndex);
        record.setCatalogName("CATALOG");
        record.setCubeName(cube.getName());
        record.setDimensionUniqueName(dimension.getUniqueName());
        record.setHierarchyUniqueName(hierarchy.getUniqueName());
        record.setLevelUniqueName(level.getUniqueName());
        record.setLevelNumber(member.getLevelNumber());
        record.setName(member.getName());
        record.setUniqueName(member.getUniqueName());
        record.setDescription(member.getDescription());
        record.setOrdinal(member.getOrdinal());
        if (null != member.getParentMUN() && member.getParentMUN().length() > 0) {
            record.setParentCount(1);
            record.setParentLevel(member.getParentLevel());
            record.setParentUniqueName(TM1Utils.convertProviderMUNToMDDSMUN(hierarchy.getCommonMUNPrefix(), member.getParentMUN()));
        } else {
            record.setParentCount(0);
            record.setParentLevel(-1);
        }
        record.setCaption(member.getCaption());
        record.setChildrenCardinality(member.getChildrenCardinality());
        record.setMemberType(EMemberType.REGULAR);
        record.setRollupType(ERollupType.ROLLUP);
        return record;
    }

    public static MeasureRecord buildMeasure(TM1Member measure, FieldIndex sharedFieldIndex) {
        TM1Level level = measure.getLevel();
        TM1Hierarchy hierarchy = level.getHierarchy();
        TM1Dimension dimension = hierarchy.getDimension();
        TM1Cube cube = dimension.getCube();
        MeasureRecord record = new MeasureRecord(sharedFieldIndex);
        String mddsHUN = TM1Utils.joinUniqueNames(dimension.getProviderUniqueName(), hierarchy.getProviderUniqueName());
        String mddsLUN = TM1Utils.joinUniqueNames(dimension.getProviderUniqueName(), level.getProviderUniqueName());
        String mddsMUN = TM1Utils.convertProviderMUNToMDDSMUN(hierarchy.getCommonMUNPrefix(), measure.getProviderUniqueName());
        record.setCatalogName("CATALOG");
        record.setCubeName(cube.getName());
        record.setDimensionUniqueName(dimension.getProviderUniqueName());
        record.setHierarchyUniqueName(mddsHUN);
        record.setLevelUniqueName(mddsLUN);
        record.setLevelNumber(level.getLevelNumber());
        record.setDataType((IDataType)DataTypes.getDoubleType());
        record.setAggregateType(EAggregateType.UNKNOWN);
        record.setName(measure.getName());
        record.setUniqueName(mddsMUN);
        record.setCaption(measure.getCaption());
        return record;
    }

    public static PropertyRecord buildProperty(TM1Attribute attribute, FieldIndex sharedFieldIndex) {
        PropertyRecord record = new PropertyRecord(sharedFieldIndex);
        record.setCatalogName("CATALOG");
        record.setUniqueName(attribute.getUniqueName());
        record.setName(attribute.getName());
        record.setCaption(attribute.getCaption());
        record.setRoleType(attribute.getRoleType());
        if (attribute.isDimensionAttribute()) {
            TM1Dimension dimension = attribute.getDimension();
            TM1Cube cube = dimension.getCube();
            record.setCubeName(cube.getName());
            record.setDimensionUniqueName(dimension.getUniqueName());
        } else if (attribute.isHierarchyAttribute()) {
            TM1Hierarchy hierarchy = attribute.getHierarchy();
            TM1Dimension dimension = hierarchy.getDimension();
            TM1Cube cube = dimension.getCube();
            record.setCubeName(cube.getName());
            record.setDimensionUniqueName(dimension.getUniqueName());
            record.setHierarchyUniqueName(hierarchy.getUniqueName());
        } else {
            TM1Level level = attribute.getLevel();
            TM1Hierarchy hierarchy = level.getHierarchy();
            TM1Dimension dimension = hierarchy.getDimension();
            TM1Cube cube = dimension.getCube();
            record.setCubeName(cube.getName());
            record.setDimensionUniqueName(dimension.getUniqueName());
            record.setHierarchyUniqueName(hierarchy.getUniqueName());
            record.setLevelUniqueName(level.getUniqueName());
        }
        record.setDataType(TM1Utils.convertFieldTypeToDataType(attribute.getDataType()));
        return record;
    }

    private MetadataRecordBuilder() {
    }
}

