/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata;

import com.ibm.cognos.aurora.api.query.provider.dim.EPropertyRole;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.exception.TM1MessageKeys;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Dimension;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Hierarchy;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Level;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Metadata;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1MetadataType;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.util.ITM1Field;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.util.ITM1RowsetView;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.util.TM1Utils;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.util.TraceObject;
import com.ibm.cognos.tm1.FieldType;
import com.ibm.cognos.tm1.TM1Exception;

public final class TM1Attribute
extends TM1Metadata {
    private final EPropertyRole mRole;
    private FieldType mDataType;
    private String mDescription;

    public TM1Attribute(TM1Dimension dimension, EPropertyRole role) {
        super(dimension);
        this.mRole = role;
    }

    public TM1Attribute(TM1Hierarchy hierarchy, EPropertyRole role) {
        super(hierarchy);
        this.mRole = role;
    }

    public TM1Attribute(TM1Level level, EPropertyRole role) {
        super(level);
        this.mRole = role;
    }

    @Override
    public TM1MetadataType getType() {
        return TM1MetadataType.ATTRIBUTE;
    }

    @Override
    public String getUniqueName() {
        if (null == this.mUniqueName) {
            this.mUniqueName = EPropertyRole.CUSTOM_PROPERTY == this.mRole ? TM1Utils.createMDDSPUN(this.getDimension(), this.getName()) : this.mProviderUniqueName;
        }
        return this.mUniqueName;
    }

    public boolean isDimensionAttribute() {
        return TM1MetadataType.DIMENSION == this.getParent().getType();
    }

    public boolean isHierarchyAttribute() {
        return TM1MetadataType.HIERARCHY == this.getParent().getType();
    }

    public boolean isLevelAttribute() {
        return TM1MetadataType.LEVEL == this.getParent().getType();
    }

    public boolean isAlias() {
        return "alias".equals(this.mDescription);
    }

    public TM1Dimension getDimension() {
        switch (this.getParent().getType()) {
            case DIMENSION: {
                return (TM1Dimension)this.getParent();
            }
            case HIERARCHY: {
                return ((TM1Hierarchy)this.getParent()).getDimension();
            }
            case LEVEL: {
                return ((TM1Level)this.getParent()).getHierarchy().getDimension();
            }
        }
        return null;
    }

    public TM1Hierarchy getHierarchy() {
        switch (this.getParent().getType()) {
            case HIERARCHY: {
                return (TM1Hierarchy)this.getParent();
            }
            case LEVEL: {
                return ((TM1Level)this.getParent()).getHierarchy();
            }
        }
        return null;
    }

    public TM1Level getLevel() {
        switch (this.getParent().getType()) {
            case LEVEL: {
                return (TM1Level)this.getParent();
            }
        }
        return null;
    }

    public FieldType getDataType() {
        return this.mDataType;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public EPropertyRole getRoleType() {
        return this.mRole;
    }

    public void populate(ITM1RowsetView<TM1AttributeFields> view) throws TM1Exception {
        this.mProviderUniqueName = this.mName = view.getStringField(TM1AttributeFields.PROPERTY_NAME);
        this.mProviderCaption = view.getStringField(TM1AttributeFields.PROPERTY_CAPTION);
        this.mDescription = view.getStringField(TM1AttributeFields.DESCRIPTION);
        int dataTypeNum = (int)view.getIntegerField(TM1AttributeFields.DATA_TYPE);
        switch (dataTypeNum) {
            case 5: {
                this.mDataType = FieldType.Double;
                break;
            }
            case 129: {
                this.mDataType = FieldType.String;
                break;
            }
            default: {
                throw new QLSRuntimeException(TM1MessageKeys.MET_UnexpectedAttributeType, (Object)dataTypeNum, (Object)this.mName);
            }
        }
    }

    @Override
    public TraceObject toTraceObject() {
        TraceObject trace = new TraceObject("TM1Attribute");
        trace.setAttribute("name", this.getName());
        trace.setAttribute("caption", this.getCaption());
        trace.setAttribute("dataType", this.getDataType());
        trace.setAttribute("description", this.getDescription());
        trace.setAttribute("role", this.getRoleType().name());
        return trace;
    }

    public static enum TM1AttributeFields implements ITM1Field
    {
        CUBE_NAME,
        DIMENSION_UNIQUE_NAME,
        PROPERTY_TYPE,
        PROPERTY_NAME,
        PROPERTY_CAPTION,
        DATA_TYPE,
        DESCRIPTION;

        private final String mFieldName;

        private TM1AttributeFields() {
            this.mFieldName = this.name();
        }

        private TM1AttributeFields(String fieldName) {
            this.mFieldName = fieldName;
        }

        @Override
        public String getFieldName() {
            return this.mFieldName;
        }
    }
}

