/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata;

import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1CubeTimestamps;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Dimension;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Metadata;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1MetadataType;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.util.ITM1Field;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.util.TraceObject;
import com.ibm.cognos.tm1.Cube;
import com.ibm.cognos.tm1.TM1Exception;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public final class TM1Cube
extends TM1Metadata {
    private String mMeasureDUN;
    private String mTimeDUN;
    private final TM1CubeTimestamps mTimestamps;
    private double mUndefVal = 0.0;
    private final Map<String, TM1Dimension> mDimensionsByDUN = new LinkedHashMap<String, TM1Dimension>();

    public TM1Cube() {
        super(null);
        Calendar cal = Calendar.getInstance();
        this.mTimestamps = new TM1CubeTimestamps(cal.getTime(), cal.getTime());
    }

    @Override
    public TM1MetadataType getType() {
        return TM1MetadataType.CUBE;
    }

    @Override
    public String getUniqueName() {
        return this.getProviderUniqueName();
    }

    public String getMeasureDUN() {
        return this.mMeasureDUN;
    }

    public String getTimeDUN() {
        return this.mTimeDUN;
    }

    public TM1CubeTimestamps getTimestamps() {
        return this.mTimestamps;
    }

    public Date getLastSchemaUpdate() {
        if (null != this.mTimestamps) {
            return this.mTimestamps.getLastSchemaUpdate();
        }
        return null;
    }

    public Date getLastDataUpdate() {
        if (null != this.mTimestamps) {
            return this.mTimestamps.getLastDataUpdate();
        }
        return null;
    }

    public double getUndefVal() {
        return this.mUndefVal;
    }

    public Collection<TM1Dimension> getDimensions() {
        return Collections.unmodifiableCollection(this.mDimensionsByDUN.values());
    }

    public TM1Dimension getMeasureDimension() {
        if (null == this.mMeasureDUN) {
            return null;
        }
        return this.findDimension(this.mMeasureDUN);
    }

    public TM1Dimension getTimeDimension() {
        if (null == this.mTimeDUN) {
            return null;
        }
        return this.findDimension(this.mTimeDUN);
    }

    public TM1Dimension findDimension(String dun) {
        return this.mDimensionsByDUN.get(dun);
    }

    public TM1Dimension findDimensionByName(String name) {
        for (TM1Dimension dim : this.getDimensions()) {
            if (!dim.getName().equals(name)) continue;
            return dim;
        }
        return null;
    }

    public void populate(Cube cubeAPI) throws TM1Exception {
        this.mProviderUniqueName = this.mName = cubeAPI.getName();
        this.mProviderCaption = cubeAPI.getCaption();
        this.mMeasureDUN = cubeAPI.getMeasuresDimension();
        this.mTimeDUN = cubeAPI.getTimeDimension();
        this.mUndefVal = cubeAPI.getUndefVal();
        this.mTimestamps.setLastSchemaUpdate(cubeAPI.getLastSchemaUpdate());
        this.mTimestamps.setLastDataUpdate(cubeAPI.getLastDataUpdate());
    }

    @Override
    public TraceObject toTraceObject() {
        TraceObject trace = new TraceObject("TM1Cube");
        trace.setAttribute("name", this.getName());
        trace.setAttribute("caption", this.getCaption());
        trace.setAttribute("measureDUN", this.getMeasureDUN());
        trace.setAttribute("timeDUN", this.getTimeDUN());
        trace.setAttribute("lastSchemaUpdate", this.getLastSchemaUpdate());
        trace.setAttribute("lastDataUpdate", this.getLastDataUpdate());
        trace.setAttribute("undefVal", this.getUndefVal());
        for (TM1Dimension dimension : this.getDimensions()) {
            trace.addChild(dimension.toTraceObject());
        }
        return trace;
    }

    void addDimension(TM1Dimension dimension) {
        this.mDimensionsByDUN.put(dimension.getUniqueName(), dimension);
    }

    public static enum TM1CubeFields implements ITM1Field
    {
        CUBE_NAME,
        CUBE_CAPTION,
        MEASURES_DIMENSION,
        TIME_DIMENSION,
        LAST_SCHEMA_UPDATE,
        LAST_DATA_UPDATE,
        UNDEF_VAL;

        private final String mFieldName;

        private TM1CubeFields() {
            this.mFieldName = this.name();
        }

        private TM1CubeFields(String fieldName) {
            this.mFieldName = fieldName;
        }

        @Override
        public String getFieldName() {
            return this.mFieldName;
        }
    }
}

