/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata;

import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Level;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Metadata;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1MetadataType;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.util.ITM1Field;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.util.ITM1RowsetView;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.util.TM1Utils;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.util.TraceObject;
import com.ibm.cognos.tm1.TM1Exception;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public final class TM1Member
extends TM1Metadata {
    private long mOrdinal;
    private int mLevelNumber;
    private long mChildrenCardinality;
    private int mParentLevel;
    private String mParentMUN;
    private String mDescription;
    private final Map<String, String> mAliasValues = new TreeMap<String, String>();

    public TM1Member(TM1Level level) {
        super(level);
    }

    @Override
    public TM1MetadataType getType() {
        return TM1MetadataType.MEMBER;
    }

    @Override
    public String getUniqueName() {
        if (null == this.mUniqueName) {
            this.mUniqueName = TM1Utils.convertProviderMUNToMDDSMUN(this.getLevel().getHierarchy().getCommonMUNPrefix(), this.getProviderUniqueName());
        }
        return this.mUniqueName;
    }

    public TM1Level getLevel() {
        return (TM1Level)this.getParent();
    }

    public long getChildrenCardinality() {
        return this.mChildrenCardinality;
    }

    public int getLevelNumber() {
        return this.mLevelNumber;
    }

    public long getOrdinal() {
        return this.mOrdinal;
    }

    public int getParentLevel() {
        return this.mParentLevel;
    }

    public String getParentMUN() {
        return this.mParentMUN;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public Map<String, String> getAliasValues() {
        return Collections.unmodifiableMap(this.mAliasValues);
    }

    public void populate(ITM1RowsetView<TM1MemberFields> view) throws TM1Exception {
        this.mName = view.getStringField(TM1MemberFields.MEMBER_NAME);
        this.mProviderUniqueName = view.getStringField(TM1MemberFields.MEMBER_UNIQUE_NAME);
        this.mProviderCaption = view.getStringField(TM1MemberFields.MEMBER_CAPTION);
        this.mOrdinal = view.getIntegerField(TM1MemberFields.MEMBER_ORDINAL);
        this.mDescription = this.mName;
        this.mLevelNumber = (int)view.getIntegerField(TM1MemberFields.LEVEL_NUMBER);
        this.mChildrenCardinality = view.getIntegerField(TM1MemberFields.CHILDREN_CARDINALITY);
        this.mParentMUN = view.getStringField(TM1MemberFields.PARENT_UNIQUE_NAME);
        this.mParentLevel = null == this.mParentMUN || this.mParentMUN.length() == 0 ? -1 : (view.containsField(TM1MemberFields.PARENT_LEVEL) ? (int)view.getIntegerField(TM1MemberFields.PARENT_LEVEL) : this.mLevelNumber - 1);
        for (String aliasName : this.getLevel().getHierarchy().getDimension().getAliasNames()) {
            if (!view.containsField(aliasName)) continue;
            String value = view.getStringField(aliasName);
            this.mAliasValues.put(aliasName, value);
        }
    }

    @Override
    public TraceObject toTraceObject() {
        TraceObject trace = new TraceObject("TM1Member");
        trace.setAttribute("name", this.getName());
        trace.setAttribute("uniqueName", this.getUniqueName());
        trace.setAttribute("caption", this.getCaption());
        trace.setAttribute("ordinal", this.getOrdinal());
        trace.setAttribute("parentMUN", this.getParentMUN());
        trace.setAttribute("parentLevel", this.getParentLevel());
        trace.setAttribute("levelNumber", this.getLevel());
        trace.setAttribute("childrenCardinality", this.getChildrenCardinality());
        return trace;
    }

    public static enum TM1MemberFields implements ITM1Field
    {
        MEMBER_NAME,
        MEMBER_UNIQUE_NAME,
        MEMBER_CAPTION,
        MEMBER_ORDINAL,
        LEVEL_NUMBER,
        LEVEL_UNIQUE_NAME,
        CHILDREN_CARDINALITY,
        PARENT_UNIQUE_NAME,
        PARENT_LEVEL,
        PARENT_KEY("parentKey"),
        LABEL("label");

        private final String mFieldName;

        private TM1MemberFields() {
            this.mFieldName = this.name();
        }

        private TM1MemberFields(String fieldName) {
            this.mFieldName = fieldName;
        }

        @Override
        public String getFieldName() {
            return this.mFieldName;
        }
    }
}

