/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata;

import com.ibm.cognos.aurora.api.query.provider.IRestrictions;
import com.ibm.cognos.aurora.api.query.provider.dim.ETreeOp;
import com.ibm.cognos.aurora.api.query.provider.dim.ICatalogRecord;
import com.ibm.cognos.aurora.api.query.provider.dim.ICubeRecord;
import com.ibm.cognos.aurora.api.query.provider.dim.IDimensionRecord;
import com.ibm.cognos.aurora.api.query.provider.dim.IHierarchyRecord;
import com.ibm.cognos.aurora.api.query.provider.dim.ILevelRecord;
import com.ibm.cognos.aurora.api.query.provider.dim.IMeasureRecord;
import com.ibm.cognos.aurora.api.query.provider.dim.IMemberRecord;
import com.ibm.cognos.aurora.api.query.provider.dim.IPropertyRecord;
import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LogDataHelper;
import com.ibm.cognos.aurora.core.logging.LoggerManager;
import com.ibm.cognos.aurora.core.logging.Operation;
import com.ibm.cognos.aurora.core.logging.event.AuditLogBaseEvent;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.query.provider.olap.metadata.CatalogRecord;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.TM1Connection;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.exception.TM1MessageKeys;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1CubeTimestamps;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1MetadataLoader;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.query.CubeDefaultMeasureQuery;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.query.CubeRecordQuery;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.query.DimensionRecordQuery;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.query.HierarchyRecordQuery;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.query.HierarchyRootMembersQuery;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.query.LevelRecordQuery;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.query.MeasureRecordQuery;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.query.MemberRecordQuery;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.query.MetadataQuery;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.query.PropertyRecordQuery;
import com.ibm.cognos.tm1.Cube;
import com.ibm.cognos.tm1.Server;
import com.ibm.cognos.tm1.TM1Exception;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;

public class TM1MetadataSession {
    private final TM1Connection mConnection;
    private final TM1MetadataLoader mLoader;
    private static final ILogger logger = LoggerManager.getLogger((String)"ATHENA.core.qls_providers");

    public TM1MetadataSession(TM1Connection connection) {
        this.mConnection = connection;
        this.mLoader = new TM1MetadataLoader(this.mConnection);
    }

    public TM1Connection getConnection() {
        return this.mConnection;
    }

    public Server getServer() {
        return this.mConnection.getServer();
    }

    public TM1MetadataLoader getLoader() {
        return this.mLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ICubeRecord> getCubeRecords(IRestrictions restrictions) throws TM1Exception {
        String cubeName = restrictions.stringValue("CUBE_NAME", null);
        CubeRecordQuery query = new CubeRecordQuery(this);
        query.setCubeName(cubeName);
        this.setRangeRestrictions(query, restrictions);
        try {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Fetching cube records [CONNECTION_ID=%h, RESTRICTIONS=%s]", System.identityHashCode((Object)this.mConnection), restrictions.toString()), TM1MetadataSession.class.getName() + "::getCubeRecords()");
            }
            if (logger.isAuditDebugEventEnabled()) {
                logger.auditDebugEvent(new AuditLogBaseEvent("", "", "", Operation.QUERY, LogDataHelper.createFunctionDebugLogData((String)"execute", (String)"CubeRecordQuery", (String)("Cube Name: " + cubeName))));
            }
            List<ICubeRecord> list = query.execute();
            return list;
        }
        finally {
            query.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IDimensionRecord> getDimensionRecords(IRestrictions restrictions) throws TM1Exception {
        String cubeName = restrictions.stringValue("CUBE_NAME", null);
        String dun = restrictions.stringValue("DIMENSION_UNIQUE_NAME", null);
        DimensionRecordQuery query = new DimensionRecordQuery(this);
        query.setCubeName(cubeName);
        query.setDUN(dun);
        this.setRangeRestrictions(query, restrictions);
        try {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Fetching dimension records [CONNECTION_ID=%h, RESTRICTIONS=%s]", System.identityHashCode((Object)this.mConnection), restrictions.toString()), TM1MetadataSession.class.getName() + "::getDimensionRecords()");
            }
            if (logger.isAuditDebugEventEnabled()) {
                logger.auditDebugEvent(new AuditLogBaseEvent("", "", "", Operation.QUERY, LogDataHelper.createFunctionDebugLogData((String)"execute", (String)"DimensionRecordQuery", (String)String.format("Cube Name : %s; DUN: %s", cubeName, dun))));
            }
            List<IDimensionRecord> list = query.execute();
            return list;
        }
        finally {
            query.release();
        }
    }

    public List<ICatalogRecord> getCatalogRecords(IRestrictions restrictions) throws TM1Exception {
        String catalogName = restrictions.stringValue("CATALOG_NAME", null);
        if (null == catalogName || "CATALOG".equals(catalogName)) {
            CatalogRecord record = new CatalogRecord();
            record.setCatalogName("CATALOG");
            return Collections.singletonList(record);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCubeDefaultMeasure(IRestrictions restrictions) throws TM1Exception {
        String cubeName = restrictions.stringValue("CUBE_NAME", null);
        CubeDefaultMeasureQuery query = new CubeDefaultMeasureQuery(this);
        query.setCubeName(cubeName);
        try {
            List<String> result;
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Fetching cube default measure [CONNECTION_ID=%h, RESTRICTIONS=%s]", System.identityHashCode((Object)this.mConnection), restrictions.toString()), TM1MetadataSession.class.getName() + "::getCubeDefaultMeasure()");
            }
            if (logger.isAuditDebugEventEnabled()) {
                logger.auditDebugEvent(new AuditLogBaseEvent("", "", "", Operation.QUERY, LogDataHelper.createFunctionDebugLogData((String)"execute", (String)"CubeDefaultMeasureQuery", (String)("Cube Name: " + cubeName))));
            }
            if ((result = query.execute()).isEmpty()) {
                String string = null;
                return string;
            }
            String string = result.get(0);
            return string;
        }
        finally {
            query.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IHierarchyRecord> getHierarchyRecords(IRestrictions restrictions) throws TM1Exception {
        String cubeName = restrictions.stringValue("CUBE_NAME", null);
        String dun = restrictions.stringValue("DIMENSION_UNIQUE_NAME", null);
        String hun = restrictions.stringValue("HIERARCHY_UNIQUE_NAME", null);
        HierarchyRecordQuery query = new HierarchyRecordQuery(this);
        query.setCubeName(cubeName);
        query.setDUN(dun);
        query.setHUN(hun);
        this.setRangeRestrictions(query, restrictions);
        try {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Fetching hierarchy records [CONNECTION_ID=%h, RESTRICTIONS=%s]", System.identityHashCode((Object)this.mConnection), restrictions.toString()), TM1MetadataSession.class.getName() + "::getHierarchyRecords()");
            }
            if (logger.isAuditDebugEventEnabled()) {
                logger.auditDebugEvent(new AuditLogBaseEvent("", "", "", Operation.QUERY, LogDataHelper.createFunctionDebugLogData((String)"execute", (String)"HierarchyRecordQuery", (String)String.format("Cube Name : %s;  DUN: %s;  HUN: %s", cubeName, dun, hun))));
            }
            List<IHierarchyRecord> list = query.execute();
            return list;
        }
        finally {
            query.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IMemberRecord> getHierarchyRootMemberRecords(IRestrictions restrictions) throws TM1Exception {
        String cubeName = restrictions.stringValue("CUBE_NAME", null);
        String hun = restrictions.stringValue("HIERARCHY_UNIQUE_NAME", null);
        HierarchyRootMembersQuery query = new HierarchyRootMembersQuery(this);
        query.setCubeName(cubeName);
        query.setHUN(hun);
        this.setRangeRestrictions(query, restrictions);
        try {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Fetching hierarchy root member records [CONNECTION_ID=%h, RESTRICTIONS=%s]", System.identityHashCode((Object)this.mConnection), restrictions.toString()), TM1MetadataSession.class.getName() + "::getHierarchyRootMemberRecords()");
            }
            if (logger.isAuditDebugEventEnabled()) {
                logger.auditDebugEvent(new AuditLogBaseEvent("", "", "", Operation.QUERY, LogDataHelper.createFunctionDebugLogData((String)"execute", (String)"HierarchyRootMembersQuery", (String)String.format("Cube Name : %s;  HUN: %s", cubeName, hun))));
            }
            List<IMemberRecord> list = query.execute();
            return list;
        }
        finally {
            query.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ILevelRecord> getLevelRecords(IRestrictions restrictions) throws TM1Exception {
        String cubeName = restrictions.stringValue("CUBE_NAME", null);
        String dun = restrictions.stringValue("DIMENSION_UNIQUE_NAME", null);
        String hun = restrictions.stringValue("HIERARCHY_UNIQUE_NAME", null);
        String lun = restrictions.stringValue("LEVEL_UNIQUE_NAME", null);
        int levelNumber = restrictions.intValue("LEVEL_NUMBER", -1);
        LevelRecordQuery query = new LevelRecordQuery(this);
        query.setCubeName(cubeName);
        query.setDUN(dun);
        query.setHUN(hun);
        query.setLUN(lun);
        if (-1 != levelNumber) {
            query.setLevelNumber(levelNumber);
        }
        this.setRangeRestrictions(query, restrictions);
        try {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Fetching level records [CONNECTION_ID=%h, RESTRICTIONS=%s]", System.identityHashCode((Object)this.mConnection), restrictions.toString()), TM1MetadataSession.class.getName() + "::getLevelRecords()");
            }
            if (logger.isAuditDebugEventEnabled()) {
                logger.auditDebugEvent(new AuditLogBaseEvent("", "", "", Operation.QUERY, LogDataHelper.createFunctionDebugLogData((String)"execute", (String)"LevelRecordQuery", (String)String.format("Cube Name : %s;  DUN: %s;  HUN: %s;  LUN: %s;  levelNumber: %d", cubeName, dun, hun, lun, levelNumber))));
            }
            List<ILevelRecord> list = query.execute();
            return list;
        }
        finally {
            query.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IMeasureRecord> getMeasureRecords(IRestrictions restrictions) throws TM1Exception {
        String cubeName = restrictions.stringValue("CUBE_NAME", null);
        boolean rootsOnly = restrictions.booleanValue("ROOTS_ONLY", false);
        String lun = restrictions.stringValue("LEVEL_UNIQUE_NAME", null);
        int levelNumber = restrictions.intValue("LEVEL_NUMBER", -1);
        String mun = restrictions.stringValue("MEASURE_UNIQUE_NAME", null);
        EnumSet treeOps = restrictions.enumSetValue("TREEOPS", null);
        boolean includeSelf = false;
        boolean includeChildren = false;
        if (null != treeOps) {
            block7: for (ETreeOp op : treeOps) {
                switch (op) {
                    case SELF: {
                        includeSelf = true;
                        continue block7;
                    }
                    case CHILDREN: {
                        includeChildren = true;
                        continue block7;
                    }
                }
                throw new IllegalArgumentException("Unsupported ETreeOp: " + op.toString());
            }
        } else {
            includeSelf = true;
        }
        MeasureRecordQuery query = new MeasureRecordQuery(this);
        query.setCubeName(cubeName);
        if (-1 != levelNumber) {
            query.setLevelNumber(levelNumber);
        }
        query.setLUN(lun);
        query.setMUN(mun);
        query.setRootsOnly(rootsOnly);
        query.setIncludeSelf(includeSelf);
        query.setIncludeChildren(includeChildren);
        this.setRangeRestrictions(query, restrictions);
        try {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Fetching measure records [CONNECTION_ID=%h, RESTRICTIONS=%s]", System.identityHashCode((Object)this.mConnection), restrictions.toString()), TM1MetadataSession.class.getName() + "::getMeasureRecords()");
            }
            if (logger.isAuditDebugEventEnabled()) {
                logger.auditDebugEvent(new AuditLogBaseEvent("", "", "", Operation.QUERY, LogDataHelper.createFunctionDebugLogData((String)"execute", (String)"MeasureRecordQuery", (String)String.format("Cube Name : %s;  levelNumber: %d;  LUN: %s;  MUN: %s;  includeSelf: %b; includeChildren: %b", cubeName, levelNumber, lun, mun, includeSelf, includeChildren))));
            }
            List<IMeasureRecord> list = query.execute();
            return list;
        }
        finally {
            query.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IMemberRecord> getMemberRecords(IRestrictions restrictions) throws TM1Exception {
        String cubeName = restrictions.stringValue("CUBE_NAME", null);
        String dun = restrictions.stringValue("DIMENSION_UNIQUE_NAME", null);
        String hun = restrictions.stringValue("HIERARCHY_UNIQUE_NAME", null);
        String lun = restrictions.stringValue("LEVEL_UNIQUE_NAME", null);
        int levelNumber = restrictions.intValue("LEVEL_NUMBER", -1);
        String mun = restrictions.stringValue("MEMBER_UNIQUE_NAME", null);
        EnumSet treeOps = restrictions.enumSetValue("TREEOPS", null);
        MemberRecordQuery query = new MemberRecordQuery(this);
        query.setCubeName(cubeName);
        query.setDUN(dun);
        query.setHUN(hun);
        query.setLUN(lun);
        if (-1 != levelNumber) {
            query.setLevelNumber(levelNumber);
        }
        query.setMUN(mun);
        query.setTreeOps(treeOps);
        this.setRangeRestrictions(query, restrictions);
        try {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Fetching member records [CONNECTION_ID=%h, RESTRICTIONS=%s]", System.identityHashCode((Object)this.mConnection), restrictions.toString()), TM1MetadataSession.class.getName() + "::getMemberRecords()");
            }
            if (logger.isAuditDebugEventEnabled()) {
                logger.auditDebugEvent(new AuditLogBaseEvent("", "", "", Operation.QUERY, LogDataHelper.createFunctionDebugLogData((String)"execute", (String)"MemberRecordQuery", (String)String.format("Cube Name : %s;  DUN: %s; HUN: %s;  LUN: %s;  levelNumber: %d;  MUN: %s;  treeOps: %s", cubeName, dun, hun, lun, levelNumber, mun, treeOps != null ? treeOps.toString() : "null"))));
            }
            List<IMemberRecord> list = query.execute();
            return list;
        }
        finally {
            query.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IPropertyRecord> getPropertyRecords(IRestrictions restrictions) throws TM1Exception {
        String cubeName = restrictions.stringValue("CUBE_NAME", null);
        String dun = restrictions.stringValue("DIMENSION_UNIQUE_NAME", null);
        String hun = restrictions.stringValue("HIERARCHY_UNIQUE_NAME", null);
        String lun = restrictions.stringValue("LEVEL_UNIQUE_NAME", null);
        String property = restrictions.stringValue("PROPERTY_NAME", null);
        PropertyRecordQuery query = new PropertyRecordQuery(this);
        query.setCubeName(cubeName);
        query.setDUN(dun);
        query.setHUN(hun);
        query.setLUN(lun);
        query.setPUN(property);
        this.setRangeRestrictions(query, restrictions);
        try {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Fetching property records [CONNECTION_ID=%h, RESTRICTIONS=%s]", System.identityHashCode((Object)this.mConnection), restrictions.toString()), TM1MetadataSession.class.getName() + "::getPropertyRecords()");
            }
            if (logger.isAuditDebugEventEnabled()) {
                logger.auditDebugEvent(new AuditLogBaseEvent("", "", "", Operation.QUERY, LogDataHelper.createFunctionDebugLogData((String)"execute", (String)"PropertyRecordQuery", (String)String.format("Cube Name : %s;  DUN: %s; HUN: %s;  LUN: %s;  Property: %s", cubeName, dun, hun, lun, property))));
            }
            List<IPropertyRecord> list = query.execute();
            return list;
        }
        finally {
            query.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TM1CubeTimestamps getCubeTimestamps(String cubeName) throws TM1Exception {
        Server serverAPI = this.getServer();
        Cube cube = serverAPI.findCube(cubeName);
        if (null == cube) {
            throw new QLSRuntimeException(TM1MessageKeys.MET_CubeNotFound, (Object)cubeName);
        }
        try {
            TM1CubeTimestamps tM1CubeTimestamps = new TM1CubeTimestamps(cube.getLastSchemaUpdate(), cube.getLastDataUpdate());
            return tM1CubeTimestamps;
        }
        finally {
            cube.dispose();
        }
    }

    private void setRangeRestrictions(MetadataQuery<?> query, IRestrictions restrictions) {
        int rangeFrom = restrictions.intValue("FROM", -1);
        int rangeSize = restrictions.intValue("SIZE", -1);
        if (-1 != rangeFrom) {
            query.setRangeFrom(rangeFrom);
        }
        if (-1 != rangeSize) {
            query.setRangeSize(rangeSize);
        }
    }
}

