/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.query;

import com.ibm.cognos.aurora.core.util.UniqueNameGenerator;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.exception.TM1MessageKeys;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Cube;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Dimension;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Hierarchy;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Member;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1MetadataSession;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.query.MetadataQuery;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.util.TM1Utils;
import com.ibm.cognos.tm1.TM1Exception;
import java.util.Collections;
import java.util.List;

public class CubeDefaultMeasureQuery
extends MetadataQuery<String> {
    private String mCubeName;

    public CubeDefaultMeasureQuery(TM1MetadataSession session) {
        super(session);
    }

    public void setCubeName(String cubeName) {
        this.mCubeName = cubeName;
    }

    @Override
    public List<String> execute() throws TM1Exception {
        List<TM1Member> roots;
        TM1Cube cube = this.getLoader().loadCube(this.mCubeName);
        if (null == cube) {
            throw new QLSRuntimeException(TM1MessageKeys.MET_CubeNotFound, (Object)this.mCubeName);
        }
        TM1Dimension measureDimension = cube.getMeasureDimension();
        if (null == measureDimension) {
            return Collections.emptyList();
        }
        TM1Hierarchy measureHier = measureDimension.getDefaultHierarchy();
        if (null == measureHier) {
            throw new QLSRuntimeException(TM1MessageKeys.MET_HierarchyNotFound, (Object)UniqueNameGenerator.createUniqueName((String)measureDimension.getName(), (String)measureDimension.getDefaultHierarchyName()));
        }
        String measureUN = measureHier.getDefaultMemberUN();
        if (!(null != measureUN && measureUN.length() != 0 || (roots = measureHier.getAccessibleRoots()).isEmpty())) {
            measureUN = roots.get(0).getProviderUniqueName();
        }
        if (null != measureUN && measureUN.length() > 0) {
            measureUN = TM1Utils.convertProviderMUNToMDDSMUN(measureHier.getCommonMUNPrefix(), measureUN);
            return Collections.singletonList(measureUN);
        }
        return Collections.emptyList();
    }
}

