/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.query;

import com.ibm.cognos.aurora.api.query.provider.dim.IHierarchyRecord;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.exception.TM1MessageKeys;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.MetadataRecordBuilder;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Cube;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Dimension;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Hierarchy;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1MetadataSession;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.query.MetadataQuery;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.util.TM1Utils;
import com.ibm.cognos.tm1.TM1Exception;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class HierarchyRecordQuery
extends MetadataQuery<IHierarchyRecord> {
    private String mCubeName = null;
    private String mDUN = null;
    private String mHUN = null;

    public HierarchyRecordQuery(TM1MetadataSession session) {
        super(session);
    }

    public void setCubeName(String cubeName) {
        this.mCubeName = cubeName;
    }

    public void setDUN(String dun) {
        this.mDUN = dun;
    }

    public void setHUN(String hun) {
        this.mHUN = hun;
    }

    @Override
    public List<IHierarchyRecord> execute() throws TM1Exception {
        this.checkRangeRestrictions();
        if (null == this.mCubeName) {
            throw new IllegalArgumentException("A cube name was not specified.");
        }
        if (this.mRangeSize < 1) {
            return Collections.emptyList();
        }
        TM1Cube cube = this.getLoader().loadCube(this.mCubeName);
        if (null == cube) {
            throw new QLSRuntimeException(TM1MessageKeys.MET_CubeNotFound, (Object)this.mCubeName);
        }
        ArrayList<TM1Hierarchy> hierarchiesFound = new ArrayList<TM1Hierarchy>();
        if (null != this.mHUN) {
            TM1Hierarchy hierarchy = TM1Utils.findHierarchy(cube, this.mHUN, false);
            if (null != hierarchy) {
                hierarchiesFound.add(hierarchy);
            }
        } else if (null != this.mDUN) {
            TM1Dimension dimension = TM1Utils.findDimension(cube, this.mDUN, false);
            if (null != dimension) {
                hierarchiesFound.addAll(dimension.getHierarchies());
            }
        } else {
            for (TM1Dimension dimension : cube.getDimensions()) {
                hierarchiesFound.addAll(dimension.getHierarchies());
            }
        }
        int effectiveSize = Math.min(this.mRangeSize, hierarchiesFound.size() - this.mRangeFrom);
        if (effectiveSize <= 0) {
            return Collections.emptyList();
        }
        ArrayList<IHierarchyRecord> records = new ArrayList<IHierarchyRecord>(effectiveSize);
        for (int i = this.mRangeFrom; i < this.mRangeFrom + effectiveSize; ++i) {
            records.add((IHierarchyRecord)MetadataRecordBuilder.buildHierarchy((TM1Hierarchy)hierarchiesFound.get(i), this.mSharedFieldIndex));
        }
        return records;
    }

    @Override
    public void release() {
    }
}

