/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.query;

import com.ibm.cognos.aurora.api.query.provider.dim.IMemberRecord;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.query.provider.olap.metadata.MemberRecord;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.exception.TM1MessageKeys;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.MetadataRecordBuilder;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Cube;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Hierarchy;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Member;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1MetadataSession;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.query.MetadataQuery;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.util.TM1Utils;
import com.ibm.cognos.tm1.TM1Exception;
import java.util.ArrayList;
import java.util.List;

public class HierarchyRootMembersQuery
extends MetadataQuery<IMemberRecord> {
    private String mCubeName = null;
    private String mHUN = null;

    public HierarchyRootMembersQuery(TM1MetadataSession session) {
        super(session);
    }

    public void setCubeName(String cubeName) {
        this.mCubeName = cubeName;
    }

    public void setHUN(String hun) {
        this.mHUN = hun;
    }

    @Override
    public List<IMemberRecord> execute() throws TM1Exception {
        if (null == this.mCubeName) {
            throw new IllegalArgumentException("A cube name was not specified.");
        }
        if (null == this.mHUN) {
            throw new IllegalArgumentException("A Hierarchy Unique Name was not specified.");
        }
        TM1Cube cube = this.getLoader().loadCube(this.mCubeName);
        if (null == cube) {
            throw new QLSRuntimeException(TM1MessageKeys.MET_CubeNotFound, (Object)this.mCubeName);
        }
        TM1Hierarchy hierarchy = TM1Utils.findHierarchy(cube, this.mHUN, true);
        List<TM1Member> accessibleRoots = hierarchy.getAccessibleRoots();
        ArrayList<IMemberRecord> records = new ArrayList<IMemberRecord>(accessibleRoots.size());
        for (TM1Member member : accessibleRoots) {
            MemberRecord rec = MetadataRecordBuilder.buildMember(member, this.mSharedFieldIndex);
            rec.setDepth(0);
            records.add((IMemberRecord)rec);
        }
        return records;
    }
}

